; replacement routine for Countout - the numeric display routine

cut_down:
	move.l	(a0)+,d2
.lp:	sub.l	d2,d0
	bpl.b	.lp
	add.l	d2,d0
	rts

word_to_bcd::			; as per 8 digit version following, but only 4 digit - quicker !
	movem.l	d1-d3/a0,-(sp)
	lea	powers_of_ten+16-*-2(PC),a0
	moveq	#2,d1		; counter for loop
	bra.b	win

hex_to_bcd::			; input d0 in hex, output d0 in BCD up to 8 digits (+ve only)
	movem.l	d1-d3/a0,-(sp)
	lea	powers_of_ten-*-2(PC),a0
	moveq	#6,d1		; counter for loop
win:	bsr	cut_down	; lose any really big stuff
	moveq.l	#0,d3
.lp0:	move.l	(a0)+,d2	; power of ten in use
.lp1:	sub.l	d2,d0		; deduct from input result
	bmi.b	.ild		; if -ve then done this power
	addq.l	#1,d3		; increment digit
	bra	.lp1
.ild:	add.l	d2,d0		; reverse last deduction
	asl.l	#4,d3		; shift up ready for next power
	dbra	d1,.lp0
	add.l	d3,d0		; last digit isn't counted up, but just added straight in
	movem.l	(sp)+,d1-d3/a0
	rts

time_to_bcd::			; input a time in frames, output as $00mmssth (minutes, seconds, tenths, hundredths)(frames)
	movem.l	d1-d3/a0,-(sp)
	lea	powers_of_time-*-2(PC),a0
	tst.b	ntsc_type.w
	bne.b	.ntsc
	lea	powers_of_time_pal-powers_of_time(a0),a0
.ntsc:	moveq	#4,d1		; 6 digit output requires 4 loops (units have no loop, and dbra count is n+1)
	bra	win		; use standard code to expand

powers_of_ten:
	dc.l	100000000	; first entry is ONLY for removing stuff to ignore
	dc.l	10000000	
	dc.l	1000000
	dc.l	100000
	dc.l	10000		; this is first entry for the 4 digit version
	dc.l	1000
	dc.l	100
	dc.l	10
	dc.l	1

powers_of_time:			; maximum representable in 16 bits unsigned = 18 min 12.25 seconds
	dc.l	360000		; a hundred minutes - for removal purposes only
	dc.l	36000		; ten minutes
	dc.l	3600		; one minute
	dc.l	600		; ten seconds
	dc.l	60		; one second
	dc.l	6		; 6 60ths make one 10th
	dc.l	1		; nearest appx for hundredths

powers_of_time_pal:
	dc.l	300000		; hundred minutes
	dc.l	30000		; ten minutes
	dc.l	3000		; one minute
	dc.l	500		; ten seconds
	dc.l	50		; one second
	dc.l	5		; one tenth
	dc.l	1

Countout::				; generic decimal number output #d0 at object code #d1, #d2 digits
	data_size =  256		; bytes containing one digit of graphics
	data_shift = 8

	movem.l	d0-d3/a0,-(sp)
	bsr	word_to_bcd
	clr.b	leading_zero.w		; assume leading zeros not to be displayed
	movea.w	#reset_list,a0		; +4 skips counter
	adda.w	d1,a0			; step over objects as necessary

.noex:	moveq	#4,d1
	sub.w	d2,d1		; gives : 0 for 4 digits, 1 for 3, 2 for 2 etc
	asl.w	#2,d1		; multiply up to 0/4/8
	rol.w	d1,d0		; apply rotate to bring the first digit required to top of word
	bra.b	.lpe

.dlp:	rol.w	#4,d0		; put first digit (thousands) into lowest word
	moveq	#$F,d1		; for getting one digit
	and.w	d0,d1		; get digit
	tas	leading_zero.w
	bne.b	.ok		; if already been set then can keep on unchanged
	tst.w	d1		; check for zero digit
	bne.b	.ok
	tst.w	d2		; check for last digit
	beq.b	.ok
	clr.b	leading_zero.w
	add.w	#10,d1		; increment by number of digits to offset for blank one
.ok:	lsl.w	#data_shift,d1	; put to right size
	add.l	#charcs,d1
	asl.l	#8,d1
	moveq.l	#0,d3
	move.w	2(a0),d3
	and.w	#$7ff,d3
	or.l	d1,d3
	move.l	d3,(a0)+
	lea.l	12(a0),a0
.lpe:	dbra	d2,.dlp	

	movem.l	(sp)+,d0-d3/a0
	rts


Timeout::				; timer output system : initially only one timer, blank space, blit into it.
	movem.l	d0-d3/a0,-(sp)
	move.l	race_timer.w,d0
	sub.l	lap_start.w,d0
	bsr	time_to_bcd
	clr.b	leading_zero.w		; leading zeros NOT allowed now
	moveq	#0,d3			; holds x position within space
	moveq	#4,d2			; counter
	asl.l	#8,d0			; put first nibble at top

	bsr	WaitBlit
	move.l	#charcs,A2_BASE		; source base address - use pixel co-ordinates to offset to each number
	move.l	#timerpt,A1_BASE	; destination base address - again use co-ordinates for offsets
	move.l	#(PITCH1|PIXEL16|WID8),A2_FLAGS
	move.l	#(PITCH1|PIXEL16|WID64),A1_FLAGS
	move.l	#$1fff8,A1_STEP		; make output stay in column
	lea	gaps-*-2(PC),a0

.lp:	clr.b	d0
	rol.l	#4,d0
	moveq	#0,d1
	move.b	d0,d1
	tas	leading_zero.w
	bne.b	.ok			; ok if a non-zero digit has already gone through
	tst.b	d1	; THIS KEPT BECAUSE IT MAKES SURE A LEADING 1 DOESN'T BECOME A :
	bne.b	.ok			; no worries about leading zero if this ain't one
;	tst.w	d2	; THIS SECTION REMOVED ALLOWS ONE LEADING BLANK THEN LEADING ZEROS
;	beq.b	.ok			; or if its last digit
;	clr.b	leading_zero.w
	add.b	#10,d1			; 0 blank is digit 10
.ok:	asl.w	#4,d1			; *16 because each digit is stored 16 high
	swap	d1			; because its a y co-ordinate
	move.l	d1,A2_PIXEL		; input pointer
	moveq	#0,d1
	move.w	(a0)+,d1
	move.l	d1,A1_PIXEL		; output pointer
	move.l	#$d0008,B_COUNT
	move.l	#(SRCEN|LFUSRC|UPDA1),B_CMD

	dbra	d2,.lp

	moveq	#1,d2

.lp2:	bsr	WaitBlit2		; used here because no calcs to slow 68000 down
	move.l	#11<<20,A2_PIXEL	; digit 11 is :
	moveq	#0,d1
	move.l	d1,B_PATD
	move.l	d1,B_PATD+4
	move.w	(a0)+,d1
	move.l	d1,A1_PIXEL
	move.l	#$d0008,B_COUNT
	move.l	#(SRCEN|DSTEN|LFUSRC|UPDA1|DCOMPEN),B_CMD

	dbra	d2,.lp2
	clr.l	blitsem.w

	movem.l	(sp)+,d0-d3/a0
	rts	

gaps:	dc.w	0,8,20,28,40,16,36	; last two are positions of colons and have to 4x because of phrase alignment

Timercopy::		; duplicate timer 1 into timer 2 [just graphics] and convert white to yellow/orange
	movem.l	d0-d3/a0-a1,-(sp)
	movea.l	#timerpt,a0
	movea.l	#timer2,a1
	move.w	#$3ff,d1	; counter
	move.w	#$78ff,d2	; test colour
	move.w	#$fdff,d3	; new colour

.lp:	move.w	(a0)+,d0
	cmp.w	d0,d2
	bne.b	.wr
	move.w	d3,d0
.wr:	move.w	d0,(a1)+
	dbra	d1,.lp

	movem.l	(sp)+,d0-d3/a0-a1
	rts

Timer_down::
	movem.l	d0-d1,-(sp)
	move.l	#timo,d0
	move.l	#42,d1
	bsr	set_ypos
	bsr	Timercopy
	movem.l	(sp)+,d0-d1
	rts
