;...................................
;: (c) 1993 Rebellion Software Ltd :
;: Hand coded by R.C.Dibley - 1993 :
;:.................................:

USER0	equ	4*64

.text

IntInit::
	move.l	#Frame,USER0.w	; address for interrupt routine (user0 is the vector address)
	move.w	#509,d0		; ntsc value
	tst.b	ntsc_type.w
	bne.b	.ntsc
	add.w	#100,d0
.ntsc:	move.w	d0,VI		; set to cause interrupt at appropriate place
	move.w	#$303,INT1	; enable video interrupt
	andi	#$f8ff,SR	; enable all interrupt types
	rts

;====================================================================

Frame:
	movem.l	d0-d1/a0-a1,-(sp)	; blat a few registers onto the stack
	move.w	INT1,d0
	btst	#0,d0
	beq.b	.nofrm
	addq.w	#1,counter.w		; increment
	addq.l	#1,seed.w		; for any randomising stuff - never zero'd, and not initialised
	addq.l	#1,race_timer.w
	clr.b	frame_change.w

	bsr	object_reset		; put data addresses back in
	move.w	#$103,INT1		; clears this one, and enables both

.nofrm:	btst	#1,d0
	beq.b	.nr

	clr.b	gpu_int.w

	move.w	#$203,INT1		; clear pending GPU and re-enable both interrupts
.nr:	move.w	d0,INT2			; properly reset interrupts

	movem.l	(sp)+,d0-d1/a0-a1	; get registers back
	rte				; end of interrupt routine

;====================================================================
Nuli::
	move.w	#$300,INT1		; clear any interrupt
	move.w	d0,INT2			; and reset
	rte
;====================================================================

.text
Frame_count::
	clr.w	counter.w		; start counting frames from zero
flop:	border	yellow;,1
	stop #$2000
	border	black;,1
floop::	cmp.w	counter.w,d0		; check against the required number
	bhs	flop			; keep going if not done yet (poor little 68000, we could be talking 10^6 loops here !)
	rts

sync::	stop #$2000
	rts

sync2::	move.w	counter.w,d0		; simple routine to wait until the frame counter
sloop:	cmp.w	counter.w,d0		; clicks over - hence implying that the screen
	beq	sloop			; has finished displaying.
	rts


