;*======================================================================*
;*                TITLE:                  JOYPAD.S                      *
;*                Function:               Joypad Example Code           *
;*                                                                      *
;*                Project #:              JAGUAR                        *
;*                Programmer:             Rob Zdybel                    *
;*                                                                      *
;*                MODIFIED:               Andrew J Burgess  04/13/93    *
;*                                                                      *
;*              COPYRIGHT 1993 Atari Computer Corporation               *
;*          UNAUTHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,        *
;*          PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR          *
;*        THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.       *
;*                            ALL RIGHTS RESERVED.                      *
;*                    YEAH, AND I'LL KICK YOUR ASS TOO...               *
;*                                                                      *
;*======================================================================*
;*                                                                      *
;*   FOR SYLVESTER, THE APPROPRIATE INPUT FOR JOYOUT WOULD CHANGE       *
;*   FROM $7FFx TO $800x.                                               *
;*                                                                      *
;*======================================================================*

.text
readpad::
	movem.l	d0-d3,-(a7)

	move.l	#$f0fffffc,d1		; d1 = Joypad data mask
	moveq.l	#-1,d2			; d2 = Cumulative joypad reading

	move.w	#$80fe,d3		; d3 = Joypad directives and sound mute flag
	add.w	Sound.w,d3		; put in current sound mute flag

	move.w	d3,JOYOUT		; Felix - $7FFx
	move.l	JOYIN,d0		; Read joypad, pause button, A button
	or.l	d1,d0			; Mask off unused bits
	ror.l	#4,d0
	and.l	d0,d2			; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx

	subq.w	#1,d3
	move.w	d3,JOYOUT		; Felix - $7FFx
	move.l	JOYIN,d0		; Read *741 keys, B button
	or.l	d1,d0			; Mask off unused bits
	ror.l	#8,d0
	and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx

	subq.w	#2,d3
	move.w	d3,JOYOUT		; Felix - $7FFx
	move.l	JOYIN,d0		; Read 2580 keys, C button
	or.l	d1,d0			; Mask off unused bits
;	rol.l	#6,d0
;	rol.l	#6,d0
	swap	d0
	ror.l	#4,d0			; this change reduces cycles from 20+20 to 4+16
	and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx

	subq.w	#4,d3
	move.w	d3,JOYOUT		; Felix - $7FFx
	move.l	JOYIN,d0		; Read 369# keys, Option button
	or.l	d1,d0			; Mask off unused bits
	rol.l	#8,d0
	and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369#

;	moveq.l	#-1,d1
;	eor.l	d2,d1			; d1 = Inputs active high
	not.l	d2			; this change reduces cycles from 4+8 to 6

	and.l	key_mask.w,d2		; prevent key_presses working if de-activated

	move.l	joy_cur.w,d0
	move.l	d2,joy_cur.w			; Current joypad reading

; new repeat keys function
	cmp.l	d0,d2			; for ease, and not having to use an extra pile of code, we just test for repeat on ALL keys
	beq.b	.same
	moveq	#8,d1
	move.b	d1,key_repeat_count.w
.noyet:	moveq	#0,d1
	bra.b	.skip
.same:	subq.b	#1,key_repeat_count.w
	bpl.b	.noyet
	addq.b	#2,key_repeat_count.w	; makes repeat rate into alternating
	move.l	d0,d1
.skip:
	eor.l	d2,d0			;	d1 eor	d0 =	then &	d1	=			
	and.l	d2,d0			;	0	0	0	0	0
					;	0	1	1	0	0
					;	1	0	1	1	1	ie only positive edge
					;	1	1	0	1	0
	move.l	d0,joy_edge.w		;joypad, buttons, keys that were just pressed

	or.l	d1,d0			; remainder of repeat key code
	move.l	d0,joy_rep.w		; produces every edge plus the eighth and following if unchanged

	movem.l	(a7)+,d0-d3
	rts


joy_init:				; use once, when keys have been ignored and you only want new presses
	bsr	readpad
	clr.l	joy_edge.w		; prevents keys already held from triggering edge detection
	rts
