;...................................
;: (c) 1993 Rebellion Software Ltd :
;: Hand coded by R.C.Dibley - 1993 :
;:.................................:

; limz.s - containing the limiting z values and pointers to appropriate data for every object
; this data will be permanently in place, for all tracks, and will not change.
; The track data for each track will be flexible, and will contain pointers to this fixed data.
; The object data (points, normals and faces) will be fixed, and will remain for all tracks.

; data structure :	z limit, points, normals, faces
; repeating n times until z limit = 0 is reached
; using this structure it is possible for an object to change to a simpler specification beyond
; a certain distance, but also to disappear before or after a certain distance.
; ALL addresses global because they will be used all over the place
; all data will have to be re-set due to having to relocate from ROM
; hence the sets of objects are separated to allow easy patching

.data

fx:
		dc.l	-1
		dc.l	Lastob - $14
		dc.l	0,0

;============================================================
ptd set 120000		; primary track distance - ie no track pieces visible beyond this value
ftd set 55000		; farther trac distance - where to switch to lower(est) detail

Zlim1::		; marks start of pointers to first set of objects

StrtW::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pstrawf,None,nflat,fstraf
		dc.l	25000,pstrawm,None,nflat,fstram
		dc.l	0,pstrawn,None,nflat,fstran

StrtT::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pstrawft,None,nflat,fstraft
		dc.l	25000,pstrawmt,None,nflat,fstramt
		dc.l	0,pstrawnt,None,nflat,fstrant

StrtV::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pstravf,None,nflat,fstraf
		dc.l	25000,pstravm,None,nflat,fstram
		dc.l	0,pstravn,None,nflat,fstran

;StrtWc::	dc.l	ptd,0,0,0,0
;		dc.l	0,pstrawc,None,nstrawc,fstrawc

Spc0z::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc0z,None,nflat,fstran

Spc1x::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc1x,None,nflat,fstran

Spc1z::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc1z,None,nflat,fstran

Spc2x::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc2x,None,nflat,fspec

Spc2z::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc2z,None,nflat,fstran

Spc3x::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc3x,None,nflat,fstran

Spc3z::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc3z,None,nflat,fspec

Spc4x::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc4x,None,nflat,fstran

Spc4z::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pstrawft,None,nflat,fstraft
		dc.l	0,spc4z,None,nflat,fstrant	; makes darker for use in tunnel

Spc5x::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc5x,None,nflat,fstran

Spc5z::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc5z,None,nflat,fspec

Spc6x::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc6x,None,nflat,fstran

Spc6z::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc6z,None,nflat,fspec

Spc7x::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc7x,None,nflat,fspec

Spc7z::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc7z,None,nflat,fspec

Spc8x::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc8x,None,nflat,fstran

Spc8z::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc8z,None,nflat,fspec

Spc9x::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc9x,None,nflat,fspec

Spc9z::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pspcfar,None,nflat,fspcfar
		dc.l	0,spc9z,None,nflat,fstran

;StrtM::		dc.l	ptd,0,0,0,0
;		dc.l	ftd,pstramf,None,nflat,fstraf
;		dc.l	25000,pstramm,None,nflat,fstram
;		dc.l	0,pstramn,None,nflat,fstran

StrtN::		dc.l	ptd,0,0,0,0
		dc.l	ftd,pstranf,None,nflat,fstraf
		dc.l	25000,pstranm,None,nflat,fstram
		dc.l	0,pstrann,None,nflat,fstran

StrtVW::	dc.l	ptd,0,0,0,0
		dc.l	0,pstravwn,None,nflat,fstran

StrtWV::	dc.l	ptd,0,0,0,0
		dc.l	0,pstrawvn,None,nflat,fstran

StrtVWO::	dc.l	ptd,0,0,0,0
		dc.l	0,pstraqn,None,nflat,fstran

StrtWM::	dc.l	ptd,0,0,0,0
		dc.l	0,pstraxn,None,nflat,fstran

StrtMN::	dc.l	ptd,0,0,0,0
		dc.l	0,pstrayn,None,nflat,fstran

StrtWN::	dc.l	ptd,0,0,0,0
		dc.l	0,pstrazn,None,nflat,fstran

Corn90W::	dc.l	ptd,0,0,0,0
		dc.l	50000,pcrnwf90,None,nflat,fcornf4seg
		dc.l	0,pcrnwn90,None,ncornn90,fcornn90

Corn45W::	dc.l	ptd,0,0,0,0
		dc.l	50000,pcrnwf45,None,nflat,fcornf4seg
		dc.l	0,pcrnwn45,None,ncornn45,fcornn45

Corn30W::	dc.l	ptd,0,0,0,0
		dc.l	50000,pcrnwf30,None,nflat,fcornf4seg
		dc.l	0,pcrnwn30,None,ncornn30,fcornn30

Corn40W::	dc.l	ptd,0,0,0,0
		dc.l	50000,pcrnwf40,None,nflat,fcornf40
		dc.l	0,pcrnwn40,None,nflat,fcornn40

Corn40T::	dc.l	ptd,0,0,0,0
		dc.l	50000,pcrnwf40,None,nflat,fcornf40
		dc.l	0,pcrnwn40t,None,nflat,fcornn40t

Corn20W::	dc.l	ptd,0,0,0,0
		dc.l	50000,pcrnwf20,None,nflat,fcornf2seg
		dc.l	0,pcrnwn20,None,nflat,fcornn10

Corn10W::	dc.l	ptd,0,0,0,0
		dc.l	50000,pcrnwf10,None,nflat,fcornf2seg
		dc.l	0,pcrnwn10,None,nflat,fcornn10

;Corn90M::	dc.l	ptd,0,0,0,0
;		dc.l	0,pcrnmn90,None,ncornn90,fcornn90

;Corn45M::	dc.l	ptd,0,0,0,0
;		dc.l	0,pcrnmn45,None,ncornn45,fcornn45

;Corn30M::	dc.l	ptd,0,0,0,0
;		dc.l	0,pcrnmn30,None,ncornn30,fcornn30

;Corn20M::	dc.l	ptd,0,0,0,0
;		dc.l	0,pcrnmn20,None,nflat,fcornn20


;Corn90N::	dc.l	ptd,0,0,0,0
;		dc.l	0,pcrnnn90,None,ncornn90,fcornn90

;Corn45N::	dc.l	ptd,0,0,0,0
;		dc.l	0,pcrnnn45,None,ncornn45,fcornn45

;Corn30N::	dc.l	ptd,0,0,0,0
;		dc.l	0,pcrnnn30,None,ncornn30,fcornn30

;Corn20N::	dc.l	ptd,0,0,0,0
;		dc.l	0,pcrnnn20,None,nflat,fcornn20

Corn20V::	dc.l	ptd,0,0,0,0
		dc.l	50000,pcrnvf20,None,nflat,fcornf2seg
		dc.l	0,pcrnvn20,None,nflat,fcornn10

Corn10V::	dc.l	ptd,0,0,0,0
		dc.l	50000,pcrnvf10,None,nflat,fcornf2seg
		dc.l	0,pcrnvn10,None,nflat,fcornn10

;Chicane::	dc.l	ptd,0,0,0,0
;		dc.l	0,pchic30,None,ncornn30,fcornn30

;Pit01::		dc.l	ptd,0,0,0,0
;		dc.l	0,ppit01,None,nflat,fpit01

;Pit02::		dc.l	ptd,0,0,0,0
;		dc.l	0,ppit02,None,nflat,fpit02

Pit03::		dc.l	ptd,0,0,0,0
		dc.l	0,ppit03,None,nflat,fpit03

Pit04::		dc.l	ptd,0,0,0,0
		dc.l	0,ppit04,None,nflat,fpit04

Pit05::		dc.l	ptd,0,0,0,0
		dc.l	0,ppit05,None,nflat,fpit05

Pit06::		dc.l	ptd,0,0,0,0
		dc.l	0,ppit06,None,nflat,fpit06

Pit07::		dc.l	ptd,0,0,0,0
		dc.l	0,ppit07,None,nflat,fpit07

Pit08::		dc.l	ptd,0,0,0,0
		dc.l	0,ppit08,None,nflat,fpit08

Pit09::		dc.l	ptd,0,0,0,0
		dc.l	0,ppit09,None,nflat,fpit09

;================================================================

Carpet01::	dc.l	ptd,0,0,0,0
		dc.l	0,pcarpet01,None,nflat,fcarpet01

Carpet02::	dc.l	ptd,0,0,0,0
		dc.l	0,pcarpet02,None,nflat,fcarpet01

Carpet03::	dc.l	ptd,0,0,0,0
		dc.l	0,pcarpet03,None,nflat,fcarpet03

Carpet04::	dc.l	ptd,0,0,0,0
		dc.l	0,pcarpet04,None,nflat,fcarpet01

Carpet05::	dc.l	ptd,0,0,0,0
		dc.l	0,pcarpet05,None,nflat,fcarpet01

Carpet06::	dc.l	ptd,0,0,0,0
		dc.l	0,pcarpet06,None,nflat,fcarpet01

Carpet07::	dc.l	ptd,0,0,0,0
		dc.l	0,pcarpet07,None,nflat,fcarpet01

Carpet08::	dc.l	ptd,0,0,0,0
		dc.l	0,pcarpet08,None,nflat,fcarpet01

Carpet09::	dc.l	ptd,0,0,0,0
		dc.l	0,pcarpet09,None,nflat,fcarpet01

Carpet10::	dc.l	ptd,0,0,0,0
		dc.l	0,pcarpet10,None,nflat,fcarpet01

Carpet11::	dc.l	ptd,0,0,0,0
		dc.l	0,pcarpet11,None,nflat,fcarpet01

Ycar::		dc.l	20000,pcar3,None,ncar3,fcar3		; these are just here to allow the normal generator to work
		dc.l	10000,pcar2,None,ncar2,fcar2		; 
		dc.l	1500,pf1car2,None,nf1car2,ff1car2		; not used anymore because cars are all animated now
		dc.l	0,pcarfront,None,ncarfront,fcarfront		; using 3d wheel animations - but keep just in case

F1shadow::	dc.l	20000,0,0,0,0
		dc.l	0,pf1shadow,None,nflat,ff1shadow

Wheels::	dc.l	1500,0,0,0,0				; only visible CLOSE UP
		dc.l	0,pwheel,None,nwheel,fwheel

Ocar::	;	dc.l	$8000,pcarbit,None,ncarbit,fcarbit
	;	dc.l	$8000,pfarcar,None,nfarcar,ffarcar
	;	dc.l	$4000,pmidcar,None,nmidcar,fmidcar
		dc.l	0,pf1car2,None,nf1car2,ff1car2

;Rebel::	dc.l	0,plogo,None,nlogo,flogo

;Treebit::	dc.l	0,ptreebit,None,ntreebit,ftreebit

;============================================================
; circuit 1 buildings

C1build1::	dc.l	120000,0,0,0,0
		dc.l	0,pc1build1,bc1build1,nc1build1,fc1build1

C1build2::	dc.l	120000,0,0,0,0
		dc.l	0,pc1build2,bc1build2,nc1build2,fc1build2

C1build3::	dc.l	120000,0,0,0,0
		dc.l	0,pc1build3,bc1build3,nc1build3,fc1build3

C1bridge1::	dc.l	120000,0,0,0,0
		dc.l	0,pc1bridge1,bc1bridge1,nc1bridge1,fc1bridge1

C1bridge2::	dc.l	120000,0,0,0,0
		dc.l	0,pc1bridge2,bc1bridge2,nc1bridge2,fc1bridge2

C1bridge3::	dc.l	120000,0,0,0,0
		dc.l	0,pc1bridge3,bc1bridge3,nc1bridge3,fc1bridge3

;============================================================
; circuit 5 buildings

Ihop1::		dc.l	120000,0,0,0,0
		dc.l	0,pih1,None,nih1,fih1

Ihop2::		dc.l	120000,0,0,0,0
		dc.l	0,pih2,None,nih2,fih2

Ihop3::		dc.l	120000,0,0,0,0
		dc.l	0,pih3,None,nih3,fih3

;============================================================
; other one off buildings

Igloo::		dc.l	120000,0,0,0,0
		dc.l	0,pigloo,bigloo,nigloo,figloo

Cactus::	dc.l	120000,0,0,0,0
		dc.l	0,pcactus,None,ncactus,fcactus

Flag1::		dc.l	120000,0,0,0,0
		dc.l	0,pflag,None,nflag,fflag

Flag2::		dc.l	120000,0,0,0,0
		dc.l	0,pflag,None,nflag,fflag2

Flag3::		dc.l	120000,0,0,0,0
		dc.l	0,pflag,None,nflag,fflag3

Lamp1::		dc.l	120000,0,0,0,0
		dc.l	0,plamp1,None,nlamp1,flamp1

Lamp2::		dc.l	120000,0,0,0,0
		dc.l	0,plamp2,None,nlamp2,flamp2

Blimp::		dc.l	220000,0,0,0,0
		dc.l	0,pblimp,None,nblimp,fblimp

Penguin::	dc.l	120000,0,0,0,0
		dc.l	0,ppenguin,None,npenguin,fpenguin

Pitman::	dc.l	180000,0,0,0,0
		dc.l	0,ppitman01,None,npitman01,fpitman01

Babe::		dc.l	180000,0,0,0,0
		dc.l	0,pbabe1,None,nbabe1,fbabe1

Baloon::	dc.l	180000,0,0,0,0
		dc.l	0,pbaloon1,None,nbaloon1,fbaloon1

Bechut::	dc.l	120000,0,0,0,0
		dc.l	0,pbechut,None,nbechut,fbechut

Lightho1::	dc.l	180000,0,0,0,0
		dc.l	0,plightho1,None,nlightho1,flightho1

Lightho2::	dc.l	180000,0,0,0,0
		dc.l	0,plightho2,None,nlightho2,flightho2

;Pterosaur::	dc.l	180000,0,0,0,0
;		dc.l	0,ppterosau,None,npterosau,fpterosau

Minehead::	dc.l	180000,0,0,0,0
		dc.l	0,pminehead,None,nminehead,fminehead

Pictable::	dc.l	120000,0,0,0,0
		dc.l	0,ppictable,None,npictable,fpictable

Plane1::	dc.l	180000,0,0,0,0
		dc.l	0,pplane1,None,nplane1,fplane1

Snowm1::	dc.l	120000,0,0,0,0
		dc.l	0,psnowm1,bsnowm1,nsnowm1,fsnowm1

Skull::		dc.l	120000,0,0,0,0
		dc.l	0,pskull,None,nskull,fskull

Termound::	dc.l	120000,0,0,0,0
		dc.l	0,ptermound,None,ntermound,ftermound

Ufo::		dc.l	180000,0,0,0,0
		dc.l	0,pufo,None,nufo,fufo

Stadium::	dc.l	180000,0,0,0,0
		dc.l	0,pstadium,None,nstadium,fstadium

Pitbuild::	dc.l	180000,0,0,0,0
		dc.l	0,ppitbuild,None,npitbuild,fpitbuild

Pyramidl::	dc.l	180000,0,0,0,0
		dc.l	0,ppyramidl,None,npyramid,fpyramid

Pyramids::	dc.l	180000,0,0,0,0
		dc.l	0,ppyramids,None,npyramid,fpyramid

Jagice1::	dc.l	120000,0,0,0,0
		dc.l	0,pjagice1,bjagice1,njagice1,fjagice1

Jagice2::	dc.l	120000,0,0,0,0
		dc.l	0,pjagice2,bjagice1,njagice2,fjagice2

Jagice3::	dc.l	120000,0,0,0,0
		dc.l	0,pjagice3,bjagice3,njagice3,fjagice3

Icebridge::	dc.l	180000,0,0,0,0
		dc.l	0,picebridge,bicebridge,nicebridge,ficebridge

;============================================================

Build2::	dc.l	130000,0,0,0,0			; from italy
		dc.l	0,pbuild2,bbuild2,nbuild2,fbuild2

Mill::		dc.l	120000,0,0,0,0
		dc.l	0,pmill,bmill,nmill,fmill

Wind::		dc.l	120000,0,0,0,0
		dc.l	0,pwind,None,nwind,fwind

Bridge3::	dc.l	0,pbridge3,bbridge3,nbridge3,fbridge3

Satdish::	dc.l	120000,0,0,0,0
		dc.l	0,psatdish,None,nsatdish,fsatdish

;Dome1::		dc.l	120000,0,0,0,0
;		dc.l	0,pdome1,bdome1,ndome1,fdome1

;Statue1::	dc.l	120000,0,0,0,0
;		dc.l	0,pstatue1,bstatue1,nstatue1,fstatue1

Tree::		dc.l	70000,0,0,0,0
Dtree::		dc.l	100000,0,0,0,0			; allows trees to be input which pop in at 100000 instead of 70000
		dc.l	0,pxtree,bxtree,nxtree,fxtree

Treel::		dc.l	70000,0,0,0,0
		dc.l	0,pdtree,None,ndtree,fdtree

;Bridge1::	dc.l	180000,0,0,0,0
;		dc.l	120000,pfbrdge,None,nfbrdge,ffbrdge
;		dc.l	50000,pbridge1,None,nbridge1,fbridge1
;		dc.l	0,pnbrdge,None,nnbrdge,fnbrdge

Palm1::		dc.l	100000,0,0,0,0
		dc.l	0,ppalm1,None,npalm1,fpalm1

;Hill1::		dc.l	120000,0,0,0,0
;		dc.l	0,phill1,None,nhill1,fhill1
;Hill2::		dc.l	120000,0,0,0,0
;		dc.l	0,phill2,None,nhill2,fhill2
;Hill3::		dc.l	120000,0,0,0,0
;		dc.l	0,phill3,None,nhill3,fhill3
;Hill4::		dc.l	120000,0,0,0,0
;		dc.l	0,phill4,None,nhill4,fhill4

Signr::		dc.l	100000,0,0,0,0			; this 'sign' is the chevron on the corner
		dc.l	0,psignr,None,nsignr,fsignr

Signl::		dc.l	100000,0,0,0,0			; this 'sign' is the chevron on the corner
		dc.l	0,psignl,None,nsignl,fsignl

Lsign::		dc.l	100000,0,0,0,0			; this 'sign' is the overhead gantry type
		dc.l	0,plsign,blsign,nlsign,flsign

Rsign::		dc.l	100000,0,0,0,0
		dc.l	0,prsign,blsign,nrsign,frsign

Hisignr::	dc.l	100000,0,0,0,0
		dc.l	0,phisignr,None,nhisignr,fhisignr

Hisignl::	dc.l	100000,0,0,0,0
		dc.l	0,phisignl,None,nhisignl,fhisignl

Hilite::	dc.l	100000,0,0,0,0
		dc.l	0,pcanylite,None,ncanylite,fcanylite

Hibar1::	dc.l	100000,0,0,0,0
		dc.l	0,pover1,None,nover1,fover1

Hibar2::	dc.l	100000,0,0,0,0
		dc.l	0,pover2,None,nover1,fover1

;Advert:		dc.l	100000,0,0,0,0
;		dc.l	0,padver,None,nadver,fadver

Gantry::	dc.l	130000,0,0,0,0
;		dc.l	0,pgantry,None,ngantry,fgantry	; replaced with new lights
		dc.l	0,plights,blights,nlights,flights

Ibridge1::	dc.l	180000,0,0,0,0
		dc.l	0,pibridge1,bibridge1,nibridge1,fibridge1

Shadbr1::	dc.l	180000,0,0,0,0
		dc.l	0,pshadbr1,None,nshadbr1,fshadbr1

Shadbr3::	dc.l	180000,0,0,0,0
		dc.l	0,pshadbr3,None,nshadbr3,fshadbr3

Shadbd2::	dc.l	180000,0,0,0,0
		dc.l	0,pshadbd2,None,nshadbd2,fshadbd2

;Hole::		dc.l	150000,0,0,0,0
;		dc.l	0,phole,None,nhole,fhole

;Cliff1::	dc.l	150000,0,0,0,0
;		dc.l	0,pclif1,None,nclif1,fclif1
;Cliff2::	dc.l	150000,0,0,0,0
;		dc.l	0,pclif2,None,nclif2,fclif2
;Cliff3::	dc.l	150000,0,0,0,0
;		dc.l	0,pclif3,None,nclif3,fclif3
;Cliff4::	dc.l	150000,0,0,0,0
;		dc.l	0,pclif4,None,nclif4,fclif4
;Cliffl::	dc.l	150000,0,0,0,0
;		dc.l	0,pclifl,None,nclifl,fclifl
;Cliffc::	dc.l	150000,0,0,0,0
;		dc.l	0,pclifc,None,nclifc,fclifc
;Cliffr::	dc.l	150000,0,0,0,0
;		dc.l	0,pclifr,None,nclifr,fclifr

barmax	equ 70000
barmid  equ 35000

Barrier::	dc.l	barmax,0,0,0,0
		dc.l	barmid,pdbar,None,ndbar,fdbar
		dc.l	0,pbarrier,bbarrier,nbarrier,fbarrier

Bar2::		dc.l	barmax,0,0,0,0
		dc.l	barmid,pdbar2,None,ndbar2,fdbar2
		dc.l	0,pbar2,bbarrier,nbar2,fbar2

Bar3::		dc.l	barmax,0,0,0,0
		dc.l	barmid,pdbar3,None,ndbar3,fdbar3
		dc.l	0,pbar3,bbarrier,nbar3,fbar3

NBar01::	dc.l	barmax,0,0,0,0
		dc.l	barmid,pbar01d,None,nbar01d,fbar01d
		dc.l	0,pbar01,bbar01,nbar01,fbar01

NBar01t::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar01t,bbar01t,nbar01t,fbar01t

NBar01y::	dc.l	100000,0,0,0,0		; 100000 because part of bridge is attached
		dc.l	0,pbar01y,bbar01,nbar01y,fbar01y

NBar02::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar02,bbar02,nbar02,fbar02

NBar03::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar03,bbar03,nbar03,fbar03

NBar04::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar04,bbar04,nbar04,fbar04

NBar05::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar05,bbar05,nbar05,fbar05

NBar06::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar06,bbar06,nbar06,fbar06

NBar06y::	dc.l	100000,0,0,0,0
		dc.l	0,pbar06y,bbar06,nbar06y,fbar06y

NBar07::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar07,bbar07,nbar07,fbar07

NBar07y::	dc.l	100000,0,0,0,0
		dc.l	0,pbar07y,bbar07,nbar07y,fbar07y

NBar08::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar08,bbar08,nbar08,fbar08

NBar09::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar09,bbar09,nbar09,fbar09

NBar10::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar10,bbar10,nbar10,fbar10

NBar10y::	dc.l	100000,0,0,0,0
		dc.l	0,pbar10y,bbar10,nbar10y,fbar10y

NBar11::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar11,bbar11,nbar11,fbar11

NBar11y::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar11y,bbar11,nbar11y,fbar11y

NBar12::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar12,bbar12,nbar12,fbar12

NBar13::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar13,bbar13,nbar13,fbar13

NBar14::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar14,bbar14,nbar14,fbar14

NBar15::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar15,bbar15,nbar15,fbar15

NBar16::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar16,bbar16,nbar16,fbar16

NBar17::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar17,bbar17,nbar17,fbar17

NBar18::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar18,bbar18,nbar18,fbar18

NBar19::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar19,bbar19,nbar19,fbar19

NBar20::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar20,bbar20,nbar20,fbar20

NBar21::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar21,bbar01,nbar21,fbar01

NBar22::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar22,bbar20,nbar22,fbar20

NBar23::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar23,bbar23,nbar23,fbar23

NBar24::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar24,bbar23,nbar24,fbar23

NBar25::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar25,bbar27,nbar25,fbar27

NBar26::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar26,bbar01,nbar26,fbar01

NBar27::	dc.l	barmax,0,0,0,0
		dc.l	0,pbar27,bbar27,nbar27,fbar27

WBar::		dc.l	barmax,0,0,0,0
		dc.l	0,pwbar,bwbar,nwbar,fwbar

WBar01::	dc.l	barmax,0,0,0,0
		dc.l	0,pwbar01,bwbar01,nwbar01,fwbar01

WBar02::	dc.l	barmax,0,0,0,0
		dc.l	0,pwbar02,bwbar02,nwbar02,fwbar02

WBar03::	dc.l	barmax,0,0,0,0
		dc.l	0,pwbar03,bwbar03,nwbar03,fwbar03

PBar01::	dc.l	barmax,0,0,0,0
		dc.l	0,ppbar01,bpbar01,npbar01,fpbar01

PBar02::	dc.l	barmax,0,0,0,0
		dc.l	0,ppbar02,bpbar02,npbar02,fpbar02

PBar03::	dc.l	barmax,0,0,0,0
		dc.l	0,ppbar03,bpbar03,npbar03,fpbar03

Roadblock::	dc.l	80000,0,0,0,0
		dc.l	0,proadblock,broadblock,nroadblock,froadblock

;=======================================================
; BRIDGE SUPPORTS and BARRIERS
;=======================================================
.if 1
Aftop::		dc.l	100000,0,0,0,0
		dc.l	0,paftop,None,naftop,faftop
.else
Aftopl::	dc.l	100000,0,0,0,0
		dc.l	0,paftopleft,None,naftopleft,faftopleft

Aftopr::	dc.l	100000,0,0,0,0
		dc.l	0,paftopright,None,naftopright,faftopright
.endif

Afbot::		dc.l	100000,0,0,0,0
		dc.l	0,pafbot,None,nafbot,fafbot

Afshad::	dc.l	100000,0,0,0,0
		dc.l	0,pafshad,None,nflat,fafshad

Brg01::		dc.l	80000,0,0,0,0
		dc.l	0,pbrg01,bbrg01,nbrg01,fbrg01

Brg02::		dc.l	80000,0,0,0,0
		dc.l	0,pbrg02,bbrg02,nbrg02,fbrg02

Brg03::		dc.l	80000,0,0,0,0
		dc.l	0,pbrg03,bbrg03,nbrg03,fbrg03

Brg04::		dc.l	80000,0,0,0,0
		dc.l	0,pbrg04,bbrg04,nbrg04,fbrg04

;=======================================================
; CUTTINGS, HILLS, MOUNTAINS etc
;=======================================================

pcd	set	100000

Cut01::		dc.l	pcd,0,0,0,0
		dc.l	60000,pcut01f,None,ncut01f,fcut01f
		dc.l	0,pcut01,bcut01,ncut01,fcut01

Cut01x::	dc.l	pcd,0,0,0,0
		dc.l	60000,pcut01f,None,ncut01f,fcut01f
		dc.l	0,pcut01x,bcut01x,ncut01x,fcut01x

Cut01y::	dc.l	pcd,0,0,0,0
		dc.l	60000,pcut01f,None,ncut01f,fcut01f
		dc.l	0,pcut01y,bcut01y,ncut01y,fcut01y

Cut01z::	dc.l	pcd,0,0,0,0
		dc.l	60000,pcut01f,None,ncut01f,fcut01f
		dc.l	0,pcut01z,bcut01z,ncut01z,fcut01z

Cut01l::	dc.l	pcd,0,0,0,0
;		dc.l	60000,pcut01f,None,ncut01f,fcut01f
		dc.l	0,pcut01l,bcut01l,ncut01l,fcut01l

Cut01r::	dc.l	pcd,0,0,0,0
;		dc.l	60000,pcut01f,None,ncut01f,fcut01f
		dc.l	0,pcut01r,bcut01r,ncut01r,fcut01r

Cut01a::	dc.l	pcd,0,0,0,0
		dc.l	60000,pcut01f,None,ncut01f,fcut01f
		dc.l	0,pcut01a,bcut01a,ncut01a,fcut01a

Cut01b::	dc.l	pcd,0,0,0,0
		dc.l	60000,pcut01f,None,ncut01f,fcut01f
		dc.l	0,pcut01b,bcut01b,ncut01b,fcut01b

Cut01sp::	dc.l	pcd,0,0,0,0
		dc.l	0,pcut01sp,bcut01,ncut01sp,fcut01

Cut02::		dc.l	pcd,0,0,0,0
		dc.l	0,pcut02,bcut02,ncut02,fcut02

Cut03::		dc.l	pcd,0,0,0,0
		dc.l	0,pcut03,bcut03,ncut03,fcut03

Cut03x::	dc.l	pcd,0,0,0,0
		dc.l	0,pcut03x,bcut03,ncut03x,fcut03x

Cut03y::	dc.l	pcd,0,0,0,0
		dc.l	0,pcut03y,bcut03,ncut03y,fcut03x

Cut03v::	dc.l	pcd,0,0,0,0
		dc.l	0,pcut03v,bcut03v,ncut03v,fcut03v

Cut03xv::	dc.l	pcd,0,0,0,0
		dc.l	0,pcut03xv,bcut03,ncut03xv,fcut03x

Cut03yv::	dc.l	pcd,0,0,0,0
		dc.l	0,pcut03yv,bcut03,ncut03yv,fcut03x

Cut04::		dc.l	pcd,0,0,0,0
		dc.l	0,pcut04,bcut04,ncut04,fcut04

Cut04x::	dc.l	pcd,0,0,0,0
		dc.l	0,pcut04x,bcut04x,ncut04x,fcut04x

Cut04y::	dc.l	pcd,0,0,0,0
		dc.l	0,pcut04y,bcut04y,ncut04y,fcut04y

Cut04l::	dc.l	pcd,0,0,0,0
		dc.l	0,pcut04l,bcut04l,ncut04l,fcut04l

Cut05::		dc.l	pcd,0,0,0,0
		dc.l	0,pcut05,bcut05,ncut05,fcut05

Cut05l::	dc.l	pcd,0,0,0,0
		dc.l	0,pcut05l,bcut05l,ncut05l,fcut05l

Cut06::		dc.l	pcd,0,0,0,0
		dc.l	0,pcut06,bcut06,ncut06,fcut06

Cut07::		dc.l	pcd,0,0,0,0
		dc.l	0,pcut07,bcut07,ncut07,fcut07

Clif01::	dc.l	60000,0,0,0,0
		dc.l	0,pclif01,bclif01,nclif01,fclif01

Clif01l::	dc.l	60000,0,0,0,0
		dc.l	0,pclif01l,bclif01l,nclif01l,fclif01l

Clif01r::	dc.l	60000,0,0,0,0
		dc.l	0,pclif01r,bclif01r,nclif01r,fclif01r

Dhill01::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill01,bdhill01,ndhill01,fdhill01

Dhill01l::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill01l,bdhill01l,ndhill01l,fdhill01l

Dhill01r::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill01r,bdhill01r,ndhill01r,fdhill01r

Dhill01x::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill01x,bdhill01x,ndhill01x,fdhill01x

Dhill01y::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill01y,bdhill01y,ndhill01y,fdhill01y

Dhill01z::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill01z,bdhill01z,ndhill01z,fdhill01z

Dhill01j::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill01j,bcut01l,ncut01l,fcut01l

Dhill01k::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill01k,bcut01r,ncut01r,fcut01r

Dhill02::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill02,bdhill02,ndhill02,fdhill02

Dhill03::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill03,bdhill03,ndhill03,fdhill03

Dhill03x::	dc.l	pcd,0,0,0,0
		dc.l	80000,pdhill03,bdhill03,ndhill03,fdhill03
		dc.l	0,pdhill03x,bdhill03,ndhill03x,fdhill03x

Dhill03y::	dc.l	pcd,0,0,0,0
		dc.l	80000,pdhill03,bdhill03,ndhill03,fdhill03
		dc.l	0,pdhill03y,bdhill03,ndhill03y,fdhill03x

Dhill04::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill04,bdhill04,ndhill04,fdhill04

Dhill05::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill05,bdhill05,ndhill05,fdhill05

Dhill06::	dc.l	pcd,0,0,0,0
		dc.l	0,pdhill06,bdhill06,ndhill06,fdhill06

Vhill01::	dc.l	pcd,0,0,0,0
		dc.l	0,pvhill01,bvhill01,nvhill01,fvhill01

Vhill01l::	dc.l	pcd,0,0,0,0
		dc.l	0,pvhill01l,bvhill01l,nvhill01l,fvhill01l

Vhill01r::	dc.l	pcd,0,0,0,0
		dc.l	0,pvhill01r,bvhill01r,nvhill01r,fvhill01r

Vhill01a::	dc.l	pcd,0,0,0,0
		dc.l	0,pvhill01a,bvhill01a,nvhill01a,fvhill01a

Vhill01b::	dc.l	pcd,0,0,0,0
		dc.l	0,pvhill01b,bvhill01b,nvhill01b,fvhill01b

Vhill01x::	dc.l	pcd,0,0,0,0
		dc.l	0,pvhill01x,bvhill01x,nvhill01x,fvhill01x

Vhill01y::	dc.l	pcd,0,0,0,0
		dc.l	0,pvhill01y,bvhill01y,nvhill01y,fvhill01y

Vhill01z::	dc.l	pcd,0,0,0,0
		dc.l	0,pvhill01z,bvhill01z,nvhill01z,fvhill01z

Dmt01::		dc.l	pcd,0,0,0,0
		dc.l	0,pdmt01,bdmt01,ndmt01,fdmt01

Dmt01l::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt01l,bdmt01l,ndmt01l,fdmt01l

Dmt01r::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt01r,bdmt01r,ndmt01r,fdmt01r

Dmt01p::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt01p,bdmt01p,ndmt01p,fdmt01p

Dmt01q::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt01q,bdmt01q,ndmt01q,fdmt01q

Dmt01x::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt01x,bdmt01x,ndmt01x,fdmt01

Dmt01y::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt01y,bdmt01y,ndmt01y,fdmt01y

Dmt01z::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt01z,bdmt01z,ndmt01z,fdmt01z

Dmt01j::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt01j,bdmt01,ndmt01j,fdmt01

Dmt01k::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt01k,bdmt01,ndmt01k,fdmt01

Dmt02::		dc.l	pcd,0,0,0,0
		dc.l	0,pdmt02,bdmt02,ndmt02,fdmt02

Dmt03::		dc.l	pcd,0,0,0,0
		dc.l	0,pdmt03,bdmt03,ndmt03,fdmt03

Dmt03x::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt03x,bdmt03x,ndmt03x,fdmt03x

Dmt03y::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt03y,bdmt03y,ndmt03y,fdmt03y

Dmt04::		dc.l	pcd,0,0,0,0
		dc.l	0,pdmt04,bdmt04,ndmt04,fdmt04

Dmt04x::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt04x,bdmt04x,ndmt04x,fdmt04x

Dmt04y::	dc.l	pcd,0,0,0,0
		dc.l	0,pdmt04y,bdmt04y,ndmt04y,fdmt04y

;============================================

Mt01::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt01,bmt01,nmt01,fmt01

Mt01l::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt01l,bmt01l,nmt01l,fmt01l

Mt01r::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt01r,bmt01r,nmt01r,fmt01r

Mt01x::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt01x,bmt01x,nmt01x,fmt01x

Mt01y::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt01y,bmt01y,nmt01y,fmt01y

Mt01z::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt01z,bmt01z,nmt01z,fmt01z

Mt01a::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt01a,bmt01a,nmt01a,fmt01a

Mt01b::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt01b,bmt01b,nmt01b,fmt01b

Mt01sp::	dc.l	pcd,0,0,0,0
		dc.l	0,pmt01sp,bmt01,nmt01sp,fmt01

Mt01sp2::	dc.l	pcd,0,0,0,0
		dc.l	0,pmt01sp2,bmt01,nmt01sp2,fmt01

Mt02::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt02,bmt02,nmt02,fmt02

Mt03::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt03,bmt03,nmt03,fmt03

Mt02v::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt02v,bmt02v,nmt02v,fmt02v

Mt03v::		dc.l	pcd,0,0,0,0
		dc.l	0,pmt03v,bmt03v,nmt03v,fmt03v

Mt04::		dc.l	100000,0,0,0,0
		dc.l	70000,pmt04f,None,nmt04f,fmt04f
		dc.l	40000,pmt04m,None,nmt04m,fmt04m
		dc.l	0,pmt04,bmt04,nmt04,fmt04

Mt04x::		dc.l	100000,0,0,0,0
		dc.l	0,pmt04x,bmt04x,nmt04x,fmt04x

Mt04y::		dc.l	100000,0,0,0,0
		dc.l	0,pmt04y,bmt04y,nmt04y,fmt04y

Mt05::		dc.l	100000,0,0,0,0
		dc.l	70000,pmt05f,None,nmt05f,fmt05f
		dc.l	40000,pmt05m,None,nmt05m,fmt05m
		dc.l	0,pmt05,bmt05,nmt05,fmt05

;Mt08::		dc.l	100000,0,0,0,0
;		dc.l	70000,pmt08f,None,nmt08f,fmt08f
;		dc.l	0,pmt08,bmt08,nmt08,fmt08

Mt08v::		dc.l	100000,0,0,0,0
		dc.l	70000,pmt08vf,None,nmt08vf,fmt08vf
		dc.l	40000,pmt08vm,None,nmt08vm,fmt08vm
		dc.l	0,pmt08v,bmt08v,nmt08v,fmt08v

;Mt09::		dc.l	100000,0,0,0,0
;		dc.l	70000,pmt09f,None,nmt09f,fmt09f
;		dc.l	0,pmt09,bmt09,nmt09,fmt09

Mt09v::		dc.l	100000,0,0,0,0
		dc.l	70000,pmt09vf,None,nmt09vf,fmt09vf
		dc.l	40000,pmt09vm,None,nmt09vm,fmt09vm
		dc.l	0,pmt09v,bmt09v,nmt09v,fmt09v

Mt09x::		dc.l	100000,0,0,0,0
		dc.l	70000,pmt09vf,None,nmt09vf,fmt09vf
		dc.l	0,pmt09x,bmt09v,nmt09x,fmt09x

Mt09y::		dc.l	100000,0,0,0,0
		dc.l	70000,pmt09vf,None,nmt09vf,fmt09vf
		dc.l	0,pmt09y,bmt09v,nmt09y,fmt09x

Tun1::		dc.l	140000,0,0,0,0
		dc.l	0,ptun1,btun1,ntun1,ftun1

Surround::	dc.l	140000,0,0,0,0
		dc.l	0,psurround,bsurround,nsurround,fsurround

Tun1b::		dc.l	140000,0,0,0,0
		dc.l	0,ptun1b,None,ntun1b,ftun1b

Tun1s::		dc.l	100000,0,0,0,0
		dc.l	60000,ptun1sf,None,ntun1sf,ftun1sf
		dc.l	0,ptun1s,None,ntun1s,ftun1s

Tun1c40::	dc.l	100000,0,0,0,0
		dc.l	0,ptun1c40,None,ntun1c40,ftun1c40

Lake0::		dc.l	180000,0,0,0,0
		dc.l	0000,pdlake0,None,ndlake0,fdlake0
;		dc.l	0,plake0,None,nlake0,flake0

Lake1::		dc.l	180000,0,0,0,0
		dc.l	60000,pdlake1,None,ndlake1,fdlake1
		dc.l	35000,pmlake1,None,nmlake1,fmlake1
		dc.l	0,plake1,None,nlake1,flake1

Lake2::		dc.l	180000,0,0,0,0
		dc.l	60000,pdlake2,None,ndlake2,fdlake2
		dc.l	35000,pmlake2,None,nmlake2,fmlake2
		dc.l	0,plake2,None,nlake2,flake2

Lake3::		dc.l	180000,0,0,0,0
		dc.l	60000,pdlake3,None,ndlake3,fdlake3
		dc.l	35000,pmlake3,None,nmlake3,fmlake3
		dc.l	0,plake3,None,nlake3,flake3

Lake4::		dc.l	180000,0,0,0,0
		dc.l	0,pdlake4,None,ndlake4,fdlake4
;		dc.l	0,plake4,None,nlake4,flake4

Lake5::		dc.l	180000,0,0,0,0
		dc.l	60000,pdlake5,None,ndlake5,fdlake5
		dc.l	0,plake5,None,nlake5,flake5

Lake6::		dc.l	180000,0,0,0,0
		dc.l	60000,pdlake6,None,ndlake6,fdlake6
		dc.l	0,plake6,None,nlake6,flake6

;Sea0::		dc.l	160000,0,0,0,0
;		dc.l	60000,pdsea0,None,ndsea0,fdsea0
;		dc.l	0,psea0,None,nsea0,fsea0

Sea1::		dc.l	180000,0,0,0,0
		dc.l	60000,pdlake1,None,ndlake1,fdlake1s
		dc.l	35000,pmlake1,None,nmlake1,fmlake1s
		dc.l	0,plake1,None,nlake1,flake1s

;Sea2::		dc.l	160000,0,0,0,0
;		dc.l	60000,pdsea2,None,ndsea2,fdsea2
;		dc.l	35000,pmsea2,None,nmsea2,fmsea2
;		dc.l	0,psea2,None,nsea2,fsea2

Sea3::		dc.l	180000,0,0,0,0
		dc.l	60000,pdlake3,None,ndlake3,fdlake3s
		dc.l	35000,pmlake3,None,nmlake3,fmlake3s
		dc.l	0,plake3,None,nlake3,flake3s

Sea6::		dc.l	160000,0,0,0,0
		dc.l	35000,pdlake6,None,ndlake6,fdlake6s
		dc.l	0,plake6,None,nlake6,flake6s

Shore00::	dc.l	0,pshore00,None,nflat,fshore00

Shore01::	dc.l	0,pshore00,None,nflat,fshore01

Ship1::		dc.l	200000,0,0,0,0
		dc.l	0,pship1,None,nship1,fship1

Yacht1::	dc.l	200000,0,0,0,0
		dc.l	0,pyacht1,None,nyacht1,fyacht1

Distree::	dc.l	80000,0,0,0,0
		dc.l	0,pdistree,None,ndistree,fdistree

Disbuild::	dc.l	0,pdisbuild,None,ndisbuild,fdisbuild

skidmax	equ 50000

Skid::		dc.l	skidmax,0,0,0,0
		dc.l	0,pskid,None,nflat,fskid

Skid2::		dc.l	skidmax,0,0,0,0
		dc.l	0,pskid2,None,nflat,fskid2

Skid3::		dc.l	skidmax,0,0,0,0
		dc.l	0,pskid3,None,nflat,fskid3

Dotted::	dc.l	50000,0,0,0,0
		dc.l	0,pdot,None,nflat,fdot

Line::		dc.l	60000,0,0,0,0
		dc.l	0,pline,None,nflat,fline

Grid::		dc.l	62000,0,0,0,0
		dc.l	0,pgrid,None,nflat,fgrid

Start::		dc.l	62000,0,0,0,0
		dc.l	0,pstart,None,nflat,fstart

Slow::		dc.l	80000,0,0,0,0
		dc.l	0,pslow,None,nflat,fslow

Arrow::		dc.l	80000,0,0,0,0			; this is the flat track arrow
		dc.l	0,parrow,None,nflat,farrow

Rarrow::	dc.l	80000,0,0,0,0
		dc.l	0,pright,None,nflat,fright

Larrow::	dc.l	80000,0,0,0,0
		dc.l	0,pleft,None,nflat,fleft

Lights::	dc.l	90000,0,0,0,0
		dc.l	0,plights,None,nlights,flights

;***************************************************************************************************
;***************************************************************************************************
;***************************************************************************************************

; second object set :

Zlim2::
Ncar::		dc.l	0,pnewcar,None,nnewcar,fnewcar			; these are required for the option menu
Ncar1::		dc.l	0,pnewcar,None,nnewcar,fnewcar_1
Ncar2::		dc.l	0,pnewcar,None,nnewcar,fnewcar_2
Ncar3::		dc.l	0,pnewcar,None,nnewcar,fnewcar_3
Ncar4::		dc.l	0,pnewcar,None,nnewcar,fnewcar_4
Ncar5::		dc.l	0,pnewcar,None,nnewcar,fnewcar_5
Dronecar::	dc.l	0,pnewcar,None,nnewcar,fnewcar_d

Base1::		dc.l	0,pbase1,None,nbase1,fbase1
		dc.l	0,pbase10,None,nbase10,fbase10
		dc.l	0,pbase2,None,nbase2,fbase2
		dc.l	0,pbase3,None,nbase3,fbase3
		dc.l	0,pbase5,None,nbase5,fbase5
		dc.l	0,pbase6,None,nbase6,fbase6
		dc.l	0,pbase4,None,nbase4,fbase4
		dc.l	0,pbase7,None,nbase7,fbase7
		dc.l	0,pbase9,None,nbase9,fbase9
		dc.l	0,pbase8,None,nbase8,fbase8

Satell::	dc.l	0,psatlite,None,nsatlite,fsatlite

AeroLow::	dc.l	0,paero1,None,naero1,faero1
AeroHi::	dc.l	0,paero2,None,naero2,faero2
DryW::		dc.l	0,pdry,None,ndry,fdry
WetW::		dc.l	0,pwet,None,nwet,fwet
Auto::		dc.l	0,pauto,None,nauto,fauto
Manual::	dc.l	0,pmanual,None,nmanual,fmanual
Laparrow::	dc.l	0,plaparrow,None,nlaparrow,flaparrow
Joypad::	dc.l	0,pjoypad,None,njoypad,fjoypad
Clock::		dc.l	60000,0,0,0,0
		dc.l	0,pclock,None,nclock,fclock
Ccup::		dc.l	0,pccup,None,nccup,fccup
SteerW::	dc.l	0,psteer,None,nsteer,fsteer


ZlimE::
Lastob::	dc.l	-1,StrtW,0,0


None::		dc.l	0,0		; trick non-collision zone

