; initial trial for rotating map
; rotate map onto main display screen
; using A2 for destination, scanning pixel by pixel, line by line, across a 128*128 zone of main screen
; using A1 for source, scannin at a fixed angle across the 

Maprot::
	movem.l	d0-d3/a0,-(sp)

	movea.l	#A1_BASE,a0		; both forms use this
	move.b	map_spin.w,d0
	beq.b	.rota			; type 0 is spinning
	cmpi.b	#1,d0
	bne.b	.ex			; type 2 is off - so if not 1 then exit

.stat:	bsr	WaitBlit		; so that blitter is free before anything gets messed up

	move.l	#Mapdisp,(a0)		; address of map

	moveq	#0,d0
	move.l	d0,A1_PIXEL-A1_BASE(a0)
	move.l	d0,A1_CLIP-A1_BASE(a0)
	move.l	d0,B_PATD	;-A1_BASE(a0)
	move.l	d0,B_PATD+4	;-A1_BASE(a0)

	move.l	#(PITCH1|PIXEL16|WID128),A1_FLAGS-A1_BASE(a0)

	move.l	#obj_store,d0		; address of screen
	tst.l	screen.w		; see if needs extra
	bne.b	.ok1
	addq.l	#8,d0
.ok1:	tst.l	viewmove.w
	beq.b	.ok2
	bchg	#3,d0

.ok2:	move.l	d0,A2_BASE-A1_BASE(a0)

	move.l	#(mapyout<<16)|mapxout,A2_PIXEL-A1_BASE(a0)		; set top centred
	move.l	#(PITCH2|PIXEL16|WID320),A2_FLAGS-A1_BASE(a0)
	move.l	#(1<<16)|(-(mapwidth)&$FFFF),A2_STEP-A1_BASE(a0)
	move.l	#(maphi<<16)|mapwidth,B_COUNT-A1_BASE(a0)

	move.l	#(SRCEN|DSTEN|UPDA2|DSTA2|LFUSRC|DCOMPEN),B_CMD-A1_BASE(a0)
	clr.l	blitsem.w		; allow control of blitter up to other routines
.ex:	movem.l	(sp)+,d0-d3/a0
	rts

.rota:	move.w	Genstr+2,d0		; assumes that want to be view aligned not movement aligned
	bsr	get_sine		; needed lots

	bsr	WaitBlit		; so that blitter is free before anything gets messed up

	move.l	#Mapdisp,(a0)		; address of map

	move.l	d1,d0			; copy sine		for rotation of pixel step
	move.l	d2,d3			; copy cosine
	asl.l	#2,d0			; turn into 16.16
	asl.l	#2,d3			; fractions for writing into blitter
	swap	d0			; make Ylo:Yhi
	eor.w	d0,d3
	eor.w	d3,d0
	eor.w	d0,d3			; swap low words to give d3 : XHi:YHi d0 Ylo:Xlo
	swap	d3
	move.l	d3,A1_INC-A1_BASE(a0)
	move.l	d0,A1_FINC-A1_BASE(a0)

	move.l	d1,d0			; copy of sine		this one for line step
	move.l	d2,d3			; copy of cosine
	asl.l	#7,d1			; scale up sine to *128
	asl.l	#7,d2			; scale up cos to *128
	add.l	d2,d0			; = -sin-128cos
	neg.l	d0
	sub.l	d1,d3			; = cos-128sin
	asl.l	#2,d0			; 
	asl.l	#2,d3
	swap	d0			; giving Xlo:Xhi
	eor.w	d0,d3
	eor.w	d3,d0
	eor.w	d0,d3			; swap low words to give d3 : YHi:XHi d0 Xlo:Ylo
	swap	d0
	move.l	d3,A1_STEP-A1_BASE(a0)
	move.l	d0,A1_FSTEP-A1_BASE(a0)

	asr.l	#1,d1			; w sin
	move.l	d1,d0			; 64 sin
	asr.l	#6,d0			; sin
	muls	#48,d0			; h sin
	asr.l	#1,d2			; w cos
	sub.l	d2,d0			; = hsin - wcos
	asl.l	#2,d0			; makes into 16.16
	add.l	#64<<16,d0		; final adjustment to X

	asr.l	#6,d2			; cos
	muls	#48,d2			; h cos
	neg.l	d1
	sub.l	d2,d1			; = -hcos -wsin
	asl.l	#2,d1			; up to 16.16
	add.l	#40<<16,d1		; adjustment to Y

	swap	d0			; giving Xlo:Xhi
	eor.w	d0,d1
	eor.w	d1,d0
	eor.w	d0,d1			; swap low words to give d3 : YHi:XHi d0 Xlo:Ylo
	swap	d0
	move.l	d1,A1_PIXEL-A1_BASE(a0)
	move.l	d0,A1_FPIXEL-A1_BASE(a0)

	move.l	#(PITCH1|PIXEL16|WID128|XADDINC),A1_FLAGS-A1_BASE(a0)
	move.l	#(maphi<<16)|mapwidth,A1_CLIP-A1_BASE(a0)

; now to prepare the destination registers !

	move.l	#obj_store,d0		; address of screen
	tst.l	screen.w		; see if needs extra
	bne.b	.ok
	addq.l	#8,d0
.ok:	tst.l	viewmove.w
	beq.b	.ok3
	bchg	#3,d0
.ok3:	move.l	d0,A2_BASE-A1_BASE(a0)

	move.l	#(mapyout<<16)|mapxout,A2_PIXEL-A1_BASE(a0)		; set top centred
	move.l	#(PITCH2|PIXEL16|WID320|XADDPIX),A2_FLAGS-A1_BASE(a0)
	move.l	#(1<<16)|(-(mapwidth)&$FFFF),A2_STEP-A1_BASE(a0)
	move.l	#(maprothi<<16)|mapwidth,B_COUNT-A1_BASE(a0)
	move.l	#0,B_PATD-A1_BASE(a0)

	move.l	#(SRCEN|DISO_A1|UPDA1F|UPDA1|UPDA2|DSTA2|LFUSRC|DCOMPEN),B_CMD-A1_BASE(a0)

	clr.l	blitsem.w		; allow control of blitter up to other routines
	move.l	#0,A1_CLIP-A1_BASE(a0)

	movem.l	(sp)+,d0-d3/a0
	rts
