;=====================================================
;		DEFINITIONS
;=====================================================

Trace_on	== 0		; 0 = no trace, 1 = trace, 2 = trace and prevent over-shoot
Snail_trail	== 1
Borders		== 0
programmer	== 0
extrascreen	== 0
prog		equ $CF
NEW		=  1
ROMVER		equ 0
finalver	== 0
use_sound	equ	1

GPUM	equ	1
PALyoff		==	54-30

;================================
;  FIXED TABLE ADDRESSES
;================================

Stack 		== $4000	; out of way of everything else, just possibly could crash stub if it overruns

MOBJ		== $4c00	; upper limit for BSS - giving 2K currently
MO2		== $4c08
MO3		== $4c10
tmpstor1	== $4c20	; well clear - needs enough for n points, 8 bytes each, n=<14
tmpstor2	== $4c90

obj_adjust	== $4d00	; small list of objects to 'adjust' for current 'screen'
obj_new_adjust	== $4d80	; second copy for off line build
reset_list	== $4e00	; object reset table - a complete copy of the actual object list
new_list	== $5100	; list is v.small anyway - allow up to $300 = 48 entries if all unscaled bitmaps
use_list	== $5400	; actual list - total 3 copies
anim_list	== $5700	; list for animations - for rain and blinking blob : easily fits in $100
anim_new_list	== $5800	; extra copy so that can be re-built off line

Palette		== $5900	; limit of likely use = $200, giving 256 16 bit colours
CLUT_table	== $5b00	; table for holding CLUT modification requests [serviced by interrupt routine] $100 allocated
				; this table is a looping buffer - FIFO system, where start and end are independent
; spare $400
normal_table	== $6000	; 341 entries max. ($1000 space)
point_2d	== $7000	; allowing up to 512 points maximum = $1000 space
point_3d	== $8000	; maximum 512 points (=$2000 space)
sort_table	== $a000	; reserve $5000 space 
				; this limit is hard-coded in sort.gas
track_table	== $f000	; allocate $500 for storing information about twist to apply to track segments
collide_table	== $F500	; space for storing collision boundary definitions of possible hits
				; _probably_ never more than 4 entries, each with 4 boundary pgons of 4 points
				; giving required space of $140 - allocate $400
				; - permanent data space allocated from $10000 to $50000
;================================
;  ADDITIONAL GPU VALUES
;================================

Gpu_data	== $F03E80	; for transfers to GPU programs
Gpu_flag	== $F03FFC	; for control systems
Gpu_dist	== $F03FF8	; distance to travel in one frame - for collision detector
Gpu_zspd	== $F03FF4	; x and z ratios for use in collision detector
Gpu_xspd	== $F03FF0	; when transforming to travel relative position
Gpu_zpos	== $F03FEC	; x and z position of car (NOT viewpoint) for collision detector
Gpu_xpos	== $F03FE8
				; points between here used by GPU master program
lzworkbuf	== $F03FD8	; Pointer to 8k LZSS Window
lzoutbuf	== $F03FD4	; Pointer of Destination Buffer
lzinbuf		== $F03FD0	; Pointer to Compressed Data

gpustop		== $F03F80	; was MBASE+$10 but now is the very first GPU variable

;================================
; MAJOR STORAGE BLOCKS
;================================

Genstr		== $059000	; room for 3d world design - below this is 'data' segment : all 3d object definitions
Sort_space	== $068000	; note the table works DOWN and requires possibly $800, so keep 3d size down !
Mapdisp		== $068000	; reserve $5000 for map of each track [more if we need to increase size]
Exdisp		== $06d000	; room for display objects $26000 which is enough for one whole screen - assumed contiguous with Mapdisp
sky_store	== $094000	; reserved for sound - changes must be made in redsound.inc
code_space	== $0d6000	; reserving 128K for running code - probably will only need 64K
Trace_table	== $0e6000	; placed here out of way as will be removed when real version made
obj_store	== $0e8000	; now leaves space for 320*280 double buffered screen
bit_store	== $140000	; background strip - bitmapped horizon - 1024*128 = $40000 bytes
end_store	== bit_store + $40000
cockpit		== $180000	; room for a cockpit overlay - 320*100 (=$FA00)
steerwh		== $190000	; steering wheel overlay - 220*64 *14 = $70000 - which fills memory to top

;================================
;  EXTRA BITS
;================================

ibasez		== 256		; projection value = effective screen Z depth

mapwidth	== 128
maphi		== 80
maprothi	== 128
mapxout		== 320-128+8	; was (320-128)/2, for centring
mapyout		== 42+14		; was 0
