;...................................
;: (c) 1993 Rebellion Software Ltd :
;: Hand coded by R.C.Dibley - 1993 :
;:.................................:

; This file contains various sets of objects, ready to be transferred into object processor readable format
; using ObjSetup.  Because at least one set of these needs to be modified, they will be placed in RAM.
; may reconsider this later to save space

.data
.extern ScnSt
ScnSt	==	42		; in half lines
ScnHt	==	261		; in lines
Short	==	232
ScnHf	==	ScnSt + ScnHt	; in half lines
ScnOff	==	ScnSt+1024	; top of screen but off screen until high bit changed

ObjDef0::		; object list definition for startup screen - rebellion logo

	dc.w	3	; four items - logo screen, double layer fade screens

objad:	dc.l	Exdisp		; Address
	dc.w	200		; Height
	dc.w	ScnSt+60	; Y start
	dc.b	0		; Type
	dc.b	0		; Pix Offset
	dc.b	0		; flags - Release, Trans, RMW, Reflect bits in order
	dc.b	0		; CLUT index
	dc.w	80		; IWIDTH = 128 pixels wide
	dc.w	80		; DWIDTH
	dc.b	1		; pitch
	dc.b	4		; depth
	dc.w	0		; X start
objex:

	dc.l	Fanim		; single bit screen cover for fades set to be auto-faded !!!
	dc.w	280
	dc.w	ScnSt
	dc.b	$40,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge

	dc.l	Zeroph		; single bit screen cover for fades, auto fade carries over with no direct link
	dc.w	280
	dc.w	ScnSt
	dc.b	0,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge

ObjDef1::		; object list definition for demo game play

	dc.w	1

ono	set	0

				; MAIN DISPLAY SCREEN
	dc.l	obj_store	; starts off with data address
	dc.w	ScnHt		; Height = 240 (full screen)
	dc.w	ScnSt		; Y start line = 0
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; Reflect, RMW, Release all 0, Trans = 1
	dc.b	0		; CLUT index = 0
	dc.w	80		; 80 phrases = 320 pixels at this size
	dc.w	160		; 2 times as much because of pitch = 2
	dc.b	2		; pitch = 2 = double buffered
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	0		; X start = 0

ObjDef2::		; object list definition for main game play

	dc.w	43+extrascreen	; number of objects in list

ono	set	0

;	dc.l	Zeroph		; starts off with data address
;	dc.w	74		; Height = 44
;	dc.w	ScnSt		; Y start line = start of screen 
;	dc.b	0		; type = 0
;				; phrase 1 completed
;	dc.b	0		; no pixel start offset
;	dc.b	8		; Reflect, Trans, RMW all 0, Release = 1
;	dc.b	0		; CLUT index = 0
;	dc.w	5		; only 80 phrases can be displayed (IWIDTH)
;	dc.w	0		; 512 phrases = 2048 pixels at this size (DWIDTH)
;	dc.b	0		; pitch = 1
;	dc.b	0		; depth = 4 = 16 bits / pixel
;	dc.w	0		; X start = 0

;ono	set	ono +1
Horz	==	ono *16		; pointer into object table

;	dc.l	bit_store	; starts off with data address
;	dc.w	128		; Height = 72 - down to horizon - may need to reconsider if slopes change - maximum is 84 although memory could take more
;	dc.w	ScnSt		; Y start line = start of screen 
;	dc.b	0		; type = 0
;				; phrase 1 completed
;	dc.b	0		; no pixel start offset
;	dc.b	0		; Reflect, Trans, RMW, Release all 0
;	dc.b	0		; CLUT index = 0
;	dc.w	80		; only 80 phrases can be displayed (IWIDTH)
;	dc.w	256		; 256 phrases = 1024 pixels at this size (DWIDTH)
;	dc.b	1		; pitch = 1
;	dc.b	4		; depth = 4 = 16 bits / pixel
;	dc.w	0		; X start = 0

;ono	set	ono +1
				; MAIN DISPLAY SCREEN
	dc.l	obj_store	; starts off with data address
	dc.w	ScnHt		; Height = 240 (full screen)
	dc.w	ScnSt		; Y start line = 0
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; Reflect, RMW, Release all 0, Trans = 1
	dc.b	0		; CLUT index = 0
	dc.w	80		; 80 phrases = 320 pixels at this size
	dc.w	160		; 2 times as much because of pitch = 2
	dc.b	2		; pitch = 2 = double buffered
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	0		; X start = 0

.if 0
Mirror::
ono	set	ono +1
MirrO	== ono*16
	dc.l	left_mirror	; LEFT MIRROR
	dc.w	19		; Height = 19
	dc.w	ScnOff+(2*193)	; Y start line = 0
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	0		; Reflect, RMW, Release all 0, Trans=1
	dc.b	0		; CLUT index = 0
	dc.w	12		; 12 phrases = 48 pixels at this size
	dc.w	12		; ditto
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	26		; X start = 0

ono	set	ono +1
	dc.l	right_mirror	; RIGHT MIRROR
	dc.w	19		; Height = 19
	dc.w	ScnOff+(2*193)	; Y start line = 0
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	0		; Reflect, RMW, Release all 0, Trans=1
	dc.b	0		; CLUT index = 0
	dc.w	12		; 12 phrases = 48 pixels at this size
	dc.w	12		; ditto
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	320-74		; X start = 0
.endif
.if 0
Cover::
ono	set	ono +1
	dc.l	cockpit		; starts off with data address
	dc.w	88		; true Height = 100 (half screen)
	dc.w	ScnOff+(152*2)	; Y start line = start of screen plus 2*line number
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; Reflect, RMW, Release all 0, Trans = 1
	dc.b	0		; CLUT index = 0
	dc.w	80		; 320 pixels
	dc.w	80		; 
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	0		; X start = 0
.endif
Steer::
ono	set	ono +1
StrO	==	ono*16
	dc.l	steerwh		; starts off with data address
	dc.w	63		; Height = 74
	dc.w	ScnOff+(177*2)	; Y start line = start of screen plus 2*line number
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; Reflect, RMW, Release all 0, Trans = 1
	dc.b	0		; CLUT index = 0
	dc.w	55		; 220 pixels
	dc.w	55		; 
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	50		; X start = 0
;============= no more objects before this point - it messes other stuff up

ono	set	ono +1
Rono	==	ono<<4
	dc.l	Ranim		; starts off with data address
	dc.w	ScnHt		; Height = full screen
	dc.w	ScnSt		; Y start line = start of screen plus 2*line number
	dc.b	$40		; type = 0 (animated)
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	$E		; RMW, trans, release
	dc.b	1		; CLUT index = 1
	dc.w	6		; 384 pixels - so that you won't get clear edge when using pixel offset
	dc.w	5		; 320 pixels
	dc.b	1		; pitch = 1
	dc.b	0		; depth = 0 = 1 bit / pixel
	dc.w	0		; X start = 0
.if 0
ono	set	ono +1		; MAP DISPLAY
	dc.l	Mapdisp		; starts off with data address
	dc.w	80		; Height = map size
	dc.w	ScnSt		; Y start line = start of screen plus 2*line number
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; RMW, trans, release
	dc.b	0		; CLUT index = 0
	dc.w	32		; 128 pixels
	dc.w	32		; 
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	96		; X start = 0
.endif
BLOB::				; needed to allow modification of object list prior to generating screen - to allow animated blob
ono	set	ono +1		; MAP DISPLAY
blono	==	ono<<4
	dc.l	Blobc0		; starts off with data address
	dc.w	5		; Height = small
	dc.w	ScnSt		; Y start line = start of screen plus 2*line number
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; RMW, trans, release
	dc.b	0		; CLUT index = 0
	dc.w	2		; 8 pixels
	dc.w	2		; 
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	120		; X start = 0

ono	set	ono +1		; MAP DISPLAY
	dc.l	Blobc0+80	; starts off with data address
	dc.w	5		; Height = small
	dc.w	ScnSt		; Y start line = start of screen plus 2*line number
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; RMW, trans, release
	dc.b	0		; CLUT index = 0
	dc.w	2		; 8 pixels
	dc.w	2		; 
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	120		; X start = 0

ono	set	ono +1		; MAP DISPLAY
	dc.l	Blobc0+160	; starts off with data address
	dc.w	5		; Height = small
	dc.w	ScnSt		; Y start line = start of screen plus 2*line number
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; RMW, trans, release
	dc.b	0		; CLUT index = 0
	dc.w	2		; 8 pixels
	dc.w	2		; 
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	120		; X start = 0

ono	set	ono +1		; MAP DISPLAY
	dc.l	Blobc0+240	; starts off with data address
	dc.w	5		; Height = small
	dc.w	ScnSt		; Y start line = start of screen plus 2*line number
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; RMW, trans, release
	dc.b	0		; CLUT index = 0
	dc.w	2		; 8 pixels
	dc.w	2		; 
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	120		; X start = 0

ono	set	ono +1		; MAP DISPLAY
	dc.l	Blobc0+320	; starts off with data address
	dc.w	5		; Height = small
	dc.w	ScnSt		; Y start line = start of screen plus 2*line number
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; RMW, trans, release
	dc.b	0		; CLUT index = 0
	dc.w	2		; 8 pixels
	dc.w	2		; 
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	120		; X start = 0

ono	set	ono +1		; MAP DISPLAY
	dc.l	Blobc0+400	; starts off with data address
	dc.w	5		; Height = small
	dc.w	ScnSt		; Y start line = start of screen plus 2*line number
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; RMW, trans, release
	dc.b	0		; CLUT index = 0
	dc.w	2		; 8 pixels
	dc.w	2		; 
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	120		; X start = 0

ono	set	ono +1		; MAP DISPLAY - ring around your car
	dc.l	Ring		; starts off with data address
	dc.w	14		; Height = small
	dc.w	ScnSt		; Y start line = start of screen plus 2*line number
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; RMW, trans, release
	dc.b	0		; CLUT index = 0
	dc.w	3		; 8 pixels
	dc.w	4		; 
	dc.b	1		; pitch = 1
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	120		; X start = 0

;====================================================================

chrw	equ	2	; 8 pixels = 2 phrases
chrh	equ	13	; to cover all of shape
spds	equ	ScnSt+(12*2)
chrs	equ	spds+(16*2)
spdx	equ	10+48+8

Speedo::	; to allow direct modification without searching table

ono	set	ono +1
spono	==	ono<<4
	dc.l	charcs+$a00
	dc.w	chrh
	dc.w	spds	; 
	dc.b	0	; type 0, on
	dc.b	0
	dc.b	4	; trans	
	dc.b	0
	dc.w	chrw
	dc.w	chrw
	dc.b	1
	dc.b	4
	dc.w	spdx	; first character position

ono	set	ono +1
	dc.l	charcs+$a00
	dc.w	chrh
	dc.w	spds	; 
	dc.b	0	; type 0, but off
	dc.b	0
	dc.b	4	; trans
	dc.b	0
	dc.w	chrw
	dc.w	chrw
	dc.b	1
	dc.b	4
	dc.w	spdx+8	; 2nd character position

ono	set	ono +1
	dc.l	charcs
	dc.w	chrh
	dc.w	spds	; 
	dc.b	0	; type 0, but off
	dc.b	0
	dc.b	4	; trans
	dc.b	0
	dc.w	chrw
	dc.w	chrw
	dc.b	1
	dc.b	4
	dc.w	spdx+16	; 3rd character position

ono	set	ono +1
	dc.l	spdpt	; text saying 'speed'
	dc.w	chrh
	dc.w	spds
	dc.b	0
	dc.b	0
	dc.b	4
	dc.b	0
	dc.w	11	; 48 pixels wide
	dc.w	12
	dc.b	1
	dc.b	4
	dc.w	spdx-48

ono	set	ono +1
	dc.l	mphpt	; text saying 'mph'
	dc.w	chrh
	dc.w	spds
	dc.b	0
	dc.b	0
	dc.b	4
	dc.b	0
	dc.w	8
	dc.w	10
	dc.b	1
	dc.b	4
	dc.w	spdx+28

ono	set	ono +1
	dc.l	pospt	; text saying 'position' 
	dc.w	13
	dc.w	spds
	dc.b	0
	dc.b	0
	dc.b	4
	dc.b	0
	dc.w	16
	dc.w	16
	dc.b	1
	dc.b	4
	dc.w	244-32-8

ono	set	ono +1
	dc.l	slashpt	; text saying '/' next to the position text
	dc.w	13
	dc.w	spds
	dc.b	0
	dc.b	0
	dc.b	4
	dc.b	0
	dc.w	4
	dc.w	4
	dc.b	1
	dc.b	4
	dc.w	244+40-8

ono	set	ono +1
	dc.l	gearpt	; text saying 'gear'
	dc.w	chrh
	dc.w	chrs
	dc.b	0
	dc.b	0
	dc.b	4
	dc.b	0
	dc.w	9
	dc.w	10
	dc.b	1
	dc.b	4
	dc.w	spdx-40

ono	set	ono +1
	dc.l	lappt	; text saying 'lap'
	dc.w	chrh
	dc.w	chrs
	dc.b	0
	dc.b	0
	dc.b	4
	dc.b	0
	dc.w	7
	dc.w	8
	dc.b	1
	dc.b	4
	dc.w	$d4-8

ono	set	ono +1
lapono	==	ono<<4
	dc.l	charcs	; lap number
	dc.w	chrh
	dc.w	chrs
	dc.b	0,0,4,0
	dc.w	chrw,chrw
	dc.b	1,4
	dc.w	244-8	; first character position

ono	set	ono +1
	dc.l	charcs	; lap number
	dc.w	chrh
	dc.w	chrs
	dc.b	0,0,4,0
	dc.w	chrw,chrw
	dc.b	1,4
	dc.w	244+8-8	; second character position

ono	set	ono +1
pono	==	ono<<4
	dc.l	charcs	; position number
	dc.w	chrh
	dc.w	spds
	dc.b	0,0,4,0
	dc.w	chrw,chrw
	dc.b	1,4
	dc.w	244+32-8	; first character position

ono	set	ono +1
nono	==	ono<<4
	dc.l	charcs	; num players number
	dc.w	chrh
	dc.w	spds
	dc.b	0,0,4,0
	dc.w	chrw,chrw
	dc.b	1,4
	dc.w	244+50-8	; first character position

ono	set	ono +1
gono	==	ono<<4
	dc.l	charcs	; gear number
	dc.w	chrh
	dc.w	chrs
	dc.b	0,0,4,0
	dc.w	chrw,chrw
	dc.b	1,4
	dc.w	spdx	; first character position

ono	set	ono +1
revno	==	ono<<4
xst	set	12
yst	set	spds+110+1024

	dc.l	block1		; starts off with data address
	dc.w	16		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1
xst	set	xst+7

	dc.l	block2		; starts off with data address
	dc.w	16		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1
xst	set	xst+7

	dc.l	block3		; starts off with data address
	dc.w	16		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1
xst	set	xst+7

	dc.l	block4		; starts off with data address
	dc.w	16		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1
xst	set	xst+7
yst	set	yst-2

	dc.l	block5		; starts off with data address
	dc.w	16		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1
xst	set	xst+7
yst	set	yst-4

	dc.l	block6		; starts off with data address
	dc.w	16		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1
xst	set	xst+7
yst	set	yst-8

	dc.l	block7		; starts off with data address
	dc.w	24		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1
xst	set	xst+7
yst	set	yst-8

	dc.l	block8		; starts off with data address
	dc.w	24		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1
xst	set	xst+7
yst	set	yst-12

	dc.l	block9		; starts off with data address
	dc.w	32		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1
xst	set	xst+7
yst	set	yst-12

	dc.l	blocka		; starts off with data address
	dc.w	40		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1
xst	set	xst+7
yst	set	yst-16

	dc.l	blockb		; starts off with data address
	dc.w	48		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1
xst	set	xst+7
yst	set	yst-24

	dc.l	blockc		; starts off with data address
	dc.w	56		; Height = small
	dc.w	yst		; Y start line = start of screen plus 2*line number
	dc.b	0,0,4,0		; type = 0, no pixel offset, trans, clut 0
	dc.w	4,4		; 16 pixels
	dc.b	1,4		; pitch = 1, depth = 4 = 16 bits / pixel
	dc.w	xst		; X start = 0

ono	set	ono +1

	dc.l	timer2		; initially behind timer 1
	dc.w	13		; may have to be 16
	dc.w	ScnSt+(28*2)	; n lines from top
	dc.b	0,0,4,0		; standard transparent
	dc.w	16,16		; 64 pixels
	dc.b	1,4
	dc.w	264-8		; aligned with 'position'

ono	set	ono +1
timo	==	ono<<4

	dc.l	timerpt
	dc.w	13		; may have to be 16
	dc.w	ScnSt+(28*2)	; n lines from top
	dc.b	0,0,4,0		; standard transparent
	dc.w	16,16		; 64 pixels
	dc.b	1,4
	dc.w	264-8		; aligned with 'position'

ono	set	ono +1
pauso	==	ono<<4

	dc.l	Exdisp		; where pause is permanently held
	dc.w	40		; 
	dc.w	ScnSt+(80*2)+1024	; n lines from top
	dc.b	0,0,4,0		; standard transparent
	dc.w	32,32		; 128 pixels
	dc.b	1,4
	dc.w	96		; centrally placed

ono	set	ono +1
soundo	==	ono<<4

	dc.l	Exdisp+$15e40		; where pause is permanently held
	dc.w	$78		; 
	dc.w	ScnSt+(60*2)+1024	; n lines from top
	dc.b	0,0,0,0		; non-transparent
	dc.w	$38,$38		; 128 pixels
	dc.b	1,4
	dc.w	48		; centrally placed

ono	set	ono +1
	dc.l	FX_ph		; where fx slider is permanently held
	dc.w	8		; 
	dc.w	ScnSt+(116*2)+1024
	dc.b	0,0,4,4		; standard trans, clut 4
	dc.w	1,0		; 128 pixels
	dc.b	1,0
	dc.w	168	

ono	set	ono +1
	dc.l	Music_ph	; where music slider is permanently held
	dc.w	8		; 
	dc.w	ScnSt+(148*2)+1024	; n lines from top
	dc.b	0,0,4,5		; standard transparent
	dc.w	1,0		; 128 pixels
	dc.b	1,0
	dc.w	168	

ono	set	ono +1
hilio	==	ono<<4

	dc.l	Redbox		; currently unknown
	dc.w	24		; 
	dc.w	ScnSt+(161*2)+1024	; n lines from top
	dc.b	0,0,4,0		; non-transparent
	dc.w	$10,$10		; 128 pixels
	dc.b	1,4
	dc.w	64




objlen	==	objex - objad	; length for use elsewhere
.extern objlen

;======================================================================================================================

.include 'grsize.inc'
ObjDef3::		; object list definition for option screen 1

	dc.w	24

	dc.l	obj_store	; starts off with data address
	dc.w	ScnHt		; Height = 240 (full screen)
	dc.w	ScnSt		; Y start line = 0
	dc.b	0,0,4,0
	dc.w	80,160		; DWIDTH is 2 times as much because of pitch = 2
	dc.b	2		; pitch = 2 = double buffered
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	0		; X start = 0

yoffst	set 4
	dc.l	cockpit		; allows expansion into space without overwriting startup screen
	dc.w	36
	dc.w	ScnSt+yoffst+8
	dc.b	0,0,4,0
	dc.w	80,80		; full screen wide
	dc.b	1,4
	dc.w	12

.dad	set	cockpit+menu_top

	dc.l	.dad		; vertical strip up side
	dc.w	186
	dc.w	ScnSt+(2*36)+yoffst	; to attach to top strip
	dc.b	0,0,4,0
	dc.w	16,16		; 64 * 188
	dc.b	1,4
	dc.w	12

.yht	set	36
.xst	set	46
.hite	set	16
.gap	set	2
.pw	set	22	; phrase width (=92 pixels)
.dstep	set	.pw * $80	; 16 lines of phrases = $80 bytes, so this gives byte offset 
.dad	set	.dad+menu_top2+menu_side		; leaves space for alternative top bar

	dc.l	.dad			; 'colour'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+.dstep		; 'weather'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(2*.dstep)		; 'aerofoil'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(3*.dstep)		; 'tyres'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(4*.dstep)		; 'gearing'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(5*.dstep)		; 'drones'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(6*.dstep)		; 'race'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(7*.dstep)		; 'laps'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(8*.dstep)		; 'track'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	36
.xst	set	125
.hite	set	16
.gap	set	2
.pw	set	12			; phrase width (=52 pixels)
.dstep	set	.pw * $80		; 16 lines of phrases = $80 bytes, so this gives byte offset 
.dad	set	.dad + menu_options

	dc.l	.dad			; first colour button
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.dad	set	.dad + menu_colours		; skip colour buttons

.yht	set	.yht+.hite+.gap
	dc.l	.dad			; first option
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(.dstep*4)		; 2nd option
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(.dstep*6)		; 3rd option
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
.dad	set	.dad + menu_small
.pw	set	24	; phrase width (=100 pixels)
.dstep	set	.pw * $80	; 16 lines of phrases = $80 bytes, so this gives byte offset 

	dc.l	.dad		; 5th option 
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.pw	set	12
.yht	set	.yht+.hite+.gap
	dc.l	.dad+menu_medium+menu_race	; 6th option - new, now points at blank button
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
.dad	set	.dad + menu_medium
.pw	set	34			; phrase width (=140 pixels)
.dstep	set	.pw * $80		; 16 lines of phrases = $80 bytes, so this gives byte offset 

	dc.l	.dad			; 7th option
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
.dad	set	.dad + menu_race
.pw	set	12			; phrase width (=140 pixels)
.dstep	set	.pw * $80		; 16 lines of phrases = $80 bytes, so this gives byte offset 

	dc.l	.dad			; 8th option
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
.dad	set	.dad + menu_blank
.pw	set	34			; phrase width (=140 pixels)
.dstep	set	.pw * $80		; 16 lines of phrases = $80 bytes, so this gives byte offset 

	dc.l	.dad			; 9th option
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht-.hite-.gap		; get back to height of previous 
.dad	set	.dad + menu_track + config_all		; font is installed right after the track stuff and the new stuff !!
.pw	set	3
.xst	set	.xst + 14

	dc.l	.dad			;  high lap digit
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.xst	set	.xst + 10

	dc.l	.dad			; low lap digit
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht-(2*(.hite+.gap))			; get back to height of previous 
.pw	set	3
.xst	set	.xst - 10

	dc.l	.dad			;  drone digit
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst


ObjDef4::		; object list definition for titles - flag background, cart clear text, copyright text, anim overlay, 3d layer, fade overlay

	dc.w	7		; using a fade thingy as well

ono set 0
	dc.l	Exdisp		; Address
	dc.w	224		; Height
	dc.w	ScnSt		; Y start
	dc.b	0		; Type
	dc.b	0		; Pix Offset
	dc.b	0		; flags - Release, Trans, RMW, Reflect bits in order
	dc.b	0		; CLUT index
	dc.w	80		; IWIDTH = 128 pixels wide
	dc.w	80		; DWIDTH
	dc.b	1		; pitch
	dc.b	4		; depth
	dc.w	0		; X start

ono set ono+1
	dc.l	cockpit		; Address
	dc.w	24		; Height
	dc.w	ScnSt+356+1024	; Y start
	dc.b	0		; Type
	dc.b	0		; Pix Offset
	dc.b	4		; flags - Release, Trans, RMW, Reflect bits in order
	dc.b	0		; CLUT index
	dc.w	80		; IWIDTH = 128 pixels wide
	dc.w	80		; DWIDTH
	dc.b	1		; pitch
	dc.b	4		; depth
	dc.w	0		; X start

ono set ono+1
	dc.l	Exdisp+$23000	; Address	copyright notice
	dc.w	20		; Height
	dc.w	448		; Y start
	dc.b	0		; Type
	dc.b	0		; Pix Offset
	dc.b	4		; flags - Release, Trans, RMW, Reflect bits in order
	dc.b	0		; CLUT index
	dc.w	50		; IWIDTH = 200 pixels wide
	dc.w	50		; DWIDTH
	dc.b	1		; pitch
	dc.b	4		; depth
	dc.w	60		; X start

ono set ono+1
	dc.l	bit_store	; starts off with data address
	dc.w	224-36		; Height = 240 (full screen) - also adjusted to prevent odd effects
	dc.w	ScnSt		; Y start line = 0
	dc.b	0		; type = 0
	dc.b	0		; no pixel start offset
	dc.b	4		; Reflect, RMW, Release all 0, Trans = 1
	dc.b	0		; CLUT index = 0
	dc.w	80		; 80 phrases = 320 pixels at this size
	dc.w	80		; 2 times as much because of pitch = 2
	dc.b	1		; pitch = 2 = double buffered
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	4		; X start = 4 because graphics not quite centred

ono set ono+1
	dc.l	obj_store+$19000	; starts off with data address
	dc.w	224-8-80		; Height = 240 (full screen)
	dc.w	ScnSt		; Y start line = 0
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; Reflect, RMW, Release all 0, Trans = 1
	dc.b	0		; CLUT index = 0
	dc.w	80		; 80 phrases = 320 pixels at this size
	dc.w	160		; 2 times as much because of pitch = 2
	dc.b	2		; pitch = 2 = double buffered
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	0		; X start = 0

ono set ono+1
	dc.l	Fanim		; single bit screen cover for fades
	dc.w	280
	dc.w	ScnSt
	dc.b	$40,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge

	dc.l	Zeroph		; single bit screen cover for fades
	dc.w	280
	dc.w	ScnSt
	dc.b	0,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge


ObjDef4a::		; object list definition for titles -  modified for PAL

	dc.w	7		; using a fade thingy as well

ono set 0
	dc.l	Exdisp		; Address
	dc.w	224		; Height
	dc.w	ScnSt		; Y start
	dc.b	1		; Type
	dc.b	0		; Pix Offset
	dc.b	0		; flags - Release, Trans, RMW, Reflect bits in order
	dc.b	0		; CLUT index
	dc.w	80		; IWIDTH = 128 pixels wide
	dc.w	80		; DWIDTH
	dc.b	1		; pitch
	dc.b	4		; depth
	dc.w	0		; X start
	dc.b	32,38,32	; double height

ono set ono+2
	dc.l	cockpit		; Address
	dc.w	24		; Height
	dc.w	ScnSt+356+1024+60	; Y start
	dc.b	0		; Type
	dc.b	0		; Pix Offset
	dc.b	4		; flags - Release, Trans, RMW, Reflect bits in order
	dc.b	0		; CLUT index
	dc.w	80		; IWIDTH = 128 pixels wide
	dc.w	80		; DWIDTH
	dc.b	1		; pitch
	dc.b	4		; depth
	dc.w	0		; X start

ono set ono+1
	dc.l	Exdisp+$23000	; Address	copyright notice
	dc.w	20		; Height
	dc.w	448+90		; Y start
	dc.b	0		; Type
	dc.b	0		; Pix Offset
	dc.b	4		; flags - Release, Trans, RMW, Reflect bits in order
	dc.b	0		; CLUT index
	dc.w	50		; IWIDTH = 200 pixels wide
	dc.w	50		; DWIDTH
	dc.b	1		; pitch
	dc.b	4		; depth
	dc.w	60		; X start

ono set ono+1
	dc.l	bit_store	; starts off with data address
	dc.w	ScnHt-36	; Height = 240 (full screen) - also adjusted to prevent odd effects
	dc.w	ScnSt		; Y start line = 0
	dc.b	0		; type = 0
	dc.b	0		; no pixel start offset
	dc.b	4		; Reflect, RMW, Release all 0, Trans = 1
	dc.b	0		; CLUT index = 0
	dc.w	80		; 80 phrases = 320 pixels at this size
	dc.w	80		; 2 times as much because of pitch = 2
	dc.b	1		; pitch = 2 = double buffered
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	-2		; X start = 4 because graphics not quite centred

ono set ono+1
	dc.l	obj_store+$f000	; starts off with data address
	dc.w	ScnHt-8-80+32	; Height = 240 (full screen)
	dc.w	ScnSt		; Y start line = 0
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; Reflect, RMW, Release all 0, Trans = 1
	dc.b	0		; CLUT index = 0
	dc.w	80		; 80 phrases = 320 pixels at this size
	dc.w	160		; 2 times as much because of pitch = 2
	dc.b	2		; pitch = 2 = double buffered
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	0		; X start = 0

ono set ono+1
	dc.l	Fanim		; single bit screen cover for fades
	dc.w	280
	dc.w	ScnSt
	dc.b	$40,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge

	dc.l	Zeroph		; single bit screen cover for fades
	dc.w	280
	dc.w	ScnSt
	dc.b	0,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge


Objdef5::
	dc.w	13		; option screen 2 - including key config etc

	dc.l	obj_store	; starts off with data address	3d background just like main option screen
	dc.w	ScnHt		; Height = 240 (full screen)
	dc.w	ScnSt		; Y start line = 0
	dc.b	0,0,4,0
	dc.w	80,160		; DWIDTH is 2 times as much because of pitch = 2
	dc.b	2		; pitch = 2 = double buffered
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	0		; X start = 0

yoffst	set 4
	dc.l	cockpit+menu_top+menu_side	; top bar is now replaced with the configure bar
	dc.w	36
	dc.w	ScnSt+yoffst+8
	dc.b	0,0,4,0
	dc.w	80,80	
	dc.b	1,4
	dc.w	12

	dc.l	cockpit+menu_top		; vertical strip up side is still the same
	dc.w	186
	dc.w	ScnSt+(2*36)+yoffst
	dc.b	0,0,4,0
	dc.w	16,16	
	dc.b	1,4
	dc.w	12

.yht	set	64		; start buttons at same position - can always move later
.xst	set	46
.hite	set	16
.gap	set	2
.pw	set	33;27
.dstep	set	.pw * $80
.dad	set	cockpit + menu_top + menu_side + menu_top2 + all_buttons	; skips over all the other buttons

	dc.l	.dad			; 'accelerate'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+.dstep		; 'brake'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(2*.dstep)		; 'cruise'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+(3*(.hite+.gap))	; two extra row gaps
	dc.l	.dad+(3*.dstep)		; 'track map'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(4*.dstep)		; 'tachometer'
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst


.yht	set	64
.xst	set	166;141
.hite	set	16
.gap	set	2
.pw	set	$e			; phrase width (=52 pixels)
.dstep	set	.pw * $80		; 16 lines of phrases = $80 bytes, so this gives byte offset 
.dad	set	.dad + config_options

	dc.l	.dad			; first letter button
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+.dstep		; second letter button
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(2*.dstep)		; third letter button
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.dad	set	.dad + config_letters
.pw	set	$16			; phrase width (=52 pixels)
.dstep	set	.pw * $80		; 16 lines of phrases = $80 bytes, so this gives byte offset 

.yht	set	.yht+(3*(.hite+.gap))
	dc.l	.dad			; pointing at first option [spinning]
	dc.w	.hite			; this will need some recoding - different option order
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst

.yht	set	.yht+.hite+.gap
	dc.l	.dad+(2*.dstep)		; because this option starts with the third option from above [off]
	dc.w	.hite
	dc.w	ScnSt+(2*.yht)
	dc.b	0,0,6,0
	dc.w	.pw,.pw
	dc.b	1,4
	dc.w	.xst


ObjDef6::		; object list definition for end_game events - static background, 3d layer, stats layer

	dc.w	4		; using a fade thingy as well

ono set 0
	dc.l	Exdisp		; Address
	dc.w	224		; Height	; always 224, cos thats all there is !
	dc.w	ScnSt		; Y start
	dc.b	0,0,0,0		; Type
	dc.w	80		; IWIDTH = 128 pixels wide
	dc.w	80		; DWIDTH
	dc.b	1		; pitch
	dc.b	4		; depth
	dc.w	0		; X start

ono set ono+1
	dc.l	obj_store+$a000	; starts off with data address - note we are displaying it slightly high
	dc.w	ScnHt-32	; Height = 240 (full screen)
	dc.w	ScnSt		; Y start line = 0
	dc.b	0,0,4,0		; type = 0, transparent
	dc.w	80		; 80 phrases = 320 pixels at this size
	dc.w	160		; 2 times as much because of pitch = 2
	dc.b	2		; pitch = 2 = double buffered
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	0		; X start = 0

ono set ono+1
	dc.l	Fanim		; single bit screen cover for fades
	dc.w	280
	dc.w	ScnSt
	dc.b	$40,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge

ono set ono+1
	dc.l	Zeroph		; single bit screen cover for fades
	dc.w	280
	dc.w	ScnSt
	dc.b	0,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge


ObjDef7::		; used for credits screens - initially just first screenfull, then rolling through credits
	dc.w	3	; three items - logo screen, double layer fade screens

	dc.l	obj_store	; way up out of the way where I have plenty of room to play
	dc.w	280		; Height - may as well take advantage of the size of PAL screens for something
	dc.w	ScnSt		; Y start
	dc.b	0		; Type
	dc.b	0		; Pix Offset
	dc.b	0		; flags - Release, Trans, RMW, Reflect bits in order
	dc.b	0		; CLUT index
	dc.w	80		; IWIDTH = 128 pixels wide
	dc.w	80		; DWIDTH
	dc.b	1		; pitch
	dc.b	4		; depth
	dc.w	0		; X start

	dc.l	Fanim		; single bit screen cover for fades
	dc.w	280
	dc.w	ScnSt
	dc.b	$40,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge

	dc.l	Zeroph		; single bit screen cover for fades
	dc.w	280
	dc.w	ScnSt
	dc.b	0,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge


ObjDef8::
	dc.w	1		; MAIN DISPLAY SCREEN - DEMO MODE
	dc.l	obj_store	; starts off with data address
	dc.w	ScnHt		; Height = 240 (full screen)	
	dc.w	ScnSt+16	; Y start line = 0
	dc.b	0		; type = 0
				; phrase 1 completed
	dc.b	0		; no pixel start offset
	dc.b	4		; Reflect, RMW, Release all 0, Trans = 1
	dc.b	0		; CLUT index = 0
	dc.w	80		; 80 phrases = 320 pixels at this size
	dc.w	80		; 2 times as much because of pitch = 2
	dc.b	1		; pitch = 2 = double buffered
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	0		; X start = 0

ObjDef9::			; text only screen - hall of fame / stats etc
	dc.w	3
ono set 0
resono == ono<<4
	dc.l	cockpit		; will be text overlay - probably will be scrolled ?
	dc.w	ScnHt		; Height = 240 (full screen) - also adjusted to prevent odd effects
	dc.w	ScnSt+(ScnHt*2)	; Y start line = 0
	dc.b	0,0,4,0		; type = 0
	dc.w	80		; 80 phrases = 320 pixels at this size
	dc.w	80		; 2 times as much because of pitch = 2
	dc.b	1		; pitch = 2 = double buffered
	dc.b	4		; depth = 4 = 16 bits / pixel
	dc.w	4		; X start = 4 because graphics not quite centred

ono set ono+1
	dc.l	Fanim		; single bit screen cover for fades
	dc.w	280
	dc.w	ScnSt
	dc.b	$40,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge

ono set ono+1
	dc.l	Zeroph		; single bit screen cover for fades
	dc.w	280
	dc.w	ScnSt
	dc.b	0,0,$a,0
	dc.w	5,0		; full screen width, repeating
	dc.b	0,0		; 1 bpp, repeating
	dc.w	0		; starts at edge


;==================================================================
; 			ANIMATION CODING
;==================================================================
; data format - word length counter, word length limit, then n*long addresses followed by zero
; counter and limit are initialised as a long like all the rest, but are used as words later

Ranim::	dc.w	3			; type 3
	dc.l	RainM-(448*40)-$10000	; end address	-ve because backwards (and where start would normally be)
	dc.l	RainM-$10000		; start address
	dc.l	40*15			; 17 lines worth to give an uneven feel
	dc.l	RainM-(448*40)-$10000
	dc.l	0			; end marker

;=============================

Fanim::	dc.w	5			; type 5
	dc.b	0			; intensity change
	dc.b	0			; intensity target
	dc.w	Zeroph			; address to display 
	dc.l	0
