; two random number generators
; one for word random numbers, the other for long
; both return the value in d0, at the appropriate size, and 
; return all other registers to their previous values

.text
Rand1::	move.l	d1,-(a7)
	move.w	seed+2.w,d0
	move.w	#193,d1
	add.w	#47,d0
	mulu	d0,d1
	move.w	d1,d0
	move.w	d1,seed+2.w
	move.l	(a7)+,d1
	rts


Rand2::	move.l	d1,-(a7)
	move.w	seed.w,d0
	move.w	seed+2.w,d1
	rol.w	#3,d0
	eor.w	d1,d0
	swap	d0
	move.w	d1,d0
	move.l	d0,seed.w
	move.l	(a7)+,d1
	rts


; Random number generator for a 'zone' of numbers 0-d1, so a dice would be Randx(d1=6)+1
; returns the result in d0, long, although the value will always be word

Randx::	bsr.b	Rand1	; get a 16 bit random value
	mulu	d1,d0
	sub.w	d0,d0	; strip low bits
	swap	d0
	rts
