; This is music and sound effect source file

	.include	'memdefs.inc'
.if	use_sound = 1

	.include	'jaguar.inc'
	.include	'fulsyn.def'
	.include	'redsound.inc'

;=====================================================
;		MACROS
;=====================================================

.macro	RunGPU	 program

	movea.w	#gpusem,a0
.ntc\~:	tst.l	(a0)
	bne.b	.ntc\~
	addq.l	#1,(a0)			; note addq.l to a known zero is same effect as move.l #1, but 2 bytes (not 6) and 20 ticks (not 28)
					; although moveq #1 + move.l would be quicker, use 4 bytes but need a register !!
	bclr	#0,G_CTRL+3		; halt GPU - note +3 to force last byte
	move.l	#G_RAM,G_PC		; set pc to start
	move.l	#\program*GPUM,gpustop
	move.l	#$11,G_CTRL		; start GPU

.endm

.macro	waitgpu
	movea.w	#gpusem,a0
.wait\~:tst.l	(a0)
	bne.b	.wait\~
.endm

;=====================================================
	.extern		FULSYN_S
	.extern		FULSYN_E

	.extern		SYNTHEND

	.extern		VOLUME

	.extern		DSPORG

	.extern		scoretab

	.extern		PATCHLOC
	.extern		SCORE_AD
	.extern		TIMER_AD
	.extern		samplelength
	.extern		Blit_move
	.extern		WaitBlit	
	HIBIT		equ		$80000000
	NUMTUNES	equ	11	
InitSynth::
	move.l	#$00070007,D_END	; Set GOOD mode

;	move.w	#0,$F10002	; turn off interrupts to stop the music playing - this is just in case of continued operation from boot rom
;	move.w	#0,$F10000	; this didn't fix the start up failure so removed

	move.l	#0,D_CTRL		; Turn DSP off

	move.l	#0,D_FLAGS		; Set known state

; First we copy the Jerry code into Jerry
; The label GPUSTART will be created by LTXCONV/ALN
; at the start of the block.

; The code gets loaded into the DSP at DSPORG

	move.l	#DSPORG,a1
	move.l	#FULSYN_S,a0
	move.l	a0,d0
	move.l	#FULSYN_E,d1
	sub.l	d0,d1
	asr.l	#2,d1
translop:
	move.l	(a0)+,(a1)+
	dbra	d1,translop

; Now we copy the Jerry tables into Jerry
; The label tabs will be created by LTXCONV/ALN
; at the start of the block.

; set up a voicetable of 8 voices and an ending code (zero)

	move.l	#TABLESTART,a1
	moveq	#12,d1			; changed to 11 voices for test purposes
tablop:
	move.l	#-4,(a1)
	add.l	#80,a1
	subq	#1,d1
	bne.b	tablop
	
	move.l	#0,(a1)	
	
	
; Set up the I2S interface

	move.l	#19,SCLK
	move.l	#$15,SMODE

; Set the Volume to full blast

	move.l	#$7fff,VOLUME

; Now it should be safe to turn on the DSP

	move.l	#DSPORG,D_PC	; Set up D_PC

	move.l	#$1,D_CTRL	; LET 'R RIP

; copy the score over whilst sorting the channels chronologically.
; Procedure to sort out patch data from one channel at a time to lots of channels
	move.l	#smusic,a3		; place to store data
	move.l	#$1C000000,d0	; This is note off for voice 7
offloop:
	move.l	#0,(a3)+	; this is silent piece of music. Consists of note off all voices at time 0.
	move.l	d0,(a3)+
	sub.l	#$04000000,d0
	bne.b	offloop
	move.l	#$7fffffff,(a3)+

	moveq	#16,d0
	move.l	a3,d1
	add.l	d0,d1
	neg.l	d0
	and.l	d1,d0
	move.l	d0,MStart
	
; Now copy samples from ROM to RAM	
.if 0				; @@ ROB CHANGED
	move.l	#romsfxe,a0
	move.l	#romsfxx,d0
	sub.l	#romsfxe,d0
	lsr.l	#2,d0
	move.l	#sfxsamples,a1

samplop:
	move.l	(a0)+,(a1)+
	dbra	d0,samplop
.else				; @@ ROB NEW
	move.l	#romsfxe,d0	; source address
	move.l	#sfxsamples,d1	; target address
	move.l	#romsfxx,d2	; end address
	sub.l	d0,d2		; length
	jsr	Blit_move	; shift it >>> fast

.endif
	
	
; Tell the synth where the patches are

	move.l	#PATCHTAB,PATCHLOC

; set up the save so that audio_UNmute can be called before audio_mute
	move.l	PATCHTAB,save
	move.l	#0,Mute		; mute=0 means not muted
	move.w	#0,Ident	; zero the effect identify counter	
; At this point the synth is running but the MIDI player is not
	rts

RestartMusic::			; just like start music, except it remembers the last played song
	movem.l	d0-d6/a0-a6,-(sp)
	move.l	last_patch.w,d4
	beq.b	quit		; just in case it gets hit before anything has been played at all
	move.l	d4,a0
	move.l	last_score.w,a5
	move.l	last_scend.w,d4	
	bra.b	ski
quit:	movem.l	(sp)+,d0-d6/a0-a6

; This is entry point to start up music driver
; a0 contains the address of the instrument patch list, a5 contains the address of the score.	
; This where you set up a score or start a loaded one
; Now tell the system where the score is in a5
; uses no registers
StartMusic::
	movem.l	d0-d6/a0-a6,-(sp)
ski:	bsr	StopMusic	; first stop all channels to prevent crossovers

	move.l	a0,last_patch.w
	cmpa.l	last_score.w,a5
	seq	not_new_score.w
	move.l	a5,last_score.w
	move.l	d4,last_scend.w

; Now lets set up a patch table	
	
	clr.l	d5
	moveq	#10,d3		; shift for sample length
	move.l	(a0)+,d0	; number of instruments
 	subq	#1,d0		; for dbra instruction 
	move.l	#PATCHTAB,a1
	move.l	#instrsamples,a3	; start of area to patch instrument samples
	move.l	#PrevSamples,a4		; list of samples that have been copied
patchlop:
	move.l	#PrevSamples,a6
	move.l	(a0)+,(a1)+	; sample type is straight copy
	move.l	(a0)+,(a1)+	; volume and loop flag
	move.l	(a0)+,a2	; start address of ROM sample data
Already:
	cmp.l	a6,a4
	beq	NewSample	; finished the list without finding a repeated sample so New
	cmp.l	(a6)+,a2
	beq	OldSample	; same start address as a previously copied sample
	addq	#4,a6
	bra	Already
OldSample:
	move.l	(a6)+,(a1)+	; old sample RAM start address
	move.l	(a0)+,(a1)+	; pitch
	move.l	(a0)+,(a1)+	; loop end
	move.l	(a0)+,(a1)+	; loop length
	move.l	d5,(a1)+
	move.l	d5,(a1)+
	move.l	(a0)+,(a1)+	; sample length
	bra	linkup		; link up with the New Sample loop
NewSample:
	move.l	a2,(a4)+
	move.l	a3,(a4)+	; save the ROM and RAM start addresses for repeated samples
	move.l	a3,(a1)+	; start address of RAM sample data
	move.l	(a0)+,(a1)+	; pitch value
	move.l	(a0)+,(a1)+	; loop end
	move.l	(a0)+,(a1)+	; loop length
	move.l	d5,(a1)+	; 6 = 0
	move.l	d5,(a1)+	; 7 = 0
	move.l	(a0)+,d1		; sample length in bytes shifted 8 places
	move.l	d1,(a1)+	; straight copy of sample length

.if 0				; @@ ROB CHANGED
	lsr.l	d3,d1		; convert to sample length in longs
instrlop:
	move.l	(a2)+,(a3)+
	dbra	d1,instrlop	; copy sample data into instrument area
.else				; @@ ROB NEW
	lsr.l	#8,d1		; convert to length in bytes
	movem.l	d0-d2,-(sp)	; retain those about to change
	move.l	a2,d0		; source
	move.l	d1,d2		; length
	move.l	a3,d1		; target
	jsr	Blit_move
	movem.l	(sp)+,d0-d2	; recover values
	addq.l	#3,d1
	andi.w	#-4,d1		; remove any stray bits, such that no bytes go astray
	adda.l	d1,a3		; move pointer 
.endif
linkup:
	moveq	#9,d1
zzzlop:
	move.l	d5,(a1)+	; clear remaining locations (10 of them)
	dbra	d1,zzzlop	
	move.l	(a0)+,(a1)+	; pan value
	
	dbra	d0,patchlop
;
; This is original score copy with channel sort.
.if	0

	move.l	MStart,a3
	move.l	#CList,a1        
	moveq	#0,d2		; number of channels is d2
	moveq	#0,d6		; number of phrases written in d6
; first sort out the start of all the channels
ChanSort:
	move.l	(a5)+,d0
	cmp.l	#$7EEEEEEE,d0		; This is code for end of score
	beq	SortStart
	cmp.l	#$7FFFFFFF,d0		; This is code for start of new channel
	bne	ChanSort
	move.l	a5,(a1)+		; Store start address of channel in list
	addq	#1,d2
	bra	ChanSort
SortStart:
	move.l	#$7FFFFFFF,d1			; This is lowest so far

	move.l	#CList,a1
	move.l	d2,d3
	move.l	#0,a2
Next:
	subq	#1,d3
	beq	DoneComp
	move.l	(a1)+,a0
	move.l	(a0)+,d0
	move.l	(a0),d5
	cmp.l	#$7FFFFFFF,d0
	beq	Next
	cmp.l	d0,d1
	bmi	Next
; This value is lower.
	move.l	a1,a2			; Save the address
	move.l	d0,d1			; Save the data
	move.l	d3,d4			; Save the voice number
	bra 	Next

; we should now have a lowest address in a2. if a2 is 0 then all tracks finished so should we.
DoneComp:
	cmp.l	#0,a2
	beq 	Finished

; copy the lowest data into scoretable. increase lowest list pointer.
	subq	#4,a2		; The pointer was the next channel along so ajust
	move.l	(a2),a0
	move.l	(a0)+,d1
	
	move.l	(a0)+,d0	; Load in note data
	move.l	d1,(a3)+	; this copies timing part
	and.l	#$E3FFFFFF,d0	; Rip out original voice data
	move.l	#26,d5
	lsl.l	d5,d4		; shift voice number into position
	or.l	d4,d0
	move.l	d0,(a3)+

	addq	#1,d6		; increment the number of phrases written
	
	move.l	a0,(a2)		; This stores the increment
	bra	SortStart
	
Finished:
	subq	#4,a3		; write the looper at the last note position
	subq	#1,d6		; the number of phrases to jump is number written -1
	neg.l	d6
	lsl.l	#8,d6
	and.l	#$1FFFFF00,d6
	or.l	#$6000007F,d6	; or in the loop code
	move.l	d6,(a3)+
	move.l	#$7FFFFFFF,(a3)+	; This is finished code
	move.l	a3,MEnd
FScore::
	
.else
; @@ use Rob's blitter move function to copy the score into correct place from its binary file
;	move.l	a5,d0		; source address
;	move.l	MStart,d1	; target	
;	move.l	d4,d2		; end of score address
;	sub.l	d0,d2
;	jsr	Blit_move
;	jsr	WaitBlit
;	clr.l	blitsem.w

	tst.b	not_new_score.w			; this means that second time through it won't re-uncompress
	bne.b	.skip				; although it means checking at the start
	move.l	a5,lzinbuf
	move.l	MStart,lzoutbuf
	move.l	#normal_table,lzworkbuf		; won't be trying to do 3d whilst moving music score (I hope)
	RunGPU	17
	waitgpu
.skip:

.endif

	move.l	MStart,SCORE_AD	; set up score address
; Set the beginning of time

	move.l	#0,TIMER_AD

; Enable sound (mute bit off)

	move.w	#$100,JOYSTICK

; Set up Timer1
; This starts the MIDI player

	move.w	#$5f,$F10002
	move.w	#$114,$F10000
	movem.l	(sp)+,d0-d6/a0-a6
	rts

; Stop the music playing by pointing the score to a silent piece of music and clearing the voicetable.
; saves and restores d0 and a0
StopMusic::
	movem.l	a0/d0,-(sp)
	move.l	#smusic,SCORE_AD
	move.l	#0,TIMER_AD

;	move.w	#$100,JOYSTICK

	move.w	#$5f,$f10002
	move.w	#$114,$F10000

	moveq.l	#7,d0
	move.l	#TABLESTART,a0
TabLoop:
	move.l	#-4,(a0)
	adda.w	#80,a0
	dbra	d0,TabLoop
		
;	move.l	#0,(a0)		; removed because now we don't want the next voice to be cancelled (although we don't want anything else to happen to it)
	movem.l	(sp)+,a0/d0	; instead, we rely on the initial setup to correctly put a stop voice in
	rts
	
; Mute the audio by telling the synth that it has no patches to process
AudioMute::
	movem.l	d0,-(sp)
	move.l	TABLESTART,d0	; look at previous value
	beq.b	NoAction	; if already muted then no action
	move.l	d0,save
	move.l	#0,TABLESTART
NoAction:
	move.l	#$FF,Mute	; set mute flag
	move.w	#0,$F10002	; turn off interrupts to stop the music playing
	move.w	#0,$F10000
	movem.l	(sp)+,d0
	rts

; UNMute the audio by restoring saved state
AudioUNMute::
	move.l	#0,Mute		; clear mute flag
	move.l	save,TABLESTART	; restore previous voicetable
	move.w	#$5f,$F10002	; allow interrupts to continue music play
	move.w	#$114,$f10000
	rts

; Play Sound Effect with patch address d0. Volume in d1. Pan in d2. Channel or 0 in d3
; This puts the patch into the voicetable if there is space or if there is one with lower volume.
; A return value in d0 specifying a unique identifier for the sound is given back to caller
; so that kill_fx can single out the effect to be killed.
; first search whole table for free voices, then do a volume compare.
DoEffect::
	tst.w	effects_volume.w
	beq	DoneTable
	move.l	#VIdent,a2	; a2 is the pointer to the identifier
	move.l	#TABLESTART,a1	; start of voicetable in a1
	tst.l	d3
	bne	UseForce
NextVoice:
	move.l	(a1)+,d3	; load in voice type
	beq	DoneFree	; 0 means finished voice table
	cmp.l	#-4,d3		; is it is a spare or spent voice can use it
	beq	CanUse
	cmp.l	#-1,d3
	beq	CanUse
	addq	#4,a2
	adda.w	#76,a1
	bra.b	NextVoice

DoneFree:			; this only happens if no free voices available, and volume checks are required
	move.l	#VIdent,a2	; a2 is the pointer to the identifier
	move.l	#TABLESTART,a1	; start of voicetable in a1
NextVox:
	move.l	(a1)+,d3	; load in voice type
	beq	DoneTable	; 0 means finished voice table
	cmp.l	#4,d3
	beq	SynthFX		; synth effect so volume in a different place
	cmp.l	#8,d3
	beq	SynthFX
	move.l	(a1),d4		; load in volume of existing voice
	cmp.w	d4,d1
	bgt	CanUseV
	addq	#4,a2		; add 2 to identifier list
	adda.w	#76,a1
	bra	NextVox
SynthFX:
	adda.w	#16,a1
	move.l	(a1),d4
	suba.w	#16,a1
	cmp.w	d4,d1
	bgt	CanUseV
	addq	#4,a2
	adda.w	#76,a1
	bra	NextVox
UseForce:
	asl.l	#2,d3		; 4*d3 is offset for identifier
	adda.l	d3,a2
	mulu	#20,d3		; 20*4*d3 is patch offset
	add.l	d3,a1
	addq.l	#4,a1		; no excuses, this is a fudge
CanUseV:
	subq.l	#4,a1		; align to voice data		
	move.l	#-4,(a1)+	; make a skip voice before patching data
CanUse:
	move.l	a1,a3		; copy a1 for later use

	move.l	d0,a0		; a0 contains pointer to start of patch data
	move.l	(a0)+,d3	; load in the voice type	
	cmp.l	#4,d3		; is it a FM_ENV sound ?
	beq.b	FMsound
	cmp.l	#8,d3
	beq.b	FMsound

	move.w	(a0)+,d3	; load in loop flag
	swap	d3
	muls	effects_volume.w,d1
	lsr.l	#6,d1		; volume can be up to 64, so scale down by this to get full volume at full volume
	move.w	d1,d3		; d3 is loop flag from patch data and input volume

	addq.l	#2,a0		; move up a0 to next long boundary
	move.l	d3,(a1)+
	move.l	(a0)+,(a1)+
;	move.l	(a0)+,a4
;	move.l	(a4),(a1)+
		
	
	moveq.l	#15,d3
CopyFX:
	move.l	(a0)+,(a1)+
	dbra	d3,CopyFX
CleanUp:
	move.l	d2,(a1)+	; put in pan value

	move.l	d0,a0		; load in the effect data again
	move.l	(a0),-(a3)	; load in voice type last thing
	
	addq	#1,Ident	; really this should be .l, but .w produces better numbers, so leave it !
	move.l	Ident,d0
	move.l	d0,(a2)	
	rts

DoneTable:
	moveq.l	#-1,d0		; -1 means thrown away
	rts
	
FMsound:
	move.l	(a0)+,(a1)+	; copy carrier waves and pitch
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.w	(a0)+,d3	; load in loop flag
	swap	d3
	muls	effects_volume.w,d1
	lsr.l	#6,d1		; volume can be up to 64, so scale down by this to get full volume at full volume
	move.w	d1,d3		; d3 is loop flag from patch data and input volume

	addq.l	#2,a0		; move up a0 to next long boundary
	move.l	d3,(a1)+
	
	moveq.l	#11,d3
CopyFM:
	move.l	(a0)+,(a1)+
	dbra	d3,CopyFM
	bra	CleanUp


; Kill all sound effects.	
KillAll::
	movem.l	a0/d0,-(sp)
	move.l	#TABLESTART,a0
NextKill:
	move.l	(a0),d0
	beq.b	KillEnd
	move.l	#-4,(a0)
	adda.w	#80,a0
	bra.b	NextKill
KillEnd:
	movem.l	(sp)+,a0/d0
	rts

; Kill the sound effect in d0
KillSfx::
	move.l	#TABLESTART,a1
	move.l	#VIdent,a0
NextKS:
	move.l	(a1),d1
	beq.b	KillDone
	move.l	(a0)+,d1
	cmp.l	d0,d1
	beq.b	FoundIt
	adda.w	#80,a1
	bra.b	NextKS
FoundIt:
	move.l	#-4,(a1)
KillDone:

	rts

; Modulate the sound effect in d0 to pitch value in d1 and volume in d2 if d2>0
ModSfx::
	tst.w	effects_volume.w
	beq.b	ModDone
	move.l	#TABLESTART,a1
	move.l	#VIdent,a0
NextMS:	tst.l	(a1)
	beq.b	ModDone
	move.l	(a0)+,d3
	cmp.l	d0,d3
	beq.b	FoundId
	adda.w	#80,a1
	bra.b	NextMS
FoundId:
	move.l	(a1),d3
	cmp.l	#4,d3
	beq.b	ModSynth
	cmp.l	#8,d3
	beq.b	ModSynth
	move.l	d1,12(a1)
	tst.w	d2
	beq.b	ModDone
	muls	effects_volume.w,d2
	lsr.l	#6,d2		; volume can be up to 64, so scale down by this to get full volume at full volume
	move.l	4(a1),d0
	move.w	d2,d0
	move.l	d0,4(a1)
	rts
;	bra.b	ModDone
ModSynth:
	move.l	d1,16(a1)	; set pitch
	tst.w	d2
	beq.b	ModDone
	muls	effects_volume.w,d2
	lsr.l	#6,d2		; volume can be up to 64, so scale down by this to get full volume at full volume
	move.l	24(a1),d0
	move.w	d2,d0
	move.l	24,20(a1)
ModDone:rts

;******************************************************************************************************
;
;
;			The following code only need be here if extra synth/effect
;			modules are needed. Start reading again at illegal
;
;
;******************************************************************************************************

; Load in the echo effect to the top 256 bytes of DSP RAM
; Note: The effect is only 58 bytes long!!
;	move.l	#$f1cf00,a1
;	move.l	#ECHO_S,a0
;	move.l	a0,d0
;	move.l	#ECHO_E,d1
;	sub.l	d0,d1
;	asr.l	#2,d1
;echolop:
;	move.l	(a0)+,(a1)+
;	dbra	d1,echolop

; Find the first available slot for the effect

; SYNTHEND is a label at the end of the jump table
; that points to all of the synth modules

; Start at SYNTHEND and look for a sensible address
;	move.l	#SYNTHEND,a0
;	add.l	#4,a0		; prepare for predecrement
;flop:
;	move.l	-(a0),d0
;	cmp.l	#D_RAM,d0
;	bmi	flop
; This is the last occupied voice, so put
; the address of the echo module at the next
; one. The current value there is the correct
; synth type to use!

;	add.l	#4,a0
;	move.l	(a0),d0
;	move.l	#$f1cf00,(a0)

; Add in the echo effect
; Since the MIDI file uses only 8 voices we put echo
; in voicetable position 8 and the stop in location 9

; First the new stop

;	move.l	#0,TABLESTART+(9*TABOFF)

; Now load up the parameters, see echo.das for more info 
; on this implementation of echo.

;	move.l	#TABLESTART+(8*TABOFF),a0
;	move.l	#$100000,(4,a0)			; First table entry is address of buffer
;	move.l	#0,(8,a0)			; Second table entry is offset of writeptr
;	move.l	#2,(12,a0)			; Third table entry is offset of readptr
;	move.l	#$7fff,(16,a0)			; Fourth table entry is mask of buffer size ($7fff=>32k)
;	move.l	#$7fff,(20,a0)			; Fifth table entry is input gain ($7fff=>full)
;	move.l	#$2000,(24,a0)			; Sixth table entry is output gain ($7fff=>full)

; The effect needs a clear buffer

;	move.l	#$100000,a1
;	move.w	#$1fff,d1			; $2000 longs is 32768 bytes
;lop:
;	clr.l	(a1)+
;	dbra	d1,lop

; Put the value read from the jump table into
; the voice table

;	move.l	d0,(a0)

	illegal


; ************************ END OF MAIN CODE ***********************



.long

MS_inarctic::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	7		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	voice	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((voicex-voice))<<8)-1	; 4 End of loop
	dc.l	0		; no loop length
	dc.l	(((voicex-voice))<<8)-1	; 8 End of sample
	dc.l	$5fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sanddrum		; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	snare2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$5fff		; 19 Pan value = centered

; Patch 4

	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$fff		; 1 Loop Flag/Volume
	dc.l	blip2	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((blip2x-blip2))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((blip2x-blip2))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hmguit		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hmguitx-hmguit))<<8)-1	; 4 End of loop
	dc.l	(((hmguitx-hmguit))<<8)-1		; 5 No loop length
	dc.l	(((hmguitx-hmguit))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 6
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	harp		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((harpx-harp))<<8)-1	; 4 End of loop
	dc.l	(((harpx-harp))<<8)-1		; 5 No loop length
	dc.l	(((harpx-harp))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered
		
MS_incanyon::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	7		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass		; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hihat7	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 8 End of sample
	dc.l	0		; 19 Pan value = centered
	
; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$1ff		; 1 Loop Flag/Volume
	dc.l	blip2	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((blip2x-blip2))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((blip2x-blip2))<<8)-1	; 8 End of sample
	dc.l	$5fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	voice	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((voicex-voice))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((voicex-voice))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hihat7	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 8 End of sample
	dc.l	$7fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	HIBIT|$13ff		; 1 Loop Flag/Volume
	dc.l	strings1		; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(($1674/2)<<8)-1	; 4 End of loop
	dc.l	(($1674/2)<<8)-1		; 5 No loop length
	dc.l	(((strings1x-strings1))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 6
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$17ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	(((flutex-flute))<<8)-1		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered
		
MS_indesert::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	6		; number of longs to copy basically these are the music patches and samples

; Patch 0
;	dc.l	28		; 0 Synth type = 8 bit sampler
;	dc.l	$7ff		; 1 Loop Flag/Volume
;	dc.l	flute		; 2 Start of sample
;	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
;	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
;	dc.l	0		; 5 No loop length
;	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
;	dc.l	$2fff		; 19 Pan value = centered
; copy of Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$6ff		; 1 Loop Flag/Volume
	dc.l	hmguit		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hmguitx-hmguit))<<8)-1	; 4 End of loop
	dc.l	(((hmguitx-hmguit))<<8)-1		; 5 No loop length
	dc.l	(((hmguitx-hmguit))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$6ff		; 1 Loop Flag/Volume
	dc.l	sandbass	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$6ff		; 1 Loop Flag/Volume
	dc.l	sanddrum		; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$6ff		; 1 Loop Flag/Volume
	dc.l	snare2		; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$1fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$1		; 1 Loop Flag/Volume
	dc.l	hihat7	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 8 End of sample
	dc.l	$5fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$6ff		; 1 Loop Flag/Volume
	dc.l	hmguit		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hmguitx-hmguit))<<8)-1	; 4 End of loop
	dc.l	(((hmguitx-hmguit))<<8)-1		; 5 No loop length
	dc.l	(((hmguitx-hmguit))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered
		
MS_inriver::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	5		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$8ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$8ff		; 1 Loop Flag/Volume
	dc.l	beepflute	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((beepflutex-beepflute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((beepflutex-beepflute))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$9ff		; 1 Loop Flag/Volume
	dc.l	sanddrum		; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 8 End of sample
	dc.l	$1fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$9ff		; 1 Loop Flag/Volume
	dc.l	snare2		; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$5fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$9ff		; 1 Loop Flag/Volume
	dc.l	sandbass	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered
		
MS_ingreen::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	6		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sanddrum		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	snare2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$5fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hihat7	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 8 End of sample
	dc.l	$1fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$5ff		; 1 Loop Flag/Volume
	dc.l	hmguit		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hmguitx-hmguit))<<8)-1	; 4 End of loop
	dc.l	(((hmguitx-hmguit))<<8)-1		; 5 No loop length
	dc.l	(((hmguitx-hmguit))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered
		
MS_indeep::	; uses : flute, sandbass, sanddrum, snare2, hicongo, hmguit

; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	6		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sanddrum		; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	snare2		; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hicongo	; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hicongox-hicongo))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hicongox-hicongo))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$2ff	;$5ff	; 1 Loop Flag/Volume
	dc.l	hmguit		; 2 Start of sample
	dc.l	$800	;$400	; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hmguitx-hmguit))<<8)-1	; 4 End of loop
	dc.l	(((hmguitx-hmguit))<<8)-1		; 5 No loop length
	dc.l	(((hmguitx-hmguit))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered
		
MS_ingorge::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	7		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sanddrum		; 2 Start of sample
	dc.l	$1000		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	snare2	; 2 Start of sample
	dc.l	$800		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hihat7		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 8 End of sample
	dc.l	$5fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hicongo		; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hicongox-hicongo))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hicongox-hicongo))<<8)-1	; 8 End of sample
	dc.l	$1fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	(((flutex-flute))<<8)-1		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 6
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(($41f4/2)<<8)-1	; 4 End of loop
	dc.l	(($41f4/2)<<8)-1		; 5 No loop length
	dc.l	(((flute2x-flute2))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered
		
MS_incoastal::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	6		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	0		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sanddrum		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	snare2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	harp	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((harpx-harp))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((harpx-harp))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	HIBIT|$7ff		; 1 Loop Flag/Volume
	dc.l	flute2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(($41f4/2)<<8)-1	; 4 End of loop
	dc.l	(($41f4/2)<<8)-1		; 5 No loop length
	dc.l	(((flute2x-flute2))<<8)-1	; 8 End of sample
	dc.l	$7fff		; 19 Pan value = centered

.if 0		
MS_inhole::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	5		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	HIBIT|$7ff		; 1 Loop Flag/Volume
	dc.l	flute2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(($41f4/2)<<8)-1	; 4 End of loop
	dc.l	(($41f4/2)<<8)-1		; 5 No loop length
	dc.l	(((flute2x-flute2))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	holedrum	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((holedrumx-holedrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((holedrumx-holedrum))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	holebeep		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((holebeepx-holebeep))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((holebeepx-holebeep))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	HIBIT|$7ff		; 1 Loop Flag/Volume
	dc.l	strings1		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(($1674/2)<<8)-1	; 4 End of loop
	dc.l	(($1674/2)<<8)-1		; 5 No loop length
	dc.l	(((strings1x-strings1))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	snare2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered
.endif

MS_inisland::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	7		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	boink	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((boinkx-boink))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((boinkx-boink))<<8)-1	; 8 End of sample
	dc.l	$6fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	drum		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((drumx-drum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((drumx-drum))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	blip2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((blip2x-blip2))<<8)-1	; 4 End of loop
	dc.l	(((blip2x-blip2))<<8)-1		; 5 No loop length
	dc.l	(((blip2x-blip2))<<8)-1	; 8 End of sample
	dc.l	$1fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	holebeep		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((holebeepx-holebeep))<<8)-1	; 4 End of loop
	dc.l	(((metalx-metal))<<8)-1		; 5 No loop length
	dc.l	(((holebeepx-holebeep))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 6
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	snare2	; 2 Start of sample
	dc.l	$800		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered
	
MS_song0::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	8		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$3ff		; 1 Loop Flag/Volume
	dc.l	snapgit		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snapgitx-snapgit))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snapgitx-snapgit))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$3ff		; 1 Loop Flag/Volume
	dc.l	orchstab	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((orchstabx-orchstab))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((orchstabx-orchstab))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$13ff	;$7ff	; 1 Loop Flag/Volume - increased for new kick drum sample
	dc.l	kick		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((kickx-kick))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((kickx-kick))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$3ff		; 1 Loop Flag/Volume
	dc.l	drum		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((drumx-drum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((drumx-drum))<<8)-1	; 8 End of sample
	dc.l	$5fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$3ff		; 1 Loop Flag/Volume
	dc.l	hat	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hatx-hat))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hatx-hat))<<8)-1	; 8 End of sample
	dc.l	$1fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$3ff		; 1 Loop Flag/Volume
	dc.l	hmguit		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hmguitx-hmguit))<<8)-1	; 4 End of loop
	dc.l	(((hmguitx-hmguit))<<8)-1		; 5 No loop length
	dc.l	(((hmguitx-hmguit))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 6
;	dc.l	28		; 0 Synth type = 8 bit sampler
;	dc.l	$7ff		; 1 Loop Flag/Volume
;	dc.l	metal		; 2 Start of sample
;	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
;	dc.l	(((metalx-metal))<<8)-1	; 4 End of loop
;	dc.l	(((metalx-metal))<<8)-1		; 5 No loop length
;	dc.l	(((metalx-metal))<<8)-1	; 8 End of sample
;	dc.l	$3fff		; 19 Pan value = centered
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$3ff		; 1 Loop Flag/Volume
	dc.l	hmguit		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hmguitx-hmguit))<<8)-1	; 4 End of loop
	dc.l	(((hmguitx-hmguit))<<8)-1		; 5 No loop length
	dc.l	(((hmguitx-hmguit))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered


; Patch 7
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$3ff		; 1 Loop Flag/Volume
	dc.l	ledbass		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((ledbassx-ledbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((ledbassx-ledbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

.if 0
MS_tarctic::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	5		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute3		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flute3x-flute3))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flute3x-flute3))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$17ff		; 1 Loop Flag/Volume
	dc.l	sandbass	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; no loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$17ff		; 1 Loop Flag/Volume
	dc.l	clave		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((clavex-clave))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((clavex-clave))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$17ff		; 1 Loop Flag/Volume
	dc.l	windFX		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((windFXx-windFX))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((windFXx-windFX))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 4

	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$17ff		; 1 Loop Flag/Volume
	dc.l	sanddrum	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered
.endif
		
MS_tcanyon::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	8		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sanddrum		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	snare2	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered
	
; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hihat7	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hihat7x-hihat7)-3)<<8)-1	; 8 End of sample
	dc.l	$7fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	blip	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((blipx-blip))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((blipx-blip))<<8)-1	; 8 End of sample
	dc.l	$1fff		; 19 Pan value = centered
	
; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hihat2	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hihat2x-hihat2))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hihat2x-hihat2))<<8)-1	; 8 End of sample
	dc.l	0		; 19 Pan value = centered

; Patch 6
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	voice		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((voicex-voice))<<8)-1	; 4 End of loop
	dc.l	(((voicex-voice))<<8)-1		; 5 No loop length
	dc.l	(((voicex-voice))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 7
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	blip2	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((blip2x-blip2))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((blip2x-blip2))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

.if 0		
MS_tdesert::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	5		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$17ff		; 1 Loop Flag/Volume
	dc.l	drumseq		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((drumseqx-drumseq))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((drumseqx-drumseq))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	voice		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((voicex-voice))<<8)-1	; 4 End of loop
	dc.l	(((voicex-voice))<<8)-1		; 5 No loop length
	dc.l	(((voicex-voice))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	0		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff|HIBIT		; 1 Loop Flag/Volume
	dc.l	flute2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	($41f4<<8)-1	; 4 End of loop
	dc.l	($41f4<<8)-1		; 5 No loop length
	dc.l	(((flute2x-flute2))<<8)-1	; 8 End of sample
	dc.l	$7fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$6ff		; 1 Loop Flag/Volume
	dc.l	hmguit		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hmguitx-hmguit))<<8)-1	; 4 End of loop
	dc.l	(((hmguitx-hmguit))<<8)-1		; 5 No loop length
	dc.l	(((hmguitx-hmguit))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered
		
MS_tgreen::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	5		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$17ff		; 1 Loop Flag/Volume
	dc.l	drumseq		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((drumseqx-drumseq))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((drumseqx-drumseq))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	harp		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((harpx-harp))<<8)-1	; 4 End of loop
	dc.l	(((harpx-harp))<<8)-1		; 5 No loop length
	dc.l	(((harpx-harp))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$6fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff|HIBIT		; 1 Loop Flag/Volume
	dc.l	flute2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	($41f4<<8)-1	; 4 End of loop
	dc.l	($41f4<<8)-1		; 5 No loop length
	dc.l	(((flute2x-flute2))<<8)-1	; 8 End of sample
	dc.l	$1fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$6ff		; 1 Loop Flag/Volume
	dc.l	hmguit		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hmguitx-hmguit))<<8)-1	; 4 End of loop
	dc.l	(((hmguitx-hmguit))<<8)-1		; 5 No loop length
	dc.l	(((hmguitx-hmguit))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

MS_tdeep::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	4		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	nightbird		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((nightbirdx-nightbird))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((nightbirdx-nightbird))<<8)-1	; 8 End of sample
	dc.l	0		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	harp		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((harpx-harp))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((harpx-harp))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flute2x-flute2))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flute2x-flute2))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	nightbird		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((nightbirdx-nightbird))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((nightbirdx-nightbird))<<8)-1	; 8 End of sample
	dc.l	$7fff		; 19 Pan value = centered
.endif
		
MS_tgorge::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	7		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	harp		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((harpx-harp))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((harpx-harp))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sanddrum		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$1ff		; 1 Loop Flag/Volume
	dc.l	snare2	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	holebeep		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((holebeepx-holebeep))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((holebeepx-holebeep))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flute2x-flute2))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flute2x-flute2))<<8)-1	; 8 End of sample
	dc.l	0		; 19 Pan value = centered

; Patch 6
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff|HIBIT		; 1 Loop Flag/Volume
	dc.l	flute2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	($41f4<<8)-1	; 4 End of loop
	dc.l	($41f4<<8)-1		; 5 No loop length
	dc.l	(((flute2x-flute2))<<8)-1	; 8 End of sample
	dc.l	$7fff		; 19 Pan value = centered

.if 0		
MS_tcoastal::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	8		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute3		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flute3x-flute3))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flute3x-flute3))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; no loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	clave		; 2 Start of sample
	dc.l	$200		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((clavex-clave))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((clavex-clave))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hihat4		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hihat4x-hihat4))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hihat4x-hihat4))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	beepflute	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((beepflutex-beepflute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((beepflutex-beepflute))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	blip2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((blip2x-blip2))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((blip2x-blip2))<<8)-1	; 8 End of sample
	dc.l	$5fff		; 19 Pan value = centered

; Patch 6
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	harp	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((harpx-harp))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((harpx-harp))<<8)-1	; 8 End of sample
	dc.l	$1fff		; 19 Pan value = centered

; Patch 7
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	HIBIT|$7ff		; 1 Loop Flag/Volume
	dc.l	flute4		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(($41f4/2)<<8)-1	; 4 End of loop
	dc.l	(($41f4/2)<<8)-1		; 5 No loop length
	dc.l	(((flute4x-flute4))<<8)-1	; 8 End of sample
	dc.l	$4fff		; 19 Pan value = centered
		
MS_thole::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	5		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	HIBIT|$7ff		; 1 Loop Flag/Volume
	dc.l	flute2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(($41f4/2)<<8)-1	; 4 End of loop
	dc.l	(($41f4/2)<<8)-1		; 5 No loop length
	dc.l	(((flute2x-flute2))<<8)-1	; 8 End of sample
	dc.l	$6fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	holedrum	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((holedrumx-holedrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((holedrumx-holedrum))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	holebeep		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((holebeepx-holebeep))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((holebeepx-holebeep))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	snare2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	HIBIT|$7ff		; 1 Loop Flag/Volume
	dc.l	strings1		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(($1674/2)<<8)-1	; 4 End of loop
	dc.l	(($1674/2)<<8)-1		; 5 No loop length
	dc.l	(((strings1x-strings1))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

MS_tisland::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	7		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	boink	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((boinkx-boink))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((boinkx-boink))<<8)-1	; 8 End of sample
	dc.l	$2fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hicongo		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hicongox-hicongo))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((hicongox-hicongo))<<8)-1	; 8 End of sample
	dc.l	0		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	locongo		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((locongox-locongo))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((locongox-locongo))<<8)-1	; 8 End of sample
	dc.l	$7fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$4ff		; 1 Loop Flag/Volume
	dc.l	clave		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((clavex-clave))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((clavex-clave))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	0		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 6
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$7fff		; 19 Pan value = centered

MS_hiscore::
	dc.l	5
; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$800		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	0		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$800		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$1fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$800		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 4
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$800		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$5fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	flute		; 2 Start of sample
	dc.l	$800		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((flutex-flute))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((flutex-flute))<<8)-1	; 8 End of sample
	dc.l	$7fff		; 19 Pan value = centered
		
MS_maintit2::
; MAKE SURE TO CHANGE THIS SO THAT THE CORRECT NUMBER ARE COPIED!!!!!!!!!
	dc.l	7		; number of longs to copy basically these are the music patches and samples

; Patch 0
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sandbass		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sandbassx-sandbass))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sandbassx-sandbass))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 1
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	voice	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((voicex-voice))<<8)-1	; 4 End of loop
	dc.l	0		; no loop length
	dc.l	(((voicex-voice))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 2
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	sanddrum		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((sanddrumx-sanddrum))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 3
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	snare2		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((snare2x-snare2)-2)<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 4

	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	blip2	; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((blip2x-blip2))<<8)-1	; 4 End of loop
	dc.l	0		; 5 No loop length
	dc.l	(((blip2x-blip2))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 5
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	hmguit		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((hmguitx-hmguit))<<8)-1	; 4 End of loop
	dc.l	(((hmguitx-hmguit))<<8)-1		; 5 No loop length
	dc.l	(((hmguitx-hmguit))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered

; Patch 6
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7ff		; 1 Loop Flag/Volume
	dc.l	harp		; 2 Start of sample
	dc.l	$400		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((harpx-harp))<<8)-1	; 4 End of loop
	dc.l	(((harpx-harp))<<8)-1		; 5 No loop length
	dc.l	(((harpx-harp))<<8)-1	; 8 End of sample
	dc.l	$3fff		; 19 Pan value = centered
.endif
	
; SOUND EFFECTS
FX_tst2::
	dc.l    8		; 0 simple fm
	dc.l    AMSINE		; 1 carrier wave (sample)
	dc.l    SINE12W		; 2 modulating wave
	dc.l    0               ; 3 -
	dc.l    105648          ; 4 pitch
	dc.l    0               ; 5 -
	dc.l    $1fff		; 6 volume
	dc.l    0               ; 7 -
	dc.l    1<<15           ; 8 frequ of modulation 15.16
	dc.l    1<<8            ; 9 depth of modulation 7.8
	dc.l    0,0,0,0,0,0,0,0,0
	dc.l    $3fff


; Engine noise
FX_engine::
	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	HIBIT|$7ff		; 1 Loop Flag/Volume
	dc.l	sfxsamples+engine-romsample		; 2 Start of sample
	dc.l	$40		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((enginex-engine))<<8)-15	; 4 End of loop
	dc.l	(((enginex-engine))<<8)-25		; 5 No loop length
	dc.l	0		; 6
	dc.l	0		; 7
	dc.l	(((enginex-engine))<<8)-15	; 8 End of sample
	dc.l	0		; 9
	dc.l	0		; 10
	dc.l	0		; 11
	dc.l	0		; 12
	dc.l	0		; 13
	dc.l	0		; 14
	dc.l	0		; 15
	dc.l	0		; 16
	dc.l	0		; 17
	dc.l	0		; 18
	dc.l	$3fff		; 19 Pan value = centered

; Wheel skid noise
FX_skid::

	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	HIBIT|$7ff		; 1 Loop Flag/Volume
	dc.l	sfxsamples+brakeski-romsample		; 2 Start of sample
	dc.l	$c0		; 3 Pitch shift ($1000 = No shift)
	dc.l	((7298)<<8)-1	; 4 End of loop
	dc.l	((5707)<<8)-1	; 5 No loop length
	dc.l	0		; 6
	dc.l	0		; 7
	dc.l	((7298)<<8)-1	; 8 End of sample
	dc.l	0		; 9
	dc.l	0		; 10
	dc.l	0		; 11
	dc.l	0		; 12
	dc.l	0		; 13
	dc.l	0		; 14
	dc.l	0		; 15
	dc.l	0		; 16
	dc.l	0		; 17
	dc.l	0		; 18
	dc.l	$3fff		; 19 Pan value = centered

; Crash sound
FX_crash::

	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$2fff		; 1 Loop Flag/Volume
	dc.l	sfxsamples+crash-romsample		; 2 Start of sample
	dc.l	$80		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((crashx-crash))<<8)-1	; 4 End of loop
	dc.l	(((crashx-crash))<<8)-1		; 5 No loop length
	dc.l	0		; 6
	dc.l	0		; 7
	dc.l	(((crashx-crash))<<8)-1	; 8 End of sample
	dc.l	0		; 9
	dc.l	0		; 10
	dc.l	0		; 11
	dc.l	0		; 12
	dc.l	0		; 13
	dc.l	0		; 14
	dc.l	0		; 15
	dc.l	0		; 16
	dc.l	0		; 17
	dc.l	0		; 18
	dc.l	$3fff		; 19 Pan value = centered

; Starting voice sample
FX_startyou::

	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$7fff		; 1 Loop Flag/Volume
	dc.l	sfxsamples+startyou-romsample		; 2 Start of sample
	dc.l	$80		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((startyoux-startyou))<<8)-1	; 4 End of loop
	dc.l	(((startyoux-startyou))<<8)-1		; 5 No loop length
	dc.l	0		; 6
	dc.l	0		; 7
	dc.l	(((startyoux-startyou))<<8)-1	; 8 End of sample
	dc.l	0		; 9
	dc.l	0		; 10
	dc.l	0		; 11
	dc.l	0		; 12
	dc.l	0		; 13
	dc.l	0		; 14
	dc.l	0		; 15
	dc.l	0		; 16
	dc.l	0		; 17
	dc.l	0		; 18
	dc.l	$3fff		; 19 Pan value = centered

; Starting voice sample
FX_redlite::

	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$3fff		; 1 Loop Flag/Volume
	dc.l	sfxsamples+redlite-romsample		; 2 Start of sample
	dc.l	$80		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((redlitex-redlite))<<8)-1	; 4 End of loop
	dc.l	(((redlitex-redlite))<<8)-1		; 5 No loop length
	dc.l	0		; 6
	dc.l	0		; 7
	dc.l	(((redlitex-redlite))<<8)-1	; 8 End of sample
	dc.l	0		; 9
	dc.l	0		; 10
	dc.l	0		; 11
	dc.l	0		; 12
	dc.l	0		; 13
	dc.l	0		; 14
	dc.l	0		; 15
	dc.l	0		; 16
	dc.l	0		; 17
	dc.l	0		; 18
	dc.l	$3fff		; 19 Pan value = centered

; Starting voice sample
FX_greenlite::

	dc.l	28		; 0 Synth type = 8 bit sampler
	dc.l	$3fff		; 1 Loop Flag/Volume
	dc.l	sfxsamples+greenlite-romsample		; 2 Start of sample
	dc.l	$80		; 3 Pitch shift ($1000 = No shift)
	dc.l	(((greenlitex-greenlite))<<8)-1	; 4 End of loop
	dc.l	(((greenlitex-greenlite))<<8)-1		; 5 No loop length
	dc.l	0		; 6
	dc.l	0		; 7
	dc.l	(((greenlitex-greenlite))<<8)-1	; 8 End of sample
	dc.l	0		; 9
	dc.l	0		; 10
	dc.l	0		; 11
	dc.l	0		; 12
	dc.l	0		; 13
	dc.l	0		; 14
	dc.l	0		; 15
	dc.l	0		; 16
	dc.l	0		; 17
	dc.l	0		; 18
	dc.l	$3fff		; 19 Pan value = centered

; Here are envelopes used by synth sounds
romsample:

; here are the sound effects samples
.long
romsfxe:
brakeski:
	incbin	'samples\\brakeski.8b'
brakeskix:
.long
crash:
;	incbin	'samples\\softcras.8b'
	incbin	'samples\\crash3i2.8b'
crashx:
.long
engine:
	incbin	'samples\\othercar.8b'
enginex:
.long
startyou:
	incbin	'samples\\gent.8b'
startyoux:
.long
redlite:
	incbin	'samples\\redlight.8b'
redlitex:
.long
greenlite:
	incbin	'samples\\greenlig.8b'
greenlitex:
.long
romsfxx:

; here are the musical instrument samples
snapgit:
	incbin	'samples\\snapgit.8b'
snapgitx:
.long
orchstab:
	incbin	'samples\\orchstab2.8b'
orchstabx:
.long
kick:
	incbin	'samples\\kick.8b'
kickx:
.long
drum:
	incbin	'samples\\drum.8b'
drumx:
.long
hat:
	incbin	'samples\\hat.8b'
hatx:
.long
hmguit:
	incbin	'samples\\hmguit.8b'
hmguitx:
.long
metal:
	incbin	'samples\\metalcho.8b'
metalx:
.long
ledbass:
	incbin	'samples\\ledbass.8b'
ledbassx:
.long
sandbass:
	incbin	'samples\\sandbass.8b'
sandbassx:
.long
sanddrum:
	incbin	'samples\\sanddrum.8b'
sanddrumx:
.long
flute:
	incbin	'samples\\flute.8b'
flutex:
.long
flute2:
	incbin	'samples\\flute2.8b'
flute2x:
.long
flute3:
	incbin	'samples\\flute3.8b'
flute3x:
.long
flute4:
	incbin	'samples\\flute4.8b'
flute4x:
.long
hihat2:
	incbin	'samples\\hihat2.8b'
hihat2x:
.long
hihat4:
	incbin	'samples\\highhat4.8b'
hihat4x:
.long
hihat7:
	incbin	'samples\\hihat7.8b'
hihat7x:
.long
snare2:
	incbin	'samples\\snare2.8b'
snare2x:
.long
blip:
	incbin	'samples\\blip.8b'
blipx:
.long
blip2:
	incbin	'samples\\blip2a.8b'
blip2x:
.long
clave:
	incbin	'samples\\claves.8b'
clavex:
.long
voice:
	incbin	'samples\\voice.8b'
voicex:
.long
hicongo:
	incbin	'samples\\hicongo.8b'
hicongox:
.long
locongo:
	incbin	'samples\\locongo.8b'
locongox:
.long
holedrum:
	incbin	'samples\\holedrum.8b'
holedrumx:
.long
holebeep:
	incbin	'samples\\holebeep.8b'
holebeepx:
.long
boink:
	incbin	'samples\\boink.8b'
boinkx:
.long
drumseq:
;	incbin	'samples\\drumseq.8b'
drumseqx:
.long
harp:
	incbin	'samples\\harp.8b'
harpx:
.long
strings1:
	incbin	'samples\\strings1.8b'
strings1x:
.long
windFX:
	incbin	'samples\\WindFX.8b'
windFXx:
.long
nightbird:
;	incbin	'samples\\nightbird.8b'
nightbirdx:

beepflute:
	incbin	'samples\\beepflute.8b'
beepflutex:

.long
romsamplx:



samplelength	equ	romsamplx-romsample

.phrase


					
.bss
Mute:		ds.l	1
MStart:		ds.l	1
MEnd:		ds.l	1
save:		ds.l	1		; save for the first number in patch data
Ident:		ds.l	1		; current value of identifier
CList:		ds.l	16		; data to help with channel sort
VIdent:		ds.l	16		; data for effect identifiers
PrevSamples:	ds.l	20

.endif
