; screen shot program, which reads the object list and copies everything into a known empty screen area
; the following rules are used :
; 1. test that object is an unscaled bitmap - otherwise finish
; 2. test that object is NOT RMW - otherwise skip
; 3. test whether object is 16 bit CRY
;	if so then use blitter, with transparency on
;	if not, perform full expansion using 68000
;	note that blitter could be used for 1 bit objects - and since these are the only other sort I use, its worth considering
;
.text

Shoot::	movem.l	d0-d7/a0-a6,-(a7)
	movea.w	#reset_list,a0	; get object list (reset copy) address

destin:	move.l	#sky_store,A1_BASE			; write destination address 
	moveq.l	#0,d0
	move.l	d0,B_PATD
	move.l	d0,B_PATD+4

	bra.b	start

next:	lea	16(a0),a0	; point to next object
;	move.l	2(a0),d0	; 'middle' long of first phrase
;	clr.b	d0		; clear excess low bits
;	lsl.l	#5,d0		; strip off excess bits from top
;	rol.l	#6,d0		; reposition taking account of data scale (phrase)
;	swap	d0		; finalise link address
;	movea.l	d0,a0

start:	move.b	7(a0),d0	; last byte of first phrase
	and.b	#7,d0		; clear excess
	bne	exit		; if non-zero (ie not simple bitmap, exit)

flag1:	move.b	10(a0),d1
	move.l	#(PIXEL16|WID320|XADDPIX),d0
	btst.l	#5,d1		; check for reverse
	beq.b	.nr
	bset.l	#19,d0		; set reverse mode
.nr:	move.l	d0,A1_FLAGS	; set up destination flags


data:	move.l	(a0),d0		; first long of first phrase
	lsr.l	#8,d0
	and.b	#$F8,d0		; zap non-phrase bits
	move.l	d0,A2_BASE	; write data address for reading from

pos:	move.w	6(a0),d0	; 3rd word of first phrase
	asl.w	#2,d0		; clear height bits
	lsr.w	#6,d0		; drop type and half line bit
	swap	d0		; put y position in high half

	move.w	14(a0),d0	; 3th word of second phrase
	and.w	#$0FFF,d0	; lose excess bits

	move.l	d0,A1_PIXEL	; set pointer into screen shot


rmw:	move.w	10(a0),d0	; second word of second phrase
	btst.l	#14,d0		; check for RMW
	bne.b	next		; if RMW ignore this object and move on

size:	move.b	14(a0),d0	; seventh byte of second phrase
	lsr.l	#4,d0		; position
	and.b	#7,d0		; clear
	move.b	d0,d2		; keep copy for flags later

count:	move.l	4(a0),d0	; second long of first phrase
	asl.l	#2,d0
	swap	d0		; move down into low word
	and.w	#$3FF,d0	; limit to height
	swap	d0
	move.b	11(a0),d0	; start getting image width
	asl.w	#8,d0		; push up
	move.b	12(a0),d0	; get other part of width
	and.w	#$3FF0,d0	; remove low bits and hi bits
	lsr.w	d2,d0		; shift down by pixel size ie down 0 for 1bpp and down 4 for 16bpp
	lsl.w	#2,d0		; resize to give phrases * 4 = pixels for 16 bpp or phrases * 64 for 
	move.l	d0,B_COUNT	; pixel counter in Y and X directions
	move.w	d0,d4

pitch:	move.b	13(a0),d0
	asl.w	#8,d0
	move.b	14(a0),d0
	lsr.w	#7,d0
	and.w	#7,d0
	subq.w	#1,d0		; this corrects for pitch representation IF pitch is 1/2 in objdef
	bmi	special		; one off case
	move.w	d0,d5		; left with pitch of 0 or 1 in d5.w

schk:	move.b	d2,d0
	beq	next ;onebit		; if depth is zero, then use special 1 bpp routine
	cmp.b	#4,d0		; only other usable size currently is 16 bpp - depth = 4
	bne	next		; if not then skip altogether

flags:	move.w	12(a0),d0	; get whole DWIDTH
	and.w	#$FFC,d0	; lose all non-valid bits leaving 4*phrases
	lsr.w	d5,d0		; adjust for double buffered cases
.ns:	move.w	d0,d1		; copy for shift-count
	move.w	d0,d6		; copy for calculating line length offset
	swap	d0		; put original away
	clr.w	d0		; and clear for counter
.lp:	addq.w	#1,d0
	lsr.w	d1
	bne.b	.lp
	subq.w	#1,d0		; reduce shift count by 1
	move.w	d0,d1		; keep
	clr.w	d0
	swap	d0		; leaving just the x width
	asl.w	#2,d0		; shove up to allow downward shift to leave fractional part
	lsr.w	d1,d0		; and then shove down to leave fractional part in place
	move.w	d0,d3
	lsl.w	d1,d3		; make a size which is representable in 6bit IEEE
	lsr.w	#2,d3		; adjust for pre-scaling
	sub.w	d3,d6		; so d6 is line length offset
	and.b	#3,d0		; lose implicit top bit
	asl.w	#2,d1		; push up shift count to avoid fraction
	or.w	d1,d0		; and put in place
	asl.w	#6,d0		; push up to take pixel size
	or.b	d2,d0		; put pixel size in place
	asl.l	#3,d0		; move up for pitch
	or.w	d5,d0
	bset.l	#16,d0		; set for xaddpix mode
	move.l	d0,A2_FLAGS

pos2:	moveq.l	#0,d0
	move.b	9(a0),d0	; to get first pixel
	bclr.l	#7,d0
	asr.b	#2,d0		; reposition
	lsr.b	d2,d0		; use pixel size to correct the size of this

	move.l	d0,A2_PIXEL

step:	moveq.l	#0,d0
	sub.w	d4,d0		; set to step back one actual width and
	bset.l	#16,d0		; down one line
	move.b	10(a0),d1
	btst.l	#5,d1		; test for reflect
	beq.b	.nr
	neg.w	d0		; if reflected then output step is reversed
.nr:	move.l	d0,A1_STEP

	clr.w	d0		; clear lower d0
	sub.w	d4,d0		; has to be redone because theres no reflection in this side
	add.w	d6,d0		; apply line length offset
	move.l	d0,A2_STEP


	move.l	#(SRCEN|UPDA1|UPDA2|LFUSRC),d0
	btst.l	#7,d1
	beq.b	.ni
	bset.l	#27,d0
.ni:	move.l	d0,B_CMD

	bra	next

exit:	movem.l	(a7)+,d0-d7/a0-a6
	bsr	inform

MORE::	move.w	#8,counter.w
	rts

special:
	moveq.l	#0,d0
	move.l	d0,A1_STEP
	move.w	10(a0),d0
	lsr.w	#4,d0
	and.w	#$1fC,d0
	movea.l	#$f00400,a1
	adda.w	d0,a1
	move.l	(a1),d0
	move.l	d0,d1
	swap	d1
	move.w	d1,d0
	move.l	d0,B_SRCD
	move.l	d0,B_SRCD+4
	move.l	#(LFUSRC),d0
	move.l	d0,B_CMD
	bra	next

onebit:

inform:	message 'Screen captured - write A0000[28000] to save.'
