; definition file for building tracks from track list
; each element contains :

; words :
; x,z to centre from start						4
; x,z to end from centre						4
; direction change (from start to end)					2
; width - distance that a barrier has to be from centre line		2

; bytes :
; stream code - subsurface, track, markings, skids, shadows, buildings.	1 [starts with stream 1]
; left barrier code - barrier code is an object number			1
; right barrier code - inside edge is right until reversed		1
; left carpet tile code							1
; right carpet tile code						1
; spare * 3								3

; longs :
; extras (pointer to data required for extra objects) 0=none		4
; radius (used for initial collision detect plus visibility testing)	4
; object definition address (in data segment)				4 total 32 bytes

; spare sections may be split up and used in whatever way, but the elements already defined are now fixed and hard
; coded into the game - so no messing !

;==============================
; offset definitions - not currently installed, but may be useful somewhen
DXIN		equ	0
DZIN		equ	2
DXOUT		equ	4
DZOUT		equ	6
ROTE		equ	8
STREAM		equ	12
LBAR		equ	13
RBAR		equ	14
LTILE		equ	15
RTILE		equ	16
EXTRA		equ	20
RADIUS		equ	24
OBJAD		equ	28

.include	'stream.inc'

;==============================

.macro	mark	label
count	set	count+1
\label	==	count
.endm

count	set	0


;==============================
;	STRAIGHTS
;==============================

DefTrack::
mark	Obstrv
	dc.w	0,10000,0,10000
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exstrv,radstrav,StrtV

mark	Obstrw
	dc.w	0,10000,0,10000
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exstrw,radstraw,StrtW

mark	Obstrwt
	dc.w	0,10000,0,10000
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exstrw,radstrawt,StrtT

;mark	Obstrm
;	dc.w	0,10000,0,10000
;	dc.w	0
;	dc.w	11000
;	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
;	dc.l	Exstrm,radstram,StrtM

mark	Obstrn
	dc.w	0,10000,0,10000
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exstrn,radstran,StrtN

mark	Obstrvwo
	dc.w	0,10000,0,10000
	dc.w	0
	dc.w	16000
	dc.b	str_track,Obbar02,Obbar03,Obcarpet04,Obcarpet05,0,0,0
	dc.l	Exstrvwo,radstraq,StrtVWO

mark	Obstrwm
	dc.w	0,10000,0,10000
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar02,Obbar03,Obcarpet04,Obcarpet05,0,0,0
	dc.l	Exstrwm,radstrax,StrtWM

mark	Obstrmn
	dc.w	0,10000,0,10000
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar02,Obbar03,Obcarpet04,Obcarpet05,0,0,0
	dc.l	Exstrmn,radstray,StrtMN

mark	Obstrwn
	dc.w	0,10000,0,10000
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar04,Obbar05,Obcarpet06,Obcarpet07,0,0,0
	dc.l	Exstrwn,radstraz,StrtWN

mark	Obstrwv
	dc.w	0,10000,-5000,10000
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar19,Obbar01,Obcarpet07,Obcarpet01,0,0,0
	dc.l	Exstrwv,radstrawv,StrtWV

mark	Obstrvw
	dc.w	0,10000,5000,10000
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar18,Obcarpet01,Obcarpet06,0,0,0
	dc.l	Exstrvw,radstravw,StrtVW

mark	Ob0z
	dc.w	0,0,0,19962
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx0z,rsp0z,Spc0z

mark	Ob1x
	dc.w	0,0,0,17406
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx1x,rsp1x,Spc1x

mark	Ob1z
	dc.w	0,0,0,16721
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx1z,rsp1z,Spc1z

mark	Ob2x
	dc.w	0,0,0,13672
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx2x,rsp2x,Spc2x

mark	Ob2z
	dc.w	0,0,0,20068
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx2z,rsp2z,Spc2z

mark	Ob3x
	dc.w	0,0,0,19167
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx3x,rsp3x,Spc3x

mark	Ob3z
	dc.w	0,0,0,9093
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx3z,rsp3z,Spc3z

mark	Ob4x
	dc.w	0,0,0,16946
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx4x,rsp4x,Spc4x

mark	Ob4z
	dc.w	0,0,0,15878
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx4z,rsp4z,Spc4z

mark	Ob5x
	dc.w	0,0,0,14827
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx5x,rsp5x,Spc5x

mark	Ob5z
	dc.w	0,0,0,13190
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx5z,rsp5z,Spc5z

mark	Ob6x
	dc.w	0,0,0,19638
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx6x,rsp6x,Spc6x

mark	Ob6z
	dc.w	0,0,0,11096
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx6z,rsp6z,Spc6z

mark	Ob7x
	dc.w	0,0,0,6314
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx7x,rsp7x,Spc7x

mark	Ob7z
	dc.w	0,0,0,11026
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx7z,rsp7z,Spc7z

mark	Ob8x
	dc.w	0,0,0,14829
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx8x,rsp8x,Spc8x

mark	Ob8z
	dc.w	0,0,0,11482
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx8z,rsp8z,Spc8z

mark	Ob9x
	dc.w	0,0,0,8255
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx9x,rsp9x,Spc9x

mark	Ob9z
	dc.w	0,0,0,16807
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exx9z,rsp9z,Spc9z
;28

;==============================
;	CORNERS
;==============================

mark	Obcorw10
	dc.w	0,10000,723,4703	; checked
	dc.w	$10
	dc.w	11000
	dc.b	str_track,0,0,0,0,0,0,0		; temp fixup cut03 for bar06
	dc.l	Excorw10,rcornw10,Corn10W

mark	Obcorw20
	dc.w	0,10000,1921,9509
	dc.w	$20
	dc.w	11000
	dc.b	str_track,Obbar06,Obbar07,Obcarpet11,Obcarpet10,0,0,0		; temp fixup cut03 for bar06
	dc.l	Excorw20,rcornw20,Corn20W

;mark	Obcorw30
;	dc.w	0,7500,2010,0
;	dc.w	$55
;	dc.w	11000
;	dc.b	str_track,Obbar08,Obbar09,0,0,0,0,0
;	dc.l	Excorw30,rcornw30,Corn30W

mark	Obcorw40
	dc.w	0,10000,3806,9134
	dc.w	$40
	dc.w	11000
	dc.b	str_track,Obbar10,Obbar11,Obcarpet09,Obcarpet08,0,0,0
	dc.l	Excorw40,rcornw40,Corn40W

mark	Obcorw40t
	dc.w	0,10000,3806,9134
	dc.w	$40
	dc.w	11000
	dc.b	str_track,Obbar10,Obbar11,Obcarpet09,Obcarpet08,0,0,0
	dc.l	Excorw40,rcornw40t,Corn40T

mark	Obcorw45
	dc.w	0,10000,5858,4142
	dc.w	$80
	dc.w	11000
	dc.b	str_track,Obbar12,Obbar13,Obcarpet02,Obcarpet03,0,0,0
	dc.l	Excorw45,rcornw45,Corn45W

mark	Obcorw90
	dc.w	0,15000,15000,0
	dc.w	$100
	dc.w	11000
	dc.b	str_track,Obbar14,Obbar15,0,0,0,0,0
	dc.l	Excorw90,rcornw90,Corn90W

.if 0
mark	Obcorn30
	dc.w	0,7500,2010,0
	dc.w	$55
	dc.w	11000
	dc.b	str_track,Obbar16,Obbar17,0,0,0,0,0
	dc.l	Excorn30,rcornn30,Corn30N
.endif 

mark	Obcorv10
	dc.w	0,10000,723,4703
	dc.w	$10
	dc.w	16000
	dc.b	str_track,0,0,0,0,0,0,0
	dc.l	Excorv10,rcornv10,Corn10V

mark	Obcorv20
	dc.w	0,10000,1921,9509
	dc.w	$20
	dc.w	16000
	dc.b	str_track,0,0,0,0,0,0,0	
	dc.l	Excorv20,rcornv20,Corn20V
;37
;==============================
;	PIT LANE SECTIONS
;==============================

;mark	Obpit01
;	dc.w	0,10000,0,10000
;	dc.w	0
;	dc.w	11000
;	dc.b	str_track,0,0,Obcarpet01,Obcarpet01,0,0,0
;	dc.l	Expit01,rpit01,Pit01

;mark	Obpit02
;	dc.w	0,10000,0,10000
;	dc.w	0
;	dc.w	11000
;	dc.b	str_track,0,0,Obcarpet01,Obcarpet01,0,0,0
;	dc.l	Expit02,rpit02,Pit02

mark	Obpit03
	dc.w	0,10000,0,10000		; just like a normal track piece
	dc.w	0
	dc.w	11000
	dc.b	str_track,Obbar01,0,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Expit03,radstran,Pit03

mark	Obpit04
	dc.w	0,0,5500,10000		; nothing going in cos only happens when theres a move first, and then special move going out
	dc.w	0
	dc.w	11000
	dc.b	str_marking,0,Obbar20,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Expit04,rpit04,Pit04

mark	Obpit05
	dc.w	0,10000,8500,10000
	dc.w	0
	dc.w	11000
	dc.b	str_marking,0,Obbar21,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Expit05,rpit05,Pit05

mark	Obpit06
	dc.w	0,10000,0,10000
	dc.w	0
	dc.w	11000
	dc.b	str_marking,Obbar23,Obbar22,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Expit06,rpit06,Pit06

mark	Obpit07
	dc.w	0,10000,-8500,10000
	dc.w	0
	dc.w	11000
	dc.b	str_marking,Obbar24,Obbar25,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Expit07,rpit07,Pit07

mark	Obpit08
	dc.w	0,10000,-5500,10000
	dc.w	0
	dc.w	11000
	dc.b	str_marking,0,Obbar26,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Expit08,rpit08,Pit08

mark	Obpit09
	dc.w	0,10000,0,0		; this one has on outgoing zero just in case we keep the reversed pit lane
	dc.w	0
	dc.w	11000
	dc.b	str_marking,0,Obbar27,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Expit09,rpit09,Pit09

mark	Obstrnp			; TEMPORARY !!!
	dc.w	0,10000,0,10000
	dc.w	0
	dc.w	11000
	dc.b	str_marking,Obbar01,Obbar01,Obcarpet01,Obcarpet01,0,0,0
	dc.l	Exstrn,radstran,StrtN


.print 'Total ',/d count,' track objects defined.'
count set 0

;==============================
;	BARRIERS
;==============================

Def3D::

mark	Obbar01
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar01,NBar01

mark	Obbar01t
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar01t,NBar01t

mark	Obbar01y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar01y,NBar01y

mark	Obbar02
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar02,NBar02

mark	Obbar03
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar03,NBar03

mark	Obbar04
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar04,NBar04

mark	Obbar05
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar05,NBar05

mark	Obbar06
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar06,NBar06

mark	Obbar06y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar06y,NBar06y

mark	Obbar07
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar07,NBar07

mark	Obbar07y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar07y,NBar07y

mark	Obbar08
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar08,NBar08

mark	Obbar09
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar09,NBar09

mark	Obbar10
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar10,NBar10

mark	Obbar10y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar10y,NBar10y

mark	Obbar11
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar11,NBar11

mark	Obbar11y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar11y,NBar11y

mark	Obbar12
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar12,NBar12

mark	Obbar13
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar13,NBar13

mark	Obbar14
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar14,NBar14

mark	Obbar15
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar15,NBar15

mark	Obbar16
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar16,NBar16

mark	Obbar17
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar17,NBar17

mark	Obbar18
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar18,NBar18

mark	Obbar19
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar19,NBar19

mark	Obbar20
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar20,NBar20

mark	Obbar21
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar21,NBar21

mark	Obbar22
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar22,NBar22

mark	Obbar23
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar23,NBar23

mark	Obbar24
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar24,NBar24

mark	Obbar25
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar25,NBar25

mark	Obbar26
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar26,NBar26

mark	Obbar27
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbar27,NBar27

;72
;==============================
;	WHITE BARRIERS
;==============================

mark	Obwbar
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rwbar,WBar

mark	Obwbar01
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rwbar01,WBar01

mark	Obwbar02
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rwbar02,WBar02

mark	Obwbar03
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rwbar03,WBar03
;76
;==============================
;	PITSIDE BARRIERS
;==============================

mark	Obpbar01
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rpbar01,PBar01

mark	Obpbar02
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rpbar02,PBar02

mark	Obpbar03
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rpbar03,PBar03
;79
;==============================
;	BRIDGE BARRIERS
;==============================

mark	Obbrg01
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbrg01,Brg01

mark	Obbrg02
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbrg02,Brg02

mark	Obbrg03
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbrg03,Brg03

mark	Obbrg04
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbrg04,Brg04

mark	Obroadblock
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rroadblock,Roadblock

;84
;==============================
;	BRIDGE SUPPORTS
;==============================
.if 1
mark	Obaftop
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,raftop,Aftop
.else
mark	Obaftopl
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,raftopleft,Aftopl

mark	Obaftopr
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,raftopright,Aftopr
.endif
mark	Obafbot
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,rafbot,Afbot

mark	Obafshad
	dc.w	0,0,0,0,0,0
	dc.b	str_shadows,0,0,0,0,0,0,0
	dc.l	0,rafshad,Afshad

;==============================
;	CARPET TILES
;==============================

mark	Obcarpet01
	dc.w	0,0,0,0,0,0
	dc.b	str_coast,0,0,0,0,0,0,0
	dc.l	0,rcarpet01,Carpet01
	
mark	Obcarpet02
	dc.w	0,0,0,0,0,0
	dc.b	str_coast,0,0,0,0,0,0,0
	dc.l	0,rcarpet02,Carpet02
	
mark	Obcarpet03
	dc.w	0,0,0,0,0,0
	dc.b	str_coast,0,0,0,0,0,0,0
	dc.l	0,rcarpet03,Carpet03
	
mark	Obcarpet04
	dc.w	0,0,0,0,0,0
	dc.b	str_coast,0,0,0,0,0,0,0
	dc.l	0,rcarpet04,Carpet04
	
mark	Obcarpet05
	dc.w	0,0,0,0,0,0
	dc.b	str_coast,0,0,0,0,0,0,0
	dc.l	0,rcarpet05,Carpet05
	
mark	Obcarpet06
	dc.w	0,0,0,0,0,0
	dc.b	str_coast,0,0,0,0,0,0,0
	dc.l	0,rcarpet06,Carpet06
	
mark	Obcarpet07
	dc.w	0,0,0,0,0,0
	dc.b	str_coast,0,0,0,0,0,0,0
	dc.l	0,rcarpet07,Carpet07
	
mark	Obcarpet08
	dc.w	0,0,0,0,0,0
	dc.b	str_coast,0,0,0,0,0,0,0
	dc.l	0,rcarpet08,Carpet08

mark	Obcarpet09
	dc.w	0,0,0,0,0,0
	dc.b	str_coast,0,0,0,0,0,0,0
	dc.l	0,rcarpet09,Carpet09

mark	Obcarpet10
	dc.w	0,0,0,0,0,0
	dc.b	str_coast,0,0,0,0,0,0,0
	dc.l	0,rcarpet10,Carpet10

mark	Obcarpet11
	dc.w	0,0,0,0,0,0
	dc.b	str_coast,0,0,0,0,0,0,0
	dc.l	0,rcarpet11,Carpet11

;86
;==============================
;	CUTTINGS
;==============================

mark	Obcut01
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut01,Cut01

mark	Obcut01x
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut01x,Cut01x

mark	Obcut01y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut01y,Cut01y

mark	Obcut01z
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut01z,Cut01z

mark	Obcut01l
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut01l,Cut01l

mark	Obcut01r
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut01r,Cut01r

mark	Obcut01a
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut01a,Cut01a

mark	Obcut01b
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut01b,Cut01b

mark	Obcut01sp
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut01sp,Cut01sp

mark	Obcut02
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut02,Cut02

mark	Obcut03
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut03,Cut03

mark	Obcut03x
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut03x,Cut03x

mark	Obcut03y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut03y,Cut03y

mark	Obcut03v
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut03v,Cut03v

mark	Obcut03xv
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut03xv,Cut03xv

mark	Obcut03yv
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut03yv,Cut03yv

mark	Obcut04
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut04,Cut04

mark	Obcut04x
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut04x,Cut04x

mark	Obcut04y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut04y,Cut04y

mark	Obcut04l
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut04l,Cut04l

mark	Obcut05
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut05,Cut05

mark	Obcut05l
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut05l,Cut05l

mark	Obcut06
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut06,Cut06

mark	Obcut07
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rcut07,Cut07
;107
;==============================
;	CLIFFS - obsolete
;==============================
.if 0
mark	Obclif01
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,rclif01,Clif01

mark	Obclif01r
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,rclif01r,Clif01r

mark	Obclif01l
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,rclif01l,Clif01l
.endif
;==============================
;	DISTANT HILLS
;==============================

mark	Obdhill01
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill01,Dhill01

mark	Obdhill01r
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill01r,Dhill01r

mark	Obdhill01l
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill01l,Dhill01l

mark	Obdhill01x
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill01x,Dhill01x

mark	Obdhill01y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill01y,Dhill01y

mark	Obdhill01z
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill01z,Dhill01z

mark	Obdhill01j
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill01j,Dhill01j

mark	Obdhill01k
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill01k,Dhill01k

mark	Obdhill02
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill02,Dhill02

mark	Obdhill03
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill03,Dhill03

mark	Obdhill03x
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill03x,Dhill03x

mark	Obdhill03y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill03y,Dhill03y

mark	Obdhill04
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill04,Dhill04

mark	Obdhill05
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill05,Dhill05

mark	Obdhill06
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdhill06,Dhill06

;120
;==============================
;	VERY DISTANT HILLS
;==============================

mark	Obvhill01
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rvhill01,Vhill01

mark	Obvhill01r
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rvhill01r,Vhill01r

mark	Obvhill01a
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rvhill01a,Vhill01a

mark	Obvhill01b
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rvhill01b,Vhill01b

mark	Obvhill01l
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rvhill01l,Vhill01l

mark	Obvhill01x
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rvhill01x,Vhill01x

mark	Obvhill01y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rvhill01y,Vhill01y

mark	Obvhill01z
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rvhill01z,Vhill01z
;128
;==============================
;	DISTANT MOUNTAINS
;==============================

mark	Obdmt01
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt01,Dmt01

mark	Obdmt01l
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt01l,Dmt01l

mark	Obdmt01r
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt01r,Dmt01r

mark	Obdmt01p
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt01p,Dmt01p

mark	Obdmt01q
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt01q,Dmt01q

mark	Obdmt01x
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt01x,Dmt01x

mark	Obdmt01y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt01y,Dmt01y

mark	Obdmt01z
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt01z,Dmt01z

mark	Obdmt01j
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt01j,Dmt01j

mark	Obdmt01k
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt01k,Dmt01k

mark	Obdmt02
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt02,Dmt02

mark	Obdmt03
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt03,Dmt03

mark	Obdmt03x
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt03x,Dmt03x

mark	Obdmt03y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt03y,Dmt03y

mark	Obdmt04
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt04,Dmt04

mark	Obdmt04x
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt04x,Dmt04x

mark	Obdmt04y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdmt04y,Dmt04y
;141
;==============================
;	CLOSEUP MOUNTAINS
;==============================

mark	Obmt01
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt01,Mt01

mark	Obmt01l
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt01l,Mt01l

mark	Obmt01r
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt01r,Mt01r

mark	Obmt01x
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt01x,Mt01x

mark	Obmt01y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt01y,Mt01y

mark	Obmt01z
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt01z,Mt01z

mark	Obmt01a
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt01a,Mt01a

mark	Obmt01b
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt01b,Mt01b

mark	Obmt01sp
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt01sp,Mt01sp

mark	Obmt01sp2
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt01sp2,Mt01sp2

mark	Obmt02
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt02,Mt02

mark	Obmt03
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt03,Mt03

mark	Obmt02v
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt02v,Mt02v

mark	Obmt03v
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt03v,Mt03v

mark	Obmt04
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt04,Mt04

mark	Obmt04x
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt04x,Mt04x

mark	Obmt04y
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt04y,Mt04y

mark	Obmt05
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt05,Mt05

;mark	Obmt08
;	dc.w	0,0,0,0,0,0
;	dc.b	str_real,0,0,0,0,0,0,0
;	dc.l	0,rmt08,Mt08

mark	Obmt08v
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt08v,Mt08v

;mark	Obmt09
;	dc.w	0,0,0,0,0,0
;	dc.b	str_real,0,0,0,0,0,0,0
;	dc.l	0,rmt09,Mt09

mark	Obmt09xv
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt09x,Mt09x

mark	Obmt09yv
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt09y,Mt09y

mark	Obmt09v
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmt09v,Mt09v
;157
;===================================
; 	TUNNEL SECTIONS
;===================================

mark	Obtun1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radtun1,Tun1

mark	Obsurround
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radsurround,Surround

mark	Obtun1b
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radtun1b,Tun1b

mark	Obtun1s
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radtun1s+8000,Tun1s

mark	Obtun1c40
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rtun1c40+8000,Tun1c40

;161
;===================================
; 	LAKE SECTIONS
;===================================

mark	Oblake0
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Lake0

mark	Oblake1
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Lake1

mark	Oblake2
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Lake2

mark	Oblake3
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Lake3

mark	Oblake4
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Lake4

mark	Oblake5
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Lake5

mark	Oblake6
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Lake6
;168
;===================================
; 	SEA SECTIONS
;===================================

;mark	Obsea0
;	dc.w	0,0,0,0,0,0
;	dc.b	str_sea,0,0,0,0,0,0,0
;	dc.l	0,14142,Sea0

mark	Obsea1
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Sea1

;mark	Obsea2
;	dc.w	0,0,0,0,0,0
;	dc.b	str_sea,0,0,0,0,0,0,0
;	dc.l	0,14142*3/2,Sea2

mark	Obsea3
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Sea3

mark	Obsea6
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Sea6

mark	Obshore0
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Shore00

mark	Obshore1
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,14142*3/2,Shore01


;173
;==============================
;	GENERAL BITS
;==============================

mark	Obship1
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,radship1,Ship1

mark	Obyacht1
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0
	dc.l	0,radyacht1,Yacht1

mark	Obdistree
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdistree,Distree

mark	Obdisbuild
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rdisbuild,Disbuild

;177
;==========================================

mark	Obtree			; MAKE SURE THE NEXT ITEM IS treenear as tgen assumes it is
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radxtree+9000,Tree

mark	Obtreenear
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radxtree,Tree

mark	Obskid
	dc.w	0,0,0,0,0,0
	dc.b	str_skids,0,0,0,0,0,0,0
	dc.l	0,radskid,Skid

mark	Obskid2
	dc.w	0,0,0,0,0,0
	dc.b	str_skids,0,0,0,0,0,0,0
	dc.l	0,radskid2,Skid2

mark	Obskid3
	dc.w	0,0,0,0,0,0
	dc.b	str_skids,0,0,0,0,0,0,0
	dc.l	0,radskid3,Skid3

mark	Obpalm
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radpalm1+9000,Palm1

mark	Obpalmnear
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radpalm1,Palm1

coll	set	$80000000 	; 0 for collidable
anim	set	$80000000 	; 0 for normal objects

mark	Obcar
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,500|coll,anim|car_anim	;Ycar
			; note that radius is faked to 500 because the true radius results in the front wheels crossing the struts

mark	Obcar1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,500|coll,anim|car_anim_1	;Ycar

mark	Obcar2
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,500|coll,anim|car_anim_2	;Ycar

mark	Obcar3
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,500|coll,anim|car_anim_3	;Ycar

mark	Obcar4
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,500|coll,anim|car_anim_4	;Ycar

mark	Obcar5
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,500|coll,anim|car_anim_5	;Ycar

mark	Obf1shadow
	dc.w	0,0,0,0,0,0
	dc.b	str_shadows,0,0,0,0,0,0,0
	dc.l	0,radf1car2,F1shadow

mark	Obwheel
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radwheel|coll,Wheels
;191
;=====================================================================================

mark	Oboverhead_left
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rlsign,Lsign

mark	Obbridge3
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rbridge3,Bridge3

mark	Obsatdish
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rsatdish,Satdish

;mark	Obdome1
;	dc.w	0,0,0,0,0,0
;	dc.b	str_real,0,0,0,0,0,0,0
;	dc.l	0,rdome1,Dome1

mark	Obsignl
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rsignl,Signl

mark	Obsignr
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rsignr,Signr

mark	Obhisignl
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radhisignl,Hisignl

mark	Obhisignr
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radhisignr,Hisignr

mark	Obhilite
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radcanylite,Hilite

mark	Obhibar1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radover1,Hibar1

mark	Obhibar2
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radover2,Hibar2

;mark	Obadver
;	dc.w	0,0,0,0,0,0
;	dc.b	str_real,0,0,0,0,0,0,0
;	dc.l	0,radadver,Advert

mark	Obgantry
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
;	dc.l	0,radgantry,Gantry
	dc.l	0,radlights,Gantry

mark	Obibridge1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radibridge1,Ibridge1

mark	Obbuild2
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radbuild2,Build2

mark	Obshadbr1
	dc.w	0,0,0,0,0,0
	dc.b	str_shadows,0,0,0,0,0,0,0
	dc.l	0,radibridge1,Shadbr1

mark	Obshadbr3
	dc.w	0,0,0,0,0,0
	dc.b	str_shadows,0,0,0,0,0,0,0
	dc.l	0,rbridge3,Shadbr3

mark	Obshadbd2
	dc.w	0,0,0,0,0,0
	dc.b	str_shadows,0,0,0,0,0,0,0
	dc.l	0,radbuild2,Shadbd2

mark	Obarrow
	dc.w	0,0,0,0,0,0
	dc.b	str_marking,0,0,0,0,0,0,0
	dc.l	0,rarrow,Arrow

mark	Obrarrow
	dc.w	0,0,0,0,0,0
	dc.b	str_marking,0,0,0,0,0,0,0
	dc.l	0,radright,Rarrow

mark	Oblarrow
	dc.w	0,0,0,0,0,0
	dc.b	str_marking,0,0,0,0,0,0,0
	dc.l	0,radleft,Larrow

mark	Obdot
	dc.w	0,0,0,0,0,0
	dc.b	str_marking,0,0,0,0,0,0,0
	dc.l	0,rdot,Dotted

mark	Obline
	dc.w	0,0,0,0,0,0
	dc.b	str_marking,0,0,0,0,0,0,0
	dc.l	0,rline,Line

mark	Obgrid
	dc.w	0,0,0,0,0,0
	dc.b	str_marking,0,0,0,0,0,0,0
	dc.l	0,rgrid,Grid

mark	Obstart
	dc.w	0,0,0,0,0,0
	dc.b	str_marking,0,0,0,0,0,0,0
	dc.l	0,rstart,Start

mark	Obslow
	dc.w	0,0,0,0,0,0
	dc.b	str_marking,0,0,0,0,0,0,0
	dc.l	0,radslow,Slow
;210
;============================================
; bitmaps

;mark	Oblogo
;	dc.w	0,0,0,0,0,0
;	dc.b	str_real,0,0,0,0,0,0,0
;	dc.l	0,500,Rebel

mark	Obsparkb
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,500,anim|spark_anim

mark	Obgrassb
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,500,anim|grass_anim

mark	Obsmokeb
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,500,anim|smoke_anim

;mark	Obtreebit
;	dc.w	0,0,0,0,0,0
;	dc.b	str_real,0,0,0,0,0,0,0
;	dc.l	0,500,Treebit

;===============================================================
mark	Obc1build1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rc1build1,C1build1

mark	Obc1build2
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rc1build2,C1build2

mark	Obc1build3
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rc1build3,C1build3

mark	Obc1bridge1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rc1bridge1,C1bridge1

mark	Obc1bridge2
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rc1bridge2,C1bridge2

mark	Obc1bridge3
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rc1bridge3,C1bridge3

;===============================================================
; island hop buildings

mark	Obih1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radih1+5000,Ihop1

mark	Obih2
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radih2+5000,Ihop2

mark	Obih3
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radih3+8000,Ihop3

;===============================================================
; other track specific objects

mark	Obigloo
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radigloo,Igloo

mark	Obcactus
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radcactus,Cactus

mark	Obflag1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radflag,Flag1

mark	Obflag2
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radflag,Flag2

mark	Obflag3
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radflag,Flag3

mark	Oblamp1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radlamp1,Lamp1

mark	Oblamp2
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radlamp2,Lamp2

mark	Obpenguin
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radpenguin,Penguin

mark	Obblimp
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radblimp,Blimp

mark	Obpitman
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radpitman01,Pitman

mark	Obbabe
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radbabe1,Babe

mark	Obbaloon
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radbaloon1,Baloon

mark	Obbeachut
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radbechut,Bechut

mark	Obskull
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radskull,Skull

mark	Oblightho1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radlightho1+5000,Lightho1

mark	Oblightho2
	dc.w	0,0,0,0,0,0
	dc.b	str_sea,0,0,0,0,0,0,0		; wanted to make 2, but this would make it a track segment to head for !
	dc.l	0,radlightho2,Lightho2

;mark	Obpterosaur
;	dc.w	0,0,0,0,0,0
;	dc.b	str_real,0,0,0,0,0,0,0
;	dc.l	0,radpterosau,Pterosaur

mark	Obminehead
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radminehead,Minehead

mark	Obpictable
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radpictable,Pictable

mark	Obplane1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radplane1,Plane1

mark	Obsnowm1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radsnowm1,Snowm1

mark	Obtermound
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radtermound,Termound

mark	Obufo
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radufo,Ufo

mark	Obstadium
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radstadium,Stadium

mark	Obpitbuild
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radpitbuild,Pitbuild

mark	Obpyramidl
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radpyramidl,Pyramidl

mark	Obpyramids
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radpyramids,Pyramids

mark	Objagice1
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radjagice1,Jagice1

mark	Objagice2
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radjagice2,Jagice2

mark	Objagice3
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radjagice3,Jagice3

mark	Obicebridge
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,radicebridge,Icebridge

;===============================================================

mark	Obmill
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rmill,Mill

mark	Obwind
	dc.w	0,0,0,0,0,0
	dc.b	str_real,0,0,0,0,0,0,0
	dc.l	0,rwind,Wind



;===============================================================

.print 'Total ',/d count,' 3D objects defined.'

