;...................................
;: (c) 1993 Rebellion Software Ltd :
;: Hand coded by R.C.Dibley - 1993 :
;:.................................:

; list of addresses and lengths of track data in ROM for transfer to RAM

.include	'jaguar.inc'
.include	'memdefs.inc'
.include	'tgencom.inc'
.include	'msg.inc'

;=====================================================
;		MACROS
;=====================================================

.macro	RunGPU	 program

	movea.w	#gpusem,a0
.ntc\~:	tst.l	(a0)
	bne.b	.ntc\~
	addq.l	#1,(a0)			; note addq.l to a known zero is same effect as move.l #1, but 2 bytes (not 6) and 20 ticks (not 28)
					; although moveq #1 + move.l would be quicker, use 4 bytes but need a register !!
	bclr	#0,G_CTRL+3		; halt GPU - note +3 to force last byte
	move.l	#G_RAM,G_PC		; set pc to start
	move.l	#\program*GPUM,gpustop
	move.l	#$11,G_CTRL		; start GPU

.endm

.macro	waitgpu
	movea.w	#gpusem,a0
.wait\~:tst.l	(a0)
	bne.b	.wait\~
.endm

;=====================================================
;		DATA
;=====================================================

Tlist::
	dc.l	10				; total number of available tracks
	dc.l	Track0,0,0,0		;TLen0,Fst_st0,Spin0
	dc.l	Track9,0,0,0
	dc.l	Track1,0,0,0
	dc.l	Track2,0,0,0
	dc.l	Track4,0,0,0
	dc.l	Track5,0,0,0
	dc.l	Track3,0,0,0
	dc.l	Track6,0,0,0
	dc.l	Track8,0,0,0
	dc.l	Track7,0,0,0

Mlist::						; list for 3d definitions of mini-tracks and selection screens
	dc.l	4
	dc.l	Mini0,Mlen0,M_st0,M_st0		; because first rotating object is also first object
	dc.l	Wea0,Wlen0,W_st0,W_st0
	dc.l	Car0,Clen0,C_st0,C_st0
	dc.l	Joy0,Jlen0,J_st0,J_st0

Tcols::						; list of cry colours and other settings for each track in various weather 

	dc.w	$8a80,$88a0,$3016,$58c8		; sun	data order is : ground,target,[ambient/bright],sky colour
	dc.w	$8b60,$5740,$200e,$5780		; rain
	dc.w	$57b0,$57b0,$3808,$57b0		; fog
	dc.w	$8b20,$5700,$0404,$5720		; extra	for future additional weather forms [possibly snowscape, or night]

	dc.w	$8a80,$88a0,$3016,$58c8		; 9-river mouth - grass again ?
	dc.w	$8960,$5740,$200e,$5780
	dc.w	$57b0,$57b0,$3808,$57b0
	dc.w	$8920,$5700,$0404,$5720

	dc.w	$b9b0,$88a0,$3016,$37e0		; 1-desert pass - sandy
	dc.w	$9960,$5740,$200e,$5780
	dc.w	$57b0,$57b0,$3808,$57b0
	dc.w	$9920,$5700,$0404,$5720

	dc.w	$8c70,$88a0,$3016,$48e6		; 2-deep wood - very green
	dc.w	$8c50,$5740,$200e,$5780
	dc.w	$57b0,$57b0,$3808,$57b0
	dc.w	$8c20,$5700,$0404,$5720

	dc.w	$8b80,$88a0,$3016,$8794		; 4-the hole - ?
	dc.w	$8c60,$5740,$200e,$5780
	dc.w	$57b0,$57b0,$3808,$57b0
	dc.w	$8c20,$5700,$0404,$5720

	dc.w	$2780,$88a0,$3016,$48e6		; 5-Island hop ! - sea
	dc.w	$2540,$5740,$200e,$5780
	dc.w	$57b0,$57b0,$3808,$57b0
	dc.w	$2510,$5700,$0404,$5720

	dc.w	$8a80,$88a0,$3016,$37e0		; 3-the gorge - grassland
	dc.w	$8960,$5740,$200e,$5780
	dc.w	$57b0,$57b0,$3808,$57b0
	dc.w	$8920,$5700,$0404,$5720

	dc.w	$7880,$88a0,$3016,$8794		; 6-concrete canyon - grey
	dc.w	$7830,$5740,$200e,$5780
	dc.w	$57b0,$57b0,$3808,$57b0
	dc.w	$7820,$5700,$0404,$5720

	dc.w	$c580,$c630,$3016,$c78e		; 8- sunset strip
	dc.w	$c590,$5740,$200e,$5780
	dc.w	$57b0,$57b0,$3808,$57b0
	dc.w	$c520,$5700,$0404,$5720

	dc.w	$77b0,$88a0,$3016,$86c0		; 7-arctic run - snowy
	dc.w	$7790,$5740,$200e,$5780
	dc.w	$57b0,$57b0,$3808,$57b0
	dc.w	$7730,$5700,$0404,$5720


bitmapsall:
	dc.b	3,4,5,6,-1	; 3 is pause, 4 is central spark anim, 5 is smoke, 6 is grass,

.long		; long rather than even, for sake of possible GPU use
SkyList::	; pointers to sky data and palettes for each track - four double entries each, the data/palettes for each weather

	dc.l	Skylz4,0,hz,hz2,hz,hz3,hz,hz4			; green valley
	dc.l	Skylz4,0,hz,hz2,hz,hz3,hz,hz4			;river mouth
	dc.l	Skylz5,0,hz,hz2,hz,hz3,stars,starpal		;desert pass
	dc.l	Skylz1,0,hz,hz2,hz,hz3,hz,hz4			;deep wood
	dc.l	Skylz2,0,hz,hz2,hz,hz3,stars,starpal		;the hole
	dc.l	Skylz1,0,hz,hz2,hz,hz3,stars,starpal		;island hop
	dc.l	Skylz5,0,hz,hz2,hz,hz3,hz,hz4			;the gorge
	dc.l	Skylz2,0,hz,hz2,hz,hz3,stars,starpal		;concrete canyon
	dc.l	Skylz6,0,hz,hz2,hz,hz3,stars,starpal		;sunset strip
	dc.l	Skylz3,0,hz,hz2,hz,hz3,stars,starpal		;arctic run

; palette reservations - 0 is red glow, 1,2,3,4,5 are starting lights,6-7 reserved for future use

PalList::	; 16 bit cry values for use in the 3d palette, in the following order:
;	ground,tree1,clif1,clif2,sandbank,sandy,mt1,mt2,bldg,stad1,stad2,stad3,warn1,warn2,bridge,dbridge
dc.w	$808a,$a08f,$a88b,$a08b,$909a,$80b8,$c088,$C08a,$A088,lite_blue,build,softred,red,white,orange,dorange	; green valley
dc.w	$808a,$a08f,$a88b,$a08b,$909a,$80b8,$c088,$C08a,$A088,lite_blue,build,softred,red,white,0,0		; river mouth
dc.w	$80b9,$a0b9,$a8b9,$a0b9,$90b9,$80b9,$c0b9,$C0b9,$A088,softred,build,lite_blue,yellow,black,0,0		; desert pass
dc.w	$708c,$a08c,$a88c,$a08c,$909a,$80b8,$c088,$C08a,$A088,rustred,build,rustred,red,white,0,0		; deep wood
dc.w	$808b,$a08f,$a88b,$a08b,$909a,$80b8,$c088,$C08a,$A088,lite_blue,build,softred,red,white,0,0		; the hole
dc.w	$808b,$a08f,$a88b,$a08b,$909a,$80b8,$c088,$C08a,white,gold,build,red,yellow,black,0,0			; island hop
dc.w	$808a,$a08f,$a88b,$a08b,$909a,$80b8,$c088,$C08a,$A088,lite_blue,build,softred,red,white,black0,black3	; the gorge
dc.w	$8078,$a078,$a878,$a078,$9078,$8078,$c078,$C078,$A088,grey50,build,grey40,yellow,black,0,0		; concrete canyon
dc.w	$80c5,$a0bf,$a8c5,$a0c5,$90c5,$80d6,$c0c5,$C0d6,oak,oak,build,oak,red,white,0,0			; sunset strip
dc.w	$b077,$a077,$d877,$d077,$d077,$c077,$f077,$f077,$A088,white,bluegrey,white,blue,white,0,0			; icy colours for arctic run

PalList2::	; second set of 3d palette entries, these are ONLY WEATHER dependent
;	wheelx,wheely,whlx2,whly2,edges,marks,rededge,lights
dc.w	$2077,$1077,$2077,$1077,$e888,$e888,$e8f0,$40cc		; sun
dc.w	$2077,$1077,$2077,$1077,$e888,$c088,$c0f0,$ffcc		; rain
dc.w	$2077,$1077,$2077,$1077,$e888,$e888,$e8f0,$ffbb		; fog
dc.w	$4077,$3077,$8077,$6077,$e088,$8088,$a0f0,$ffcc		; night

Grasslist::
dc.w	$8f59
dc.w	$8f59
dc.w	$b980
dc.w	$8f59
dc.w	$8f59
dc.w	$8f59
dc.w	$8f59
dc.w	$7759
dc.w	$d770
dc.w	$77ff

Flightlist::
	dc.w	500	; green valley - blimp
	dc.w	0	;river mouth
	dc.w	0	;desert pass
	dc.w	1000	;deep wood - plane
	dc.w	0	;the hole
	dc.w	0	;island hop
	dc.w	0	;the gorge
	dc.w	5000	;concrete canyon - ufo
	dc.w	200	;sunset strip - balloon
	dc.w	0	;arctic run

.macro	song	name,pitch
.if use_sound=1
	dc.l	MS_\name,ST_\name,END_\name
	dc.w	\pitch,0
.endif
.endm


Songlist::
	song	indeep,$5b	;	ingreen,$5f
	song	inriver,$55
	song 	indesert,$4f
	song	tcanyon,$4b	;indeep
	song	incoastal,$5f	;inhole
	song	inisland,$5c	;tisland
	song	ingorge,$5a
	song	incanyon,$5f
	song	tgorge,$4f	;tcoastal
	song	inarctic,$5f

Track_slow::			; amount of speed to keep when off track for each track
	dc.w	9	; green valley		grass is not too bad for slowing
	dc.w	9	; river mouth
	dc.w	6	; desert pass		sand slows a LOT
	dc.w	9	; deep wood
	dc.w	9	; the hole
	dc.w	9	; island hop
	dc.w	9	; the gorge
	dc.w	12	; concrete canyon	concrete is not very slowing
	dc.w	6	; sunset strip
	dc.w	8	; arctic run		powder snow is bad for speed



.even
;----------------------------------------------------------
; track download subroutine - d0 contains track number

Mwrite::
	movem.l	d0-d2/a0-a2,-(a7)

	movea.l	#Mlist,a2
	bra.b	km

Twrite::
	movem.l	d0-d2/a0-a2,-(a7)

	movea.l	#Tlist,a2
km:	addq.l	#1,d0
	sf	dronef.w	; make 'not drone'
	cmp.l	(a2)+,d0
	ble.b	.cando
	moveq.l	#1,d0		; overrun forces use of first track
.cando:	subq.l	#1,d0
	asl.l	#4,d0		; because each table entry takes 16 bytes
	adda.l	d0,a2
	movea.l	(a2)+,a1	; address of track data

	cmp.w	#START,(a1)		; check for data type - in case its a trackgen design
	bne.b	.ntg
	move.l	a1,a0
	bsr	Track
	bra.b	.ex

.ntg:	move.l	(a2)+,d2	; end address of track data
	sub.l	a1,d2		; to give length of track data
	movea.l	#Genstr,a0	; output address in RAM for relocater
	move.l	a0,d0		; duplicate
	sub.l	a1,d0		; gives offset from data in ROM to where it will be in RAM
	move.l	d0,d1
	add.l	(a2)+,d0	; use ROM address of part of data to calculate its RAM address
	move.l	d0,carsad.w	; and store for use by draw program
	add.l	(a2),d1		; and another similar.
	move.l	d1,spinad.w	
	move.l	d2,d0		; get back the data length for the relocater
	bsr	Rel

.ex:	movem.l	(a7)+,d0-d2/a0-a2
	rts

;====================================================================

grasshack:
	movea.l	#Grasslist,a0
	moveq	#0,d0
	move.b	track_no.w,d0
	asl.w	#1,d0
	move.w	(a0,d0),d1		; get colour

	movea.l	#Flightlist,a0
	move.w	(a0,d0),flyspeed.w

	movea.l	#Exdisp+$12600,a0
	move.w	#$1c1f,d0

.lp:	tst.w	(a0)+
	dbne	d0,.lp
	beq.b	.ok
	move.w	d1,-2(a0)
	dbra	d0,.lp
.ok:	rts
	

List_expand::
	move.b	(a1)+,d0
	bmi.b	.exit
	ext.w	d0
	bsr	rldin
	bra	List_expand

.exit:	rts


Prepare_bitmaps::
	movea.l	#Exdisp,a0		; general decode area
	movea.l	#bitmapsall,a1		; point to global bitmaps list
	bsr	List_expand

	move.l	a0,lzoutbuf		; a0 already contains the continuation address
	move.l	#Vol_pic,lzinbuf
	move.l	#obj_store,lzworkbuf	; workspace is the currently invisible screen !!
	RunGPU	17			; do that thing !

	bsr	grasshack

	moveq	#0,d0
	moveq	#0,d1
	move.b	track_no.w,d0
	move.b	weather.w,d1
	bsr	Sky_expand
	bsr	palette_install
	rts


palette_install::			; in - d0 = track, d1 = weather
	movem.l	d0-d2/a0-a1,-(sp)
	move.l	d0,d2
	asl.w	#5,d0		; *32
	movea.l	#PalList,a0
	adda.w	d0,a0
	movea.w	#Palette+$10,a1
	moveq	#15,d0

.lp:	move.w	(a0)+,(a1)+
	dbra	d0,.lp

pal2:
	asl.w	#4,d1		; *16
	movea.l	#PalList2,a0
	adda.w	d1,a0
	movea.w	#Palette+$30,a1
	moveq	#7,d0

.lp:	move.w	(a0)+,(a1)+
	dbra	d0,.lp

; trickery - to force ground colour to be correct

	cmp.b	#5,d2			; not island hop - because ground colour is water !
	beq.b	.ex

	move.w	ground.w,d0
	rol.w	#8,d0			; because of wierd colour handling
	move.w	d0,groundfill.w

	movem.l	(sp)+,d0-d2/a0-a1
	rts

.ex:	move.w	ground.w,d0		; intensity in low byte
	move.b	d0,groundfill.w		; results in correct ordering without changing the colour value

	movem.l	(sp)+,d0-d2/a0-a1
	rts

