;...................................
;: (c) 1993 Rebellion Software Ltd :
;: Hand coded by R.C.Dibley - 1993 :
;:.................................:

; =========================================
;    BSS segment for general variables
; =========================================

;.offset	$4000		; which will be at $4000 to allow maximum use of short addressing
.bss

sound1st::		ds.l	2
Zeroph::		ds.l	2	; a zero phrase for 'various' uses - phrase aligned
Music_ph::		ds.l	2	; phrases for use when modifying sound volume settings
FX_ph::			ds.l	2
rev_shadow::		ds.l	4	; two phrases to hold shading for rev counter
seed::			ds.l	1	; random number generator seed left un-cleared to help randomness

.phrase				; items above here are NOT cleared on reset
gpusem::		ds.l	1	; this is used as the start marker for start-up clearance so don't put any above it.
blitsem::		ds.l	1
gpudebug::		ds.l	1	; debugging info from GPU - KXK
screen::		ds.l	1	; 0 or 1 for whichever screen is "on"
screenheight::		ds.l	1	; to hold screen height so that ntsc calcs are only down once
v_scale::		ds.l	1
splim::			ds.l	1
GTarget::		ds.l	1	; target colour for depth cueing
GAmbient::		ds.b	1	; ambience byte - added to light level after everything else
GBright::		ds.b	1	; brightness byte - multiplied by output of normal dot product calculations
ZBase::			ds.w	1	; base z (word) in case ever need to modify

speed::			ds.l	1	; current velocity
brakes::		ds.l	1	; current braking pressure
joy_edge::		ds.l	1	; joypad changes
joy_cur::		ds.l	1	; joypad presses
joy_rep::		ds.l	1	; joypad repeats (first press plus any when held for 8 checks)
Mapptr::		ds.l	1	; pointer to last word modified by map thang
Stream::		ds.l	8	; space for multi-stream counters, each a pair of words, the first being the increment currently needed
				; stream codes start from 1, so the first is spare - not used
WkSpc::			ds.l	10	; space for general temporary use - never assume initialised !
				; increase the size as and when more required

	; non-zero initialised longs
viewmove::		ds.l	1	; flag for whether viewpoint is moving with car - if not it has its own controls for developer
horizon::		ds.l	1	; flag for background being displayed - 0 for off, -1 for on
sky_colour::		ds.l	1
background::		ds.l	1	; colour for upper background
ground::		ds.l	1	; colour for lower background
viewhold::		ds.l	1	; holds view distance when using top view
key_mask::		ds.l	1	; clever trick time ! see joypad.s
mask2::			ds.l	1
dh::			ds.l	1
angle_hold::		ds.l	1	; temporary store

	; non-initialised longs
Xoffst::		ds.l	1	; temporary hold for values for the list processor
Yoffst::		ds.l	1
Zoffst::		ds.l	1
;gpucopy::		ds.l	1	; copy of gpu flags 		for debugging
;blitcopy::		ds.l	1	; copy of blitter flags 	for debugging
pointcopy::		ds.l	1	; copy of pointer 		for debugging
datacopy::		ds.l	1	; copy of value at pointer 	for debugging
rlepoint::		ds.l	1	; pointer to area in ROM holding rle data
spinad::		ds.l	1	; address of first object to be "spun" by spin routine
carsad::		ds.l	1	; address of your car (as an object) for moving through 3d world
shadad::		ds.l	1	; address of cars shadow object
sparkad::		ds.l	1	; address of spark anim which follow cars
smokead::		ds.l	1	; address of smoke anim which follow cars
grassad::		ds.l	1	; address of grass anim which follow cars
flying_ad::		ds.l	1
fly_x::			ds.l	1
fly_z::			ds.l	1
park_ad::		ds.l	1
park_target::		ds.l	6*2	; two longs each, 6 cars, for parking positions
light_address::		ds.l	1	; holds address of current point in start sequence
steer_address::		ds.l	1
objcopy1::		ds.l	1
objcopy2::		ds.l	1
colmin::		ds.l	1	; current shortest collision distance
colhlt::		ds.l	1
skidx::			ds.l	1
skidz::			ds.l	1
viewsine::		ds.l	1	; hold to save on re-calculation
viewcos::		ds.l	1
Pendx::			ds.l	1	; pending move for track generator
Pendz::			ds.l	1	; -"-
xstep::			ds.l	1	; grid steps for track generator
zstep::			ds.l	1
xstart::		ds.l	1
zstart::		ds.l	1
rstart::		ds.l	1
Dronea::		ds.l	1
Dronec::		ds.l	1
drx::			ds.l	1	; permanent reset copy
drz::			ds.l	1
drr::			ds.l	1
dfct::			ds.l	1	; displayed frames counter
bitmap_scale::		ds.l	1
bitmap_width::		ds.l	1
bitmap_width2::		ds.l	1
bitmap_height::		ds.l	1
bitmap_xoff::		ds.l	1
bitmap_yoff::		ds.l	1
source_xoff::		ds.l	1
source_yoff::		ds.l	1

height_step::		ds.l	1

xinit::			ds.l	1	; grid margin
csep::			ds.l	1	; separation now
target_distance::	ds.l	1	; distance to target segment
race_timer::		ds.l	1
time_stopped::		ds.l	1	; so that can record time at end of race 
lap_start::		ds.l	1
time_colour0::		ds.l	1	; block of times for running tournament totals
time_colour1::		ds.l	1
time_colour2::		ds.l	1
time_colour3::		ds.l	1
time_colour4::		ds.l	1
time_colour5::		ds.l	1
result_colour0::	ds.l	1	; block of results for running tournament totals
result_colour1::	ds.l	1	; each long consists of 10 3 bit values giving the points awarded each round
result_colour2::	ds.l	1	; and 
result_colour3::	ds.l	1
result_colour4::	ds.l	1
result_colour5::	ds.l	1

eeprom_data::		ds.l	32	; 128 bytes of space
posit_block::		ds.l	6	; must update if num_cars increases !!!!!!!!!
drone_dis::		ds.l	6*2	; distances and relative speeds of up to 5 drones (in fixed order) plus the car for ease

; SOUND EFFECTS ADDRESS HOLDERS
last_patch::		ds.l	1	; parameters required to allow last song to restart, eg when switching on and off with 0
last_score::		ds.l	1
last_scend::		ds.l	1
engine::		ds.l	1
engine2::		ds.l	1
engine_s2::		ds.l	1
skidfx::		ds.l	1
gentfx::		ds.l	1
crashfx::		ds.l	1
drone_engines::		ds.l	5	; up to 5 drone engine noises to be allowed during game

	; mixed initialised short data
			ds.l	2	; blank for nothing
object_count::		ds.w	1	; holds number of longs to transfer into the object list
new_obj_count::		ds.w	1	; holds same number for new object list
Sound::			ds.w	1
last_pitch::		ds.w	1
counter::		ds.w	1	; frame counter - updated each video sync, and zero'd each drawn frame
framect::		ds.w	1	; word = number of frames between displayed frames
framemax::		ds.w	1	; worst frame count - for checking how bad things can get
start_count::		ds.w	1	; countdown counter for detecting lights changes etc at start
one_second::		ds.w	1	; holds number of frames in a second to save messing with ntsc bit etc
inactivity_monitor::	ds.w	1	; allows up to a fixed time before total inactivity results in reset
rota::			ds.w	1	; rotation speed - based on how long key has been held
strct::			ds.w	1	; steering release counter - wheel starts to return after fixed time
collon::		ds.w	1	; to prevent 'collisions' with track.
trailer::		ds.w	1	; value for distance to trail at - will be 1500 for behind view, and 10000 for aerial view
trail_step::		ds.w	1
track_width::		ds.w	1
hight::			ds.w	1	; height at which to float - only kept to allow switch back to previous view
resetct::		ds.w	1	; reset occurs when this has counted up to 60
units::			ds.w	1	; sets units - 0 for mph, 1 for kmh
disnum::		ds.w	1	; counter for the variable display - number of variable from a list to allow rapid re-calc
;polcnt::		ds.w	1	; count polygons drawn each frame
;polcnt2::		ds.w	1	; count polygons tested 
;shapect::		ds.w	1	; count solids drawn
;shapect2::		ds.w	1	; count solids in list
collision_test::	ds.w	1
;colnct::		ds.w	1	; count collision events
colrot::		ds.w	1	; approximated collision rotation for generating 'bounce' etc
Pendr::			ds.w	1	; pending rotation
WkSpcw::		ds.w	4	; word length workspace
Treerot::		ds.w	1	; rotation for trees - incremented between placing each one
bsp_counter::		ds.w	1	; debugging use only
flyspeed::		ds.w	1	; speed of movement of whatever (if anything) is flying
spark_count::		ds.w	1	; counter for spark animation frames
smoke_count::		ds.w	1	; counter for smoke animation frames
grass_count::		ds.w	1	; counter for grass animation frames
;spark_frac::		ds.w	1	; frame counter for above to maintain constant playback speed
roll_front::		ds.w	1	; animation 'frame'
roll_fraction::		ds.w	1
roll_rear::		ds.w	1
slow_amount::		ds.w	1	; fraction of full speed (full being 16)
axle_distance::		ds.w	1	; used for flexible perspective system
view_last::		ds.w	1	; view number last moved to
perspective::		ds.w	1	; prespective type 0-2
program_area::		ds.w	1
sky_height::		ds.w	1	; value for blitter when clearing sky part of display
ground_height::		ds.w	1	; and ground part
tilthold::		ds.w	1	; holds angle of camera when using top view
twist::			ds.w	1	; twist to viewing angle - integral during tgen process, but fractional (12.4) during game
twist_inc::		ds.w	1	; twist increment for both the above - again, integral for tgen, fractional for game
twist_tgt::		ds.w	1	; target value - either for tgen to allow easier defs, or for game for what the next value should be
twdir::			ds.w	1	; direction of twist, again for both cases, but always 0-$400 (angle)
twdir_inc::		ds.w	1	; increment
twdir_tgt::		ds.w	1	; target
last_car::		ds.w	1	; start-up sequence random car number holder
curr_twist::		ds.w	1	; that part of twist currently being applied to the car - thus allowing calculation of changes to apply
lap_display::		ds.w	1
snail_count::		ds.w	1	; holds current counter in the 'snail markers' list
Horizon_h::		ds.w	1
CLUT_in::		ds.w	1	; address at which to write colour lookup table change requests
CLUT_out::		ds.w	1	; address at which to read clut change requests
sideways::		ds.w	1
sidecount::		ds.w	1
count_out::		ds.w	1
fade_address::		ds.w	1	; address at which to modify intensity increment and target for auto_fade
finish_address::	ds.w	1	; address at which to store car number of next car to cross line
pit_start::		ds.w	1
pit_end::		ds.w	1
hit_type::		ds.w	1	; to allow debugging of car-on-car collisions

	; non-zero short data
speedo::		ds.b	1	; byte = speedo flag
newolist::		ds.b	1	; byte = flag for object list rebuild
xspd::			ds.w	1	; fraction of speed in x direction (word)
zspd::			ds.w	1	; fraction of speed in z direction (word)
xmul::			ds.w	1	; similar but just for collision
zmul::			ds.w	1	; similar but just for collision
delay::			ds.w	1	; minimum number of video frames between display frames
disvar::		ds.w	1	; address of variable to display on screen - any of these - stored as a word
mappix::		ds.w	1	; data overwritten by last map write
skip_qty::		ds.w	1	; skip quantity for track generation
count_down::		ds.w	1	; counting frames during delay before post-collision reaction


ds.w	5

current_segment::	ds.w	1	; track segment number for quick searching when goes off one
last_segment::		ds.w	1	; one car was on last time
second_segment::	ds.w	1	; nearer of the 'other' segments
final_segment::		ds.w	1	; last one in track
twist_segment::		ds.w	1	; extra one, so that 'current segment' can be used for several routines

	; new variables - split later
tk_seg::		ds.w	1	; segment number - used to ensure car covers whole course
revs::			ds.w	1	; engine revs (typically 1000 >> 16000)
num_players::		ds.w	1	; generally holds 1
max_skill::		ds.w	1	; for ai 'skill' levels
min_skill::		ds.w	1
boost_max::		ds.w	1
target_speed::		ds.w	1	; for ai movement calcs
steering_user::		ds.w	1	; for player control of steering
under_user::		ds.w	1	; for more player control
finishers::		ds.w	1	; pointer into list of finished drivers
temp_colour::		ds.w	1
music_volume::		ds.w	1	; value from eeprom, just used whilst modifying in DSP, and for writing to eeprom 0-63 limit
effects_volume::	ds.w	1	; another, used as a multiplier. plus gap to prevent crash (hack hack hack)
old_eff_vol::		ds.w	1	; gap now used !

.even
gear_1::		ds.b	1	; gear (0=N, 1-6) plus top bit set for Automatics
gear::			ds.b	1	; gear (0=N, 1-6) plus top bit set for Automatics
.even
left_obj::		ds.b	1	; code for left hand object during track generation phase
right_obj::		ds.b	1	; code for right hand object during track generation phase
laps_done::		ds.b	1	; number of laps completed
coldet::		ds.b	1	; detection of collision - set and reset for every object
objlok::		ds.b	1	; prevent object list refresh during recompilation
objreb::		ds.b	1	; object rebuild flag
coldir::		ds.b	1	; collision direction value
tview::			ds.b	1	; top view flag
reverse::		ds.b	1
music::			ds.b	1	; flag for music - 0 = off
drift_count::		ds.b	1
reposition_count::	ds.b	1
gpu_int::		ds.b	1	; just to keep track of any GPU interrupts
dead::			ds.b	1
display_mode::		ds.b	1	; switch for multi-object or multi-blit screen layering
fade_over::		ds.b	1	; switch gets cleared when a auto-fade has completed
dronef::		ds.b	1	; flag for drone on/off (different courses)
view_limit::		ds.b	1	; current maximum view number that can be used
view_wants::		ds.b	1	; to hold the users last preferred view when they aren't allowed it
track_flags::		ds.b	1	; holds flags generated by track generator, which determine various characteristics [eg tunnel]
;key_count::		ds.b	32	; hold counts for all 32 bits of the joypad output - only reset when about to start a new game frame
cycdir::		ds.b	1
comp_gen_view::		ds.b	1
short_skid::		ds.b	1
valid_eeprom::		ds.b	1
eeprom_error::		ds.b	1
eeprom_change::		ds.b	1	; flag set when a change to eeprom copy data is made - use for identifying update requirements
debug_on::		ds.b	1
frame_change::		ds.b	1
key_repeat_count::	ds.b	1
active_count::		ds.b	1
allow_clear::		ds.b	1
clear_done::		ds.b	1
gpu_ready::		ds.b	1
not_new_score::		ds.b	1
fake_zero::		ds.b	1
sound_mods::		ds.b	1	; flag to prevent switchin on/off music during sound mod system
in_pause::		ds.b	1

god::			ds.b	1
engine_on::		ds.b	1
out_of_control::	ds.b	1	; flags that control is in computers hands
leading_zero::		ds.b	1	; flag used to prevent leading zero's in displayed numbers
off_track::		ds.b	1	; flags detection of car going off track
direction_flags::	ds.b	1
fast_fall::		ds.b	1
secret::		ds.b	1	; counter for counting entry of secret code values
brake_request::		ds.b	1
human_ahead::		ds.b	1
request_delayed::	ds.b	1	; for flagging the need to reset the whole screen setup
ntsc_type::		ds.b	1	; to hold system type for choosing language [English or American]
vis_mode::		ds.b	1
predmode::		ds.b	1
spectrack::		ds.b	1
race_won::		ds.b	1	; so only the first person across is declared winner !
tight_turn::		ds.b	1	; flag for making drones slow right down and perform careful track following
pre_race::		ds.b	1	; to prevent player driving off before the race has started
game_over::		ds.b	1	; so that player crossing the finish causes a short playout [like stop !]
human_finished::	ds.b	1	; to identify cases where player didn't finish but everyone else did
human_crash::		ds.b	1	; to identify whether a given crash was between two drones, or a human and drone
play_out::		ds.b	1	; to allow continued movement until fade has finished
hit_risk::		ds.b	1
static_view::		ds.b	1
dont_lap::		ds.b	1
race_stage::		ds.b	1	; also track number when running a tournament
grid_position::		ds.b	1	; always 0 for ordinary races and free practice, but changes in tournaments !
last_result::		ds.b	1	; to hold final position in last race, really just for tournament
best_lap::		ds.b	1
winner::		ds.b	1	; holds car number for working out stuff for end game
.even
grid_colour0::		ds.b	1	; these hold the grid positions, both for tournaments, when they
grid_colour1::		ds.b	1	; are dependent on previous results, and for the other settings,
grid_colour2::		ds.b	1	; where there is only one for free practice, and a random set for the
grid_colour3::		ds.b	1	; single race mode.
grid_colour4::		ds.b	1	; 
grid_colour5::		ds.b	1	; 
pos1_car::		ds.b	1	; these hold the car numbers as they cross the line - they are grid positions
pos2_car::		ds.b	1	; and so will be used in conjunction with the grid colours to determine the
pos3_car::		ds.b	1	; following races grid positions when in tournament mode
pos4_car::		ds.b	1
pos5_car::		ds.b	1
pos6_car::		ds.b	1
pos1_colour::		ds.b	1	; these hold the car colours which relate to the above, to properly work out the
pos2_colour::		ds.b	1	; following races grid positions when in tournament mode
pos3_colour::		ds.b	1	
pos4_colour::		ds.b	1
pos5_colour::		ds.b	1
pos6_colour::		ds.b	1
points_colour0::	ds.b	1
points_colour1::	ds.b	1
points_colour2::	ds.b	1
points_colour3::	ds.b	1
points_colour4::	ds.b	1
points_colour5::	ds.b	1

;##############################
;#	OPTION VARIABLES      #
;##############################
weather::		ds.b	1	; clear / fog / rain / snow ?
foil_type::		ds.b	1	; HI = 1 LOW = 0
tyre_type::		ds.b	1	; WET = 1 DRY =0
car_colour::		ds.b	1	; 0-5 different combos
;gear_type::		ds.b	1	; 1 = auto, 2 = manual, actually defined in den_vars
steering_tightness::	ds.b	1	 ; 0-2
race_type::		ds.b	1	; single race / free practice / tournament
qty_laps::		ds.b	1	; number of laps in this race
track_no::		ds.b	1	; track in use now and also used for picking up mini-track display
map_spin::		ds.b	1	; 0=off, 1=static, 2=spinning
tach_set::		ds.b	1	; 0=off, 1=on
key_config::		ds.b	1	; 0-5, ABC/ACB/BAC/BCA/CAB/CBA
key_accel::		ds.b	1	; these three hold the expanded version of the above
key_brake::		ds.b	1
key_cruis::		ds.b	1
num_drones::		ds.b	1	; generally 5, can be reduced
real_num_drones::	ds.b	1	; since number of drones doesn't work in free practice
demo_mode::		ds.b	1

tourn_track::		ds.b	1	; sequential, but retained in case of accidental change of race type
tourn_weather::		ds.b	1	; depends directly on track
tourn_car_col::		ds.b	1	; kept in case gets changed and then tourn switched on again before anything else being used
tourn_qty_laps::	ds.b	1	; depends on track

rotmode::		ds.b	1	; temporary flag for allowing rapid switching of gpu / 68000 rotation

Fame_names::		ds.l	20	; room for 10* 8 character names
Fame_times::		ds.w	20	; and 10* 1 word times
Tour_names::		ds.l	10	; room for 5* 8 character names
Tour_times::		ds.l	10	; and 5* 1 long times (tournament could take up to 1 hour)
Tour_points::		ds.b	5	; and 5* 1 byte points

.include	'den_vars.s'

; a few settings which may come in useful

screen_height	== 240
screen_width	== 320

.bss
cars_copy::		ds.l	48	; room for a complete copy of the 3d data for all 6 cars
general_heap::		ds.l	16	; enough room to temporarily store all the 68000 registers

effects_copy::		ds.l	20*4	; 4 complete voice tables
