;...................................
;: (c) 1993 Rebellion Software Ltd :
;: Hand coded by R.C.Dibley - 1993 :
;:.................................:

;=====================================================
;		MACROS
;=====================================================

.macro	trace value
.iif Trace_on > 0,	move\! \value,(a6)+

.if Trace_on = 2
	cmpa.l	#$78000,a6
	bge	dropout		; kill if overshot
.endif
.endm

.macro	border colour,override
.iif Borders=1, move.l #b_\colour,BORD1
.iif \?override&!Borders, move.l #b_\colour,BORD1
.endm

.macro	RunGPU	 program

	movea.w	#gpusem,a0
.nc\~:	tst.l	(a0)
	bne.b	.nc\~
	addq.l	#1,(a0)			; note addq.l to a known zero is same effect as move.l #1, but 2 bytes (not 6) and 20 ticks (not 28)

	bclr	#0,G_CTRL+3		; halt GPU - note +3 to force last byte
	move.l	#G_RAM,G_PC		; set pc to start
	move.l	#\program*GPUM,gpustop
	move.l	#$11,G_CTRL		; start GPU

.endm

.macro	waitgpu
;	movea.w	#gpusem,a0
.wait\~:stop	#$2000
	tst.l	(a0)
	bne.b	.wait\~
.endm

;========================================
;         INCLUDES OF EQUATES
;========================================

.include 'jaguar.inc'
.include 'memdefs.inc'
.include 'joypad.inc'
.include 'redsound.inc'
.include 'msg.inc'
.include 'blit.inc'
.include	'stream.inc'

;========================================
;	INCLUDES OF PROGRAMS
;========================================

.include 'ai.s'
.include 'endgame.s'		; uses values from ai.s
.include 'fontman.s'		; print routines required by endgame
.include 'drone.s'
;.include 'crash.s'
.include 'joypad.s'
.include 'dennis.s'
.include 'control.s'
.include 'mirror.s'		; uses values defined in ai.s

