; Note that the horizontal timing numbers are for NTSC

;vclk		equ	400	; this for 25 MHz
;vclk		equ	399	; this for 25.05 MHz
vclk		equ	376	; this for 26.6 MHz

; The following are time in units of 100 ps

horiz_per	equ	317778 	; 63.5555us/2 Horizontal period
sync_per	equ	46050	; 4.605us synch width
eq_per		equ	23500	; 2.35us equalization
front_porch	equ	17450	; 1.745us 
line_blank	equ	109500	; 10.95us Total blanking

; The is the display width in video clocks

disp_width	equ	1280	;this is in pixels/divider
disp_height	equ	200	;this is in lines - was 200 ***

; Horizontal computations

n_hp		equ	844	;horiz_per/vclk				;	845
n_hbb		equ	((horiz_per-sync_per-front_porch)/vclk)|$400;	676 (+1K)
n_hbe		equ	(line_blank-sync_per-front_porch)/vclk	;	122
n_hs		equ	((horiz_per-sync_per)/vclk)|$400	;	722
n_hvs		equ	(horiz_per-(2*sync_per))/vclk		;	600
n_heq		equ	(horiz_per-eq_per)/vclk			;	782
n_hde		equ	1647;((disp_width/2)-1)|$400			;	639+1024
n_hdb1		equ	187;((n_hp)-(disp_width/2))			;	365
n_hdb2		equ	n_hdb1					;	365

n_vmode		==	$6C1	; was $4C1  ***

; Vertical

n_vp		equ	523	; was 523 ***
n_vee		equ	6
n_vbe		equ	38	; was 40 ***
n_vdb		==	n_vbe+26-40
n_vde		equ	-1	; was n_vdb+(disp_height*2)
n_vbb		equ	n_vde+40
n_vs		equ	n_vp-6
n_veb		equ	n_vs-n_vee

;=========================================================

.text

VideoIni::

	tst.b	ntsc_type.w
	beq.b	.pal
	move.w	#n_hde,HDE
	move.w	#n_hdb1,HDB1
	move.w	#n_hdb2,HDB2

	move.w	#n_vdb,VDB
	move.w	#n_vde,VDE
	bra.b	.not

.pal:	move.w	#n_hde+$20,HDE
	move.w	#n_hdb1+$20,HDB1
	move.w	#n_hdb2+$20,HDB2

	move.w	#n_vdb+60,VDB
	move.w	#n_vde,VDE

; Also lets set up some default colors

.not:	move.w	#0,BG		; no background colour - saves problems if set to stop object
	move.l	#0,BORD1

;	bra	VidOff
	rts

;============================================================
;settings as they would be under most recent Atari info

;VACTIVE	= 241
;VMIDDLE	= 121

;JVMIDDLE 	= 266
;VTOTAL 	= 200
;VDB 		= 66
;VDE 		= $FFFF

;HACTIVE	= 53
;JHACTIVE	= 1409
;HACTIVE	= 26.5
;HBACKP		= 4.45
;HMIDDLE	= 30.95
;JHMIDDLE	= 823
;HFUDGE		= 4
;VMODE_DIV	= 4
;HPIXELS	= 320
;HDB1		= 823 - (160*4) + 4 	= 187
;HDE		= 187 + 320*4		= 1467	= $400 + 443
;my HDE		= 1280+187-844+$400 = 624 + 1024 = 1647 is best answer, so why ?
;my HDE = VMODE_DIV*HPIXELS + HDBx - HP + $400

; the bits you can't touch :
;	move.w	#n_hp,HP
;	move.w	#n_hbb,HBB
;	move.w	#n_hbe,HBE
;	move.w	#n_hs,HS
;	move.w	#n_hvs,HVS
;	move.w	#n_heq,HEQ
;	move.w	#n_vp,VP
;	move.w	#n_vee,VEE
;	move.w	#n_vbe,VBE
;	move.w	#n_vbb,VBB
;	move.w	#$1d0,VBB	; this used to switch off flashing pixel - not in accordance with normal use
;	move.w	#n_veb,VEB	; because the blanking starts before the display stops.
;	move.w	#n_vs,VS


