;--------------------------------------------------------------------
; Useful defines and macro definitions for the Jaguar.
;--------------------------------------------------------------------
;RAPIER MEMORY MAP:
;
;	DRAM 0	:	0.5Mb starting at 0 repeated  to 4Mb
;	DRAM 1	:	0.5Mb starting at 4Mb repeated to 8Mb
;
;	ROM 0	:	????
;
;
;---------------------------------------------------------------------
;Throughout our 68000 source, certain registers are reserved. These
;are as follows:
;
;	a7		-	stack pointer
;	a6		-	points to base of variables
;	a5		-	pointer to regbase (TOM registers)
;	a4		-	used by system routines


				ifnd atd		;Ensure no problem if included 1+

atd				equ 1


;---------------------------------------------------------------------
;Macros now follow.
;---------------------------------------------------------------------

;Module naming directive to get around different assembler directives

modulename 		macro			;module-name
				ttl \1
\1				equ 1			;for global macro below
				endm


;This macro simpifies the use of XDEFs and XREFs

global			macro			;fileflag,label
				ifd \1
				xdef \2
				endc
				ifnd \1
				xref \2
				endc
				endm


;Compensate for a bug in communicating with GPU / BLITTER memory.

BUGSWAP			macro			;register to swap
				endm


;This macro allows us to write to TOM registers irrespective of vers (bugs).

GMOVEL			macro			;32 bit data,address
				move.l \1,\2
				endm


;The following macros allow us to define structure offsets easily

STRUCT			macro			;parameters not parsed
structoff		set 0
				endm

ELEMENT			macro			;element name,size (+ optional aligment)
				ifnc '\3',''
structoff		set ((structoff+\3)&(~\3))	;align before assigning
				endc
\1				equ structoff
structoff		set structoff+\2
				endm

ENDS			macro			;optional size label (+ optional alignment)
				ifnc '\1',''
				ifc '\2',''
\1				equ structoff				;no alignment
				endc
				ifnc '\2',''
\1				equ ((structoff+\2)&(~\2))	;aligned
				endc
				endc
				endm


; BRP: The following macro is like ELEMENT but takes no label parameter

INHERIT			macro			;(structure name==structure size)
structoff		set structoff+\1
				endm


; BRP: Another ELEMENT-like structure, for defining an array
; use: 		ARRAY	label,element-size,num-elements[,align]
; (no alignment)

ARRAY			macro			; name,el-size,num-el[,align]
				ifnc '\4',''
structoff		set ((structoff+\4)&(~\4))	;align before assigning
				endc
\1				equ		structoff
structoff		set 	structoff+\2*\3
				endm				


;Set the border colour (24 bit true-colour value and not CRY).

BORDER			macro			;border colour (can be reg)
				move.l \1,bord1(a5)
				endm


;The following macros allow us to split code and data up.

BEGCONST		macro			;no params
				section 2
				endm

ENDCONST		macro
				ALIGN ALIGNWORD
				endm


BEGVARS			macro			;no params
				xref varbase
				section 1
				basereg a6,varbase
				align ALIGNLONG
				endm

ENDVARS			macro			;no params
				endm


BEGCODE			macro
				section 0
				endm

ENDCODE			macro
				endm


;The following macro allocates space for an uninitialised variable.

VAR				macro			;name,size (+ optional alignment)
				ifnc '\3',''
				align \3
				endc
\1				ds.b \2
				endm


;The following macros make move multiple easier to type and understand.

PUSH			macro
				move.l \1,-(sp)
				endm

POP				macro
				move.l (sp)+,\1
				endm

PUSHM			macro
				movem.l \1,-(sp)
				endm

POPM			macro
				movem.l (sp)+,\1
				endm


;---------------------------------------------------------------------
;BLITTER BIT equates for CMD
;---------------------------------------------------------------------

SRCEN			equ $01
SRCENZ			equ $02
SRCENX			equ $04
DSTEN			equ $08
DSTENZ			equ $10
DSTWRZ			equ $20
CLIP_A1			equ $40
NOGO			equ $80

UPDA1F			equ $0100
UPDA1			equ $0200
UPDA2			equ $0400
DSTA2			equ $0800
GOURD			equ $1000
GOURZ			equ $2000
TOPBEN			equ $4000
TOPNEN			equ $8000

PATDSEL			equ $010000
ADDDSEL			equ $020000
ZMODELT			equ $040000
ZMODEEQ			equ $080000
ZMODEGT			equ $100000

LFUFUNC_NAN		equ $200000		0
LFUFUNC_NA		equ $400000		1
LFUFUNC_AN		equ $800000		2
LFUFUNC_A		equ $01000000	3

LFU_COPY		equ LFUFUNC_AN+LFUFUNC_A
LFU_XOR			equ LFUFUNC_NA+LFUFUNC_AN
LFU_AND			equ LFUFUNC_A
LFU_OR			equ LFUFUNC_NA+LFUFUNC_AN+LFUFUNC_A
LFU_NONE		equ 0
LFU_ALL			equ LFUFUNC_NAN+LFUFUNC_NA+LFUFUNC_AN+LFUFUNC_A

CMPDST			equ $02000000
BCOMPEN			equ $04000000
DCOMPEN			equ $08000000
BKGWREN			equ $10000000
BUSHI			equ $20000000
SRCSHADE		equ $40000000


;---------------------------------------------------------------------
;BLITTER equate for A1 Flags register.
;---------------------------------------------------------------------

A1PITCH1		equ 0		;Phrase steps
A1PITCH2		equ 1
A1PITCH4		equ 2		;new mod for RAPIER (!)
A1PITCH3		equ 3		;new mod for RAPIER (!)

A1PIXEL1		equ 0*8		;Pixel size (in bits)
A1PIXEL2		equ 1*8
A1PIXEL4		equ 2*8
A1PIXEL8		equ 3*8
A1PIXEL16		equ 4*8
A1PIXEL32		equ 5*8

A1ZOFFS1		equ 1*64
A1ZOFFS2		equ 2*64
A1ZOFFS3		equ 3*64
A1ZOFFS4		equ 4*64
A1ZOFFS5		equ 5*64
A1ZOFFS6		equ 6*64

A1WIDTH2  		equ 4*512
A1WIDTH4  		equ 8*512
A1WIDTH6		equ 10*512
A1WIDTH8		equ 12*512
A1WIDTH10 		equ 13*512
A1WIDTH12		equ 14*512
A1WIDTH14		equ 15*512
A1WIDTH16		equ 16*512
A1WIDTH20		equ 17*512
A1WIDTH24		equ 18*512
A1WIDTH28		equ 19*512
A1WIDTH32		equ 20*512
A1WIDTH40		equ 21*512
A1WIDTH48		equ 22*512
A1WIDTH56		equ 23*512
A1WIDTH64		equ 24*512
A1WIDTH80		equ 25*512
A1WIDTH96		equ 26*512
A1WIDTH112		equ 27*512
A1WIDTH128		equ 28*512
A1WIDTH160		equ 29*512
A1WIDTH192		equ 30*512
A1WIDTH224		equ 31*512
A1WIDTH256		equ 32*512
A1WIDTH320		equ 33*512
A1WIDTH384		equ 34*512
A1WIDTH448		equ 35*512
A1WIDTH512		equ 36*512
A1WIDTH640		equ 37*512
A1WIDTH768		equ 38*512
A1WIDTH896		equ 39*512
A1WIDTH1024		equ 40*512
A1WIDTH1280		equ 41*512
A1WIDTH1536		equ 42*512
A1WIDTH1792		equ 43*512
A1WIDTH2048		equ 44*512
A1WIDTH2560		equ 45*512
A1WIDTH3072		equ 46*512
A1WIDTH3584		equ 47*512

A1XADDPHR		equ 0*$10000
A1XADD1			equ 1*$10000
A1XADD0			equ 2*$10000
A1XADDINC		equ 3*$10000

A1YADD0			equ 0*$40000
A1YADD1			equ 1*$40000

A1XSIGN			equ $080000
A1YSIGN			equ $100000


;---------------------------------------------------------------------
;Alignment definitions for the assembler.
;---------------------------------------------------------------------

ALIGNBYTE		equ 0
ALIGNWORD		equ 1
ALIGNLONG		equ 3
ALIGNPHRASE		equ 7
ALIGNPAGE		equ 255


;---------------------------------------------------------------------
;Not-very-neat high/low equates
;---------------------------------------------------------------------

HIGHBYTE		equ	0
LOWBYTE			equ	1
HIGHWORD		equ	0
LOWWORD			equ	2


;---------------------------------------------------------------------
;Sizes for use with the VAR and ELEMENT macros defined above.
;---------------------------------------------------------------------

NULL			equ 0
BYTE			equ 1
WORD			equ 2
DWORD			equ 4
PHRASE			equ 8
SENTENCE		equ 16
PARAGRAPH		equ 32
CHAPTER			equ 64
NOVEL			equ 128
BESTSELLER		equ 256		;can't be PAGE as it is a reserved word
BIBLE			equ 512
LIBRARY			equ 1024


;---------------------------------------------------------------------
;Flags for subroutines contained in the system.
;---------------------------------------------------------------------

CHKCONTROLLER1	equ $0001
CHKCONTROLLER2	equ $0002
CHKCONTROLLERS	equ $0003	;flags for checking button status'


;---------------------------------------------------------------------
;Common, non-game-specific structure definitions now follow.
;---------------------------------------------------------------------

;First we have a palette / clut object for objects < CRY

				STRUCT palette
				ELEMENT pal_index,WORD
				ELEMENT pal_entries,WORD
				ELEMENT cry,WORD		;x number of entries
				ENDS


;This structure is used for system operations to objects (fill/line).

				STRUCT atdobj
				ELEMENT obbase,DWORD	;base address of object
				ELEMENT obheight,WORD	;height of object in pixels
				ELEMENT obwidth,WORD	;width of object in pixels
				ELEMENT obadjust,WORD	;phrase mode adjustment flag
				ELEMENT obflags,DWORD	;flags for A1 address register
				ENDS atdobjsz


;This structure exists for fonts and grobjects (pixel independant).

				STRUCT preamble
				ELEMENT flagsa1,DWORD	;some blitter A1 flags
				ELEMENT flagsa2,DWORD	;some blitter A2 flags
				ELEMENT command,DWORD	;blitter command
				ELEMENT phraseadj,WORD	;phrase / pixel step adjustment
				ENDS preamblesz


;This structure exists for each character in a font (table before data).

				STRUCT fontchr
				ELEMENT width,WORD		;width of character
				ELEMENT height,WORD		;height of character
				ELEMENT ydstoff,WORD	;Y offset when plotting
				ELEMENT dataoff,WORD	;offset to pixel data
				ENDS FCHRS


;This structure exists for each frame of a GROBJECT (multi-frame sprite).

				STRUCT grobject
				ELEMENT grwidth,WORD	;width of image
				ELEMENT grheight,WORD	;height of image
				ELEMENT gryoff,WORD		;vertical plot offset
				ELEMENT grxoff,WORD		;horizontal plot offset
				ELEMENT grdataoff,WORD	;offset to pixel data
				ENDS grobjsz


;Compressed data structure. This header preceeds compressed data.

				STRUCT comphdr
				ELEMENT comptype,WORD	;compression type
				ELEMENT destsize,DWORD 	;decompressed size
				ENDS comphdrsz


				endc

