;=====================================================================
;Include file for use with various controllers (mouse / digital and
;analog joysticks etc). Complex due to the range of control made
;available to us.
;---------------------------------------------------------------------

				global controls,readdjoy1
				global controls,readdbut1
				global controls,readdkey1
				global controls,readdjoy2
				global controls,readdbut2
				global controls,readdkey2

				global controls,getkeyascii




;=====================================================================
;Digital Joystick definitions first
;=====================================================================

JOYSTICKPORT	equ iobase+gpio0
BUTTONPORT		equ iobase+gpio0+2
KEYPADPORT		equ JOYSTICKPORT

READJOY1		equ $81fe		;command to read digital joystick 1
READJOY2		equ $817f		;command to read digital joystick 2

JOYUP			equ $0001
JOYDOWN			equ $0002
JOYLEFT			equ $0004
JOYRIGHT		equ $0008		;bit codes for digital joystick movements

BITUP			equ 0
BITDOWN			equ 1
BITLEFT			equ 2
BITRIGHT		equ 3			;bit positions for the above


;---------------------------------------------------------------------

READBUT10		equ $81fe
READBUT11		equ $81fd
READBUT12		equ $81fb
READBUT13		equ $81f7		;commands to read joystick 1 buttons

READBUT20		equ $817f
READBUT21		equ $81bf
READBUT22		equ $81df
READBUT23		equ $81ef		;commands to read joystick 2 buttons

PAUSE			equ $0001
FIRE1			equ $0002
FIRE2			equ $0004
FIRE3			equ $0008
OPTION			equ $0010		;bit codes for digital joystick buttons

BITPAUSE		equ 0
BITFIRE1		equ 1
BITFIRE2		equ 2
BITFIRE3		equ 3
BITOPTION		equ 4			;bit positions


;---------------------------------------------------------------------

READKEY10		equ $81fd
READKEY11		equ $81fb
READKEY12		equ $81f7		;commands to read keypad 1 states

READKEY20		equ $81bf
READKEY21		equ $81df
READKEY22		equ $81ef		;commands to read keypad 2 states

KEY_1			equ $0800
KEY_4			equ $0400
KEY_7			equ $0200
KEY_STAR		equ $0100
KEY_2			equ $0080
KEY_5			equ $0040
KEY_8			equ $0020
KEY_0			equ $0010
KEY_3			equ $0008
KEY_6			equ $0004
KEY_9			equ $0002
KEY_HASH		equ $0001		;bit codes for the keypad

BITKEY_1		equ 11
BITKEY_4		equ 10
BITKEY_7		equ 9
BITKEY_STAR		equ 8
BITKEY_2		equ 7
BITKEY_5		equ 6
BITKEY_8		equ 5
BITKEY_0		equ 4
BITKEY_3		equ 3
BITKEY_6		equ 2
BITKEY_9		equ 1
BITKEY_HASH		equ 0		;bit codes for the keypad



;=====================================================================
;Analog Joystick definitions next
;=====================================================================
