DECLARE FUNCTION num$ (n!)
REM Cybermorph exit-portal fix-up program
REM
REM adds inside faces to exit-portals
REM

CLS

DIM p(10)

FOR cf = 0 TO 18
	ifile$ = "portal\exit" + num$(cf) + ".i68"
	ofile$ = "portal\_exit" + num$(cf) + ".i68"
	GOSUB convert
	NEXT

FOR cf = 1 TO 8
	ifile$ = "portal\entry" + num$(cf) + ".i68"
	ofile$ = "portal\_entry" + num$(cf) + ".i68"
	GOSUB convert
	NEXT

STOP

convert:
	OPEN ifile$ FOR INPUT AS #1
	OPEN ofile$ FOR OUTPUT AS #2

PRINT ifile$; " -> "; ofile$

REM Read and adjust the counts

LINE INPUT #1, a$
LINE INPUT #1, a$
i = INSTR(a$, ",")
j = INSTR(MID$(a$, i + 1), ",") + i
k = INSTR(a$, "w")
nvn = VAL(MID$(a$, k + 1))
nfn = VAL(MID$(a$, i + 1)) * 2: REM adjustment
nv = VAL(MID$(a$, j + 1))

PRINT #2, " dc.w "; num$(nvn + nfn + nv)
PRINT #2, " dc.w " + num$(nvn) + "," + num$(nfn); "," + num$(nv)


REM vertex normals
FOR j = 1 TO nvn
	LINE INPUT #1, a$
	PRINT #2, a$
	NEXT

REM face normals (skip then forge)
FOR j = 1 TO nfn / 2
	LINE INPUT #1, a$
	NEXT
FOR j = 1 TO nfn
	PRINT #2, " dc.w 0,0,0,0"
	NEXT

REM vertices
FOR j = 1 TO nv
	LINE INPUT #1, a$
	PRINT #2, a$
	NEXT

REM FACES
LINE INPUT #1, a$
nf = VAL(MID$(a$, INSTR(a$, "w") + 1))
PRINT #2, " dc.w " + num$(nf * 2)

FOR j = 1 TO nf
	LINE INPUT #1, a1$: REM flags ?
	LINE INPUT #1, a2$: REM num points
	LINE INPUT #1, a3$: REM colour
	LINE INPUT #1, a4$: REM image
	LINE INPUT #1, a5$: REM point list
	REM (mostly-)un-altered copy
	a3$ = " dc.w $63C0"
	PRINT #2, a1$
	PRINT #2, a2$
	PRINT #2, a3$
	PRINT #2, a4$
	PRINT #2, a5$
	REM altered one
	b3$ = " dc.w $F6FF"
	b5$ = a5$
	np = VAL(MID$(a2$, INSTR(a2$, "w") + 1))
	a5$ = MID$(a5$, INSTR(a5$, "w") + 1)
	FOR i = 1 TO np
		p(i) = VAL(a5$)
		a5$ = MID$(a5$, INSTR(a5$, ",") + 1)
		NEXT i
	b5$ = " dc.w "
	FOR i = np TO 1 STEP -1
		b5$ = b5$ + num$(p(i))
		IF i > 1 THEN b5$ = b5$ + ","
		NEXT i
	PRINT #2, a1$
	PRINT #2, a2$
	PRINT #2, b3$
	PRINT #2, a4$
	PRINT #2, b5$
NEXT
	CLOSE #1
	CLOSE #2


RETURN

FUNCTION num$ (n)
	IF n >= 0 THEN
		num$ = MID$(STR$(n), 2)
	ELSE
		num$ = STR$(n)
	END IF
END FUNCTION

