;=====================================================================
;Include file which defines some constants and macros specific to this
;project. Due to timescales, we will only be implementing functions we
;need. Some of the macros and definitions in here will migrate to
;ATD.INC for other Jaguar projects.
;=====================================================================
;BUGFIXES:
;
;Some of the macros and definitions in this file get around hardware
;bugs. These bugs are to be fixed for the next revision of the chips,
;and are as follows:
;
;	1)	SET_TEXTOP and SET_GROBJECTOP set DSTEN when plotting. This
;		slows down plotting and should not technically be necessary.
;		REMOVE on next chipset.
;
;=====================================================================
;Current machine RAM memory map:
;
;	00000000	32K for Vectors and boot rom
;	00008000	1.2Mb (ish) for graphics etc
;
;	0012C000	4 x interleaved CRY screens
;	001C2000	static data / other objects
;	001F
;
;=====================================================================
;
;Debugging flags. Allows us to debug each module specifically.

CARTRIDGE		equ 1		;cartridge version or not ??
DEBUGGING		equ 1		;debugging info out?
HALFHEIGHT		equ 1		;half height world?


;Debugging macros now follow. These are for hunting any CRASH bugs!

DEBUGSTATE1		macro
				IFNE DEBUGGING
				move.l #\1,ATDDEBUG
				ENDC
				endm

DEBUGSTATE2		macro
				IFNE DEBUGGING
				move.l #\1,ATDDEBUG+DWORD
				ENDC
				endm

DEBUGSTATE3		macro
				IFNE DEBUGGING
				move.l #\1,ATDDEBUG+DWORD*2
				ENDC
				endm

DEBUGSTATE4		macro
				IFNE DEBUGGING
				move.l #\1,ATDDEBUG+DWORD*3
				ENDC
				endm


;Macro for fixed point shifting (our multiplier is 16384 / 14 bits).

ATDMULTIPLIER	equ 16384			;sinetable and others

FIXEDPTSHIFT	macro
				lsl.l #2,\1			;up 2
				swap \1				;and down 16 = down 14
				endm


;The following macro outputs a registers contents on the PC contole.

LONG_OUT		macro
				IFEQ CARTRIDGE
				PUSH d1
				PUSH \1
				POP d1
				bsr long_out_d1
				POP d1
				ENDC
				endm


;As above, but this time put a space after the value and not CRLF.

LONG_OUTS		macro
				IFEQ CARTRIDGE
				PUSH d1
				PUSH \1
				POP d1
				bsr long_outs_d1
				POP d1
				ENDC
				endm


;Another console macro - this time send carriage return / new line.

CRLF			macro
				IFEQ CARTRIDGE
				bsr send_crlf
				ENDC
				endm


;Set up a pointer to an object structure for system.m68 routines.

SET_CUROBJPTR	macro
				move.l \1,curobjptr(a6)
				endm


;Get the current object structure pointer (for preserving?).

GET_CUROBJPTR	macro
				move.l curobjptr(a6),\1
				endm


;Set up a pointer to a font (phrase aligned) - for textual display etc.

SET_FONT		macro
				move.l \1,curfontptr(a6)
				endm


;System operations work to the front screen object.

TOFRONT			macro
				move.l scrnptrF(a6),a0
				SET_CUROBJPTR a0
				endm


;Similar to the above macro - this time write to the back screen.

TOBACK			macro
				move.l scrnptrB(a6),a0
				SET_CUROBJPTR a0
				endm


;Set the text operation mode (LFU bits of blitter command).

SET_TEXTOP		macro
				move.l \1+UPDA1+DCOMPEN+DSTEN,textop(a6)
				endm


;Similar macro to the above - this one sets the plotgrobject mode.

SET_GROBJECTOP	macro
				move.l \1+UPDA1+DCOMPEN+DSTEN,plotgrop(a6)
				endm


;Issue a message to the console - for debugging purposes.

CONSOLEMSG		macro
				IFEQ CARTRIDGE
				BEGCONST
dstring\@:		dc.b \1
				dc.b 0
				align ALIGNWORD
				ENDCONST
				BEGCODE
				PUSHM <a0-a6/d0-d7>
				lea dstring\@,a0
				jdos ut$puts
				jdos ut$crlf
				POPM <a0-a6/d0-d7>
				ENDC
				endm


;---------------------------------------------------------------------
;General memory related equates.

GPUSEMF			equ $1FFFF0			;semaphore for GPU operations
ATDDEBUG		equ $1FFFE0			;16 byte debug buffer
ATDSTACK		equ $1FFFE0			;10K ish stack which grows down

TOPMEM			equ $110000			;decompress from here down


;---------------------------------------------------------------------
;Equates for angles used in this program (masking and shifts ops).

ANGLE0			equ 0
ANGLE30			equ 21
ANGLE45			equ 32
ANGLE60			equ 43
ANGLE90			equ 64
ANGLE120		equ 85
ANGLE180		equ 128
ANGLE270		equ 192
ANGLE360		equ 256				;angle definitions

SHIFT45			equ 5
SHIFT90			equ 6
SHIFT180		equ 7
SHIFT360		equ 8				;shift multipliers (speed)

MASK45			equ 31
MASK90			equ 63
MASK180			equ 127
MASK360			equ 255				;masks for various operations

UNIT_SCALAR		equ 4096			;unit normal length


;---------------------------------------------------------------------
;CyberMorph specific data structures (3D objects specifically).
;---------------------------------------------------------------------

				STRUCT object3dmin

				ELEMENT obj.x,WORD				;world object centre X
				ELEMENT obj.y,WORD				;world object centre Y
				ELEMENT obj.z,WORD				;world object centre Z
				ELEMENT obj.xa,WORD				;rotation around x-axis
				ELEMENT obj.ya,WORD				;rotation around y-axis
				ELEMENT obj.za,WORD				;rotation around z-axis
				ELEMENT obj.shp,DWORD,ALIGNLONG	;pointer to shape def for object
				ELEMENT obj.type,WORD			;type (used by mover / plotter)

				ENDS object3dmin


;---------------------------------------------------------------------

				STRUCT object3d

				INHERIT object3dmin

				ELEMENT obj.ctype,WORD			;copy of above for collisions
				ELEMENT obj.collcell,DWORD		;speedup for collisions?
				ELEMENT obj.linkptr,DWORD		;linked 3D object ptr
				ELEMENT obj.mover,DWORD			;routine which moves this obj
				ELEMENT obj.collider,DWORD		;routine called upon collison
				ELEMENT obj.udx,WORD			;dx, dy, dz from this move
				ELEMENT obj.udy,WORD			;Used to perform all
				ELEMENT obj.udz,WORD			;collision detection
				ELEMENT	obj.collrad,WORD		;collision radius
				ELEMENT obj.vsize,WORD			;collision height
				ELEMENT obj.collpercent,WORD	;% along path collision occured
				ELEMENT obj.energy,WORD			;object energy
				ELEMENT obj.sframe,WORD			;frame on scanner
				ELEMENT obj.relht,WORD			;relative height above ground?

				ENDS object3d


;---------------------------------------------------------------------

				STRUCT animobj

				INHERIT	object3d

				ELEMENT	anm.animspd,WORD
				ELEMENT	anm.currframe,WORD
				ELEMENT	anm.animcnt,WORD
				ELEMENT	anm.numframe,WORD
				ELEMENT	anm.baseframe,WORD

				ENDS animobj

						 
;---------------------------------------------------------------------

				STRUCT .enemy

				INHERIT	animobj

				ELEMENT nme.hr,WORD			;required height above sea level
				ELEMENT nme.yr,WORD			;required rotation around y-axis
				ELEMENT nme.maxrot,WORD		;maximum rotation speed
				ELEMENT nme.detcone,WORD	;detection cone size
				ELEMENT nme.firecone,WORD	;fire cone size
				ELEMENT nme.thrust,WORD		;enemy ship thrust

				ELEMENT nme.geriatric,WORD	;how slow / fast we poll environment
				ELEMENT nme.counter,WORD	;counter for geriatric

				ELEMENT nme.mislcreat,DWORD	;missile creator/mover routine
				ELEMENT nme.mislspeed,WORD	;missile speed
				ELEMENT nme.misllife,WORD	;missile life span
				ELEMENT nme.mislshape,DWORD	;pointer to definition
				ELEMENT nme.mislenergy,WORD	;missile energy

				ELEMENT nme.link,NULL		;pointer to another enemy / pod
				ELEMENT nme.target,DWORD	;pointer to nme's target

				ELEMENT nme.firerate,BYTE	;firing rate
				ELEMENT nme.linkangle,BYTE	;prefered angle to link obj
				ELEMENT nme.linkdist,WORD	;prefered distance from link obj
				ELEMENT nme.homex,WORD		;co-ordinates of origin/ home
				ELEMENT nme.homez,WORD

				ELEMENT nme.creatcnt,WORD	;creation count (replenish code)

				ELEMENT nme.colptr1,WORD	;pulse colour ptr 1
				ELEMENT nme.colptr2,WORD	;pulse colour ptr 2


				ENDS .enemy,ALIGNLONG


;---------------------------------------------------------------------

				STRUCT	.bldobj

				INHERIT	animobj

				ELEMENT bld.whendead,DWORD	;function called when dead
				ELEMENT bld.flags,WORD		;flags!

				ELEMENT bld.podbase,WORD	;POD base frame (prisons)
				ELEMENT bld.capmover,DWORD	;mover for captured objects
				ELEMENT bld.oldscan,WORD	;scanner frame for captured
				ELEMENT bld.oldtype,WORD	;original type for captured
				ELEMENT bld.oldshp,DWORD	;original shape for captured

				ELEMENT bld.colptr1,WORD	;pulse colour ptr 1
				ELEMENT bld.colptr2,WORD	;pulse colour ptr 2
				ELEMENT bld.colptr3,WORD	;pulse colour ptr 3
				ELEMENT bld.colptr4,WORD	;pulse colour ptr 4
				ELEMENT bld.colptr5,WORD	;pulse colour ptr 5
				ELEMENT bld.colptr6,WORD	;pulse colour ptr 6
				ELEMENT bld.colptr7,WORD	;pulse colour ptr 7
				ELEMENT bld.colptr8,WORD	;pulse colour ptr 8
				ELEMENT bld.colptr9,WORD	;pulse colour ptr 9

				ENDS .bldobj,ALIGNLONG


;---------------------------------------------------------------------

MAXWEAPON		equ	5			;max weapons player can carry


				STRUCT	.player

				INHERIT	animobj

				ELEMENT plr.clrstart,NULL	;-------------------------

				ELEMENT plr.weaponrdy,BYTE	;timer for normal weapons
				ELEMENT plr.superrdy,BYTE	;timer for super weapons
				ELEMENT plr.transport,BYTE	;transporter counter
				ELEMENT plr.speedup,BYTE	;number of fast shots left
				ELEMENT plr.nitroup,BYTE	;Nitro injection time left
				ELEMENT plr.hoopflg,BYTE	;Hoop flag
				ELEMENT plr.thrustix,WORD	;thrust index (into lookup)

				ELEMENT plr.clrend,NULL		;-------------------------

				ELEMENT plr.flags,WORD			;player SPECIFIC flags (see PF. )
				ELEMENT plr.safex,WORD
				ELEMENT plr.safey,WORD
				ELEMENT plr.safez,WORD			;pre crash coords!

				ELEMENT plr.bonusbeg,NULL	;-------------------------

				ELEMENT plr.superw,BYTE				;superweapon flag
				ELEMENT plr.superwcnt,BYTE			;superweapon count
				ELEMENT plr.weaponidx,WORD			;which weapon is selected (index)
				ARRAY plr.weapon,WORD,MAXWEAPON		;counters for slots
				ELEMENT plr.score,DWORD				;score 8 BCD digits
				ELEMENT plr.lives,BYTE				;number of lives

				ELEMENT plr.bonusend,NULL	;-------------------------


				ENDS .player,ALIGNLONG


;---------------------------------------------------------------------

ETYPE_THUNDER	equ $0001
ETYPE_QUAKE		equ $0002
ETYPE_NORMAL	equ $0003					;extra types!


				STRUCT	.missile

				INHERIT	animobj

				ELEMENT mis.etype,WORD		;extra type for THUNDER/QUAKER!
				ELEMENT mis.counter,WORD	;life span in world
				ELEMENT mis.speed,WORD		;speed (if required)
				ELEMENT mis.owner,DWORD		;pointer to parent (player misl)

				ENDS .missile,ALIGNLONG


;---------------------------------------------------------------------

				STRUCT	.dieobj

				INHERIT	animobj

				ELEMENT	die.counter,WORD	;general purpose counter
				ELEMENT die.dy,WORD			;vertical movement on explosions

				ENDS .dieobj,ALIGNLONG


;---------------------------------------------------------------------

				STRUCT	.powerobj

				INHERIT animobj

				ELEMENT power.counter,WORD	;general purpose counter
  				ELEMENT power.hitflag,WORD	;hit flag
				ELEMENT power.colr,WORD		;index into colour table
				ELEMENT power.downtime,WORD	;delay when shot
				ELEMENT power.polltime,WORD	;time to next pollution
				ELEMENT power.polltcnt,WORD	;down counter for above
				ELEMENT power.pollangl,WORD	;pollution angle
				ELEMENT power.pollrad,WORD	;pollution distance/radius


				ENDS .powerobj,ALIGNLONG


;---------------------------------------------------------------------

				STRUCT	.dropobj

				INHERIT animobj

				ELEMENT drop.counter,WORD	;general purpose counter
				ELEMENT drop.handler,DWORD	;weapon handler / ID
				ELEMENT drop.use,WORD		;useage counter
				ELEMENT drop.idx,WORD		;index to move table?
				ELEMENT drop.score,DWORD	;score for collecting
				ELEMENT drop.msg,DWORD		;message on collecting

				ENDS .dropobj,ALIGNLONG


;---------------------------------------------------------------------

				STRUCT	.survobj

				INHERIT animobj

				ELEMENT surv.dist,WORD		;distance of player when beaming-up
				ELEMENT surv.pickup,WORD	;flag indicating we can pick up?
				ELEMENT surv.dietime,WORD	;time to die!

				ENDS .survobj,ALIGNLONG


;---------------------------------------------------------------------

				STRUCT	.exitobj			;exit portal object

				INHERIT animobj

				ELEMENT exit.counter,WORD	;general purpose counter

				ENDS .exitobj,ALIGNLONG


;---------------------------------------------------------------------

				STRUCT	featuresz

				INHERIT object3dmin

				ENDS featuresz,ALIGNLONG


;OBJ3DSZ needs to accommodate largest structure ----------------------

obj3dsz			set .player
				IFGT .enemy-obj3dsz
obj3dsz			set .enemy
				ENDC
				IFGT .missile-obj3dsz
obj3dsz			set .missile
				ENDC
				IFGT .dieobj-obj3dsz
obj3dsz			set .dieobj
				ENDC
				IFGT .powerobj-obj3dsz
obj3dsz			set .powerobj
				ENDC
				IFGT .dropobj-obj3dsz
obj3dsz			set .dropobj
				ENDC
				IFGT .survobj-obj3dsz
obj3dsz			set .survobj
				ENDC
				IFGT .exitobj-obj3dsz
obj3dsz			set .exitobj
				ENDC

				IFGT obj3dsz-128
				MSG '3D OBJECT STRUCTURE TOO BIG'
				ENDC


;---------------------------------------------------------------------
;Macro to clear memory / copy memory very quickly (DWORD mult to 128).

CLRDWORD		macro
				IFGE clrsz-DWORD
clrsz			set clrsz-DWORD
				move.l \2,(\1)+
				ENDC
				endm


CPYDWORD		macro
				IFGE cpysz-DWORD
cpysz			set cpysz-DWORD
				move.l (\2)+,(\1)+
				ENDC
				endm


CLROBJECT		macro
clrsz			set \3
				sub.l \2,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2			;32 bytes

				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2			;64 bytes

				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2			;96 bytes

				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2
				CLRDWORD \1,\2			;128 bytes
				endm


CPYOBJECT		macro
cpysz			set \3
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2			;32 bytes

				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2			;64 bytes

				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2			;96 bytes

				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2
				CPYDWORD \1,\2			;128 bytes
				endm


;Scanner frame indices (blobs on scanner) ----------------------------

HOSTAGEBLOB		equ 1
AENEMYBLOB		equ 2
POLLUTEBLOB		equ 3
HOOPBLOB		equ 4					;standard blob types
BENEMYBLOB		equ 5					;jammers (NOT USED)
GENEMYBLOB		equ 6					;ground (NOT USED)
PORTALBLOB		equ 7					;guess! (NOT USED)


;---------------------------------------------------------------------
;Bits for the type field in OBJ3D (includes delete flags etc).
;
; FFTT		FF = flags
;			TT = type indicator

TYPE_3DSHAPE	equ $0000		;Object is displayed using polygons
TYPE_SPRITE		equ	$8000		;Object is displayed using sprite
TYPE_NOTCOLLIDE	equ $4000		;No longer collidable
TYPE_DEL		equ	$2000		;Remove from list
TYPE_NEW		equ $1000		;Object has NOT been displayed (yet)

BIT_TYPE_DEL	equ	13
BIT_TYPE_NEW	equ	12

OBJ3D_ENEMY		equ	0			;these types are required to get around
OBJ3D_PLAYRMISS	equ	4			;expression evaluation problems of Avocet
OBJ3D_NMEMISS	equ	8
OBJ3D_BUILDING	equ	12
OBJ3D_HOSTAGE	equ	16
OBJ3D_POWER		equ 20
OBJ3D_COLLECT	equ 24
OBJ3D_PLAYER	equ	28
OBJ3D_FEATURE	equ 32
OBJ3D_EXPLOSION	equ	36
OBJ3D_DUD		equ 252

TYPE_ENEMY		equ	(OBJ3D_ENEMY+TYPE_3DSHAPE)
TYPE_SPLAYRMISS	equ	(OBJ3D_PLAYRMISS+TYPE_SPRITE)
TYPE_3PLAYRMISS	equ	(OBJ3D_PLAYRMISS+TYPE_3DSHAPE)
TYPE_NMEMISS	equ	(OBJ3D_NMEMISS+TYPE_3DSHAPE)
TYPE_BUILDING	equ	(OBJ3D_BUILDING+TYPE_3DSHAPE)
TYPE_HOSTAGE	equ	(OBJ3D_HOSTAGE+TYPE_3DSHAPE)
TYPE_POWER		equ (OBJ3D_POWER+TYPE_3DSHAPE)
TYPE_COLLECT	equ (OBJ3D_COLLECT+TYPE_SPRITE)
TYPE_DUD		equ OBJ3D_DUD

TYPE_PLAYER		equ	(OBJ3D_PLAYER+TYPE_3DSHAPE)
TYPE_SFEATURE	equ (OBJ3D_FEATURE+TYPE_SPRITE)
TYPE_3FEATURE	equ (OBJ3D_FEATURE+TYPE_3DSHAPE)
TYPE_EXPLOSION	equ	(OBJ3D_EXPLOSION+TYPE_SPRITE)


ESHIFT			equ	5			;shift amount for obj.energy constants

MAX3DOBJ		equ	256			;max number of 3D objects
MAXNMETYPES		equ 8			;max different enemy per level
MAXFEATTYPES	equ 8			;max different feature types per level
MAXANMFRAMES	equ 16			;max animation frames?
MINGENDIST		equ 6144		;min distance between generated obj

INITPOWER		equ (100<<ESHIFT)	;players' initial shield level
INITLIVES		equ	2				; Number of lives (-1)

GRNDHEIGHT		equ 140			;height of objects above ground


;Player flags --------------------------------------------------------

PF.jammed		equ 1			;bit 0 : true means radar jammed
PF.shagged		equ 2			;bit 1 : you've got a biosphere on your back
PF.thunder		equ 4			;bit 2 : true if player has JUST fired Thndrqk
PF.cockpit		equ 8			;bit 3 : cockpit view?
PF.sights		equ 16			;bit 4 : sights enabled / disabled?
PF.hit			equ 32			;bit 5 : indicates collision last time
PF.hithoop		equ 64			;bit 6 : indicates we hit hoop edge

PF.closecam		equ 128			;bit 7 : close camera? (cockpit related)
PF.hitgnd		equ 256			;bit 8 : indicates we hit the ground
PF.invincible	equ	512			;bit 9 : true while player is invincible

PFBIT.jammed	equ 0
PFBIT.shagged	equ 1
PFBIT.thunder	equ 2
PFBIT.cockpit	equ 3
PFBIT.sights	equ 4
PFBIT.hit		equ 5
PFBIT.hithoop	equ 6

PFBIT.closecam	equ 7
PFBIT.hitgnd	equ 8
PFBIT.invincibl	equ 9


;----------------------------------------------------------------------
;The following maximums are for collision checks - unique list of types

MAXESHIPS		equ 64			;practical enemy limit = 40
MAXPMISSILES	equ 64			;realistic maximum is 32
MAXEMISSILES	equ 192			;realistic maximum is 80
MAXBUILDINGS	equ 192			;practical building limit 96
MAXHOSTAGES		equ 48			;practical hostage max 24
MAXPTOWERS		equ 12			;practical maximum 8
MAXCOLLECTS		equ 64			;realistic maximum is 40

MAXCOLLISIONS	equ 256			;collisions in a cycle (realistically 50)

MAXRADARBLOBS	equ 100			;realistically never > 40


;---------------------------------------------------------------------
;Equates relating to the dropping of collectables by enemy and ptowers

DROPPROBMASK	equ 3					;25% chance of dropping
DROPHT			equ 160					;height of power towe curve
DROPSPEED		equ 50					;speed of power tower collects


;---------------------------------------------------------------------
;Equates related to the screens (conventional 2 screen system).

screenram		equ $110000					;base for screens (above 1Mb)
screenw			equ 320						;width of screen
screenh			equ 240						;height of screen
screensz		equ (screenw*288*2)			;size of PAL CRY screen object
panelht			equ 53						;status height
headw			equ 48
headht			equ 57						;holographic head height

screen1			equ screenram				;screen 1 above 1Mb
screen2			equ (screenram+PHRASE)		;screen 2 interleaved
screen3			equ (screenram+PHRASE*2)	;screen 3 interleaved
fadephrase		equ (screen1+screensz*4)	;fade phrase immediately after
panelmem1		equ (fadephrase+PHRASE)			;status panel defn (8 bits)
panelmem2		equ (panelmem1+screenw*panelht)	;status panel defn (8 bits)
headmemory		equ (panelmem2+screenw*panelht)	;head definitions (39672)
freememory		equ headmemory+39672			;not currently used


;---------------------------------------------------------------------
; INITIALISER SYSTEM
;---------------------------------------------------------------------
;
; The initialiser MACRO may only be used within the CODE section.
;
; example of use
;
;
;			BEGCODE
;
;			...
;
; label:	INITIALISER	iSYSTEM
;			blah	blah,blah
;			...
;			rts
;
;			
;			...
;			ENDCODE
;
;---------------------------------------------------------------------

iSYSTEM			equ	0
iNEWGAMEclr		equ	10
iNEWGAME		equ	15
iNEWLEVELclr	equ	20
iNEWLEVEL		equ	25

				global	iFIRST,initialisers		;in file FIRST.M68
				global	iLAST,initmode			;in file FIRST.M68



INITIALISER		macro	; (initlevel)
				
init\@:
;				ENDCODE

				section 3
				cmp.w	#\1,initmode
				bne.s	init2\@			;skip if initmode>initlevel
				jsr		init\@
init2\@:
;				BEGCODE
				section 0

				endm


;---------------------------------------------------------------------
;Clear memory from start to end (inclusive) to zero.


CLEARMEM		MACRO	;start,end

				lea	\1,a0
				move.w	#(\2)-(\1)-1,d7
clearmem\@:		clr.b	(a0)+
				dbra	d7,clearmem\@
			
				ENDM



