;=====================================================================
; THE GPU/68k COMMON FILE
;=====================================================================


;=====================================================================
; WORLD SIZE DEFININTIONS
;=====================================================================

GSHIFT		equ 1		; world size : 0=128 1=64 2=32 etc...

WINDOWSHIFT	equ	GSHIFT	; window size : 0=128 etc.. (SHOULD ALWAYS==GSHIFT)
COORDSHIFT	equ	GSHIFT	; co-ordinate shift inside floor plotter (SHOULD ALWAYS==GSHIFT)
FRACTSHIFT	equ GSHIFT		; window size for landscape generator (SHOULD ALWAYS==GSHIFT)
FLSHIFT		equ	GSHIFT	; what size FLOOR.M15 thinks the world is
ALLOCSHIFT	equ GSHIFT	; what size alloc thinks the world is
DSHIFT		equ	GSHIFT	;how to adjust distances/speeds

WORLDSIZE	equ	(128>>GSHIFT)		; world size 128/64/32...
WORLDSHIFT	equ (7-WINDOWSHIFT)		; number of bits in a world co-ordinate
FWORLDSIZE	equ (128>>FRACTSHIFT) 	; fractal size 128/64/32... (s/b == WORLDSIZE)
FLWORLDSIZE equ	(128>>FLSHIFT)		; size of the world for FLOOR.M15
MAPAREA		equ ((128>>ALLOCSHIFT)+1)*((128>>ALLOCSHIFT)+1)

screenZA	equ	(-1000)
screenZW	equ	((screenZA)<<DSHIFT)

eyeZA		equ	(-1200)
eyeZW		equ ((eyeZA)<<DSHIFT)

;=====================================================================
; PLOT MODE DEFS
;=====================================================================


PIXPOLY		equ	0					; Set this to 1/0 for pixel/phrase mode
PHRPOLY		equ (1-PIXPOLY)			;  polygon plotting


;=====================================================================
; Lighting defs
;=====================================================================

lightX	equ			0
lightY	equ			(1114/2)
lightZ	equ			(-3714/2)
lightAMB equ		96
