;---------------------------------------------------------------------
;Jaguar Internal Registers
;---------------------------------------------------------------------

memcon1			equ	0
memcon2			equ	2
hc				equ	4
vc				equ	6
lph				equ	8
lpv				equ	$0a
clk1			equ	$0c
clk2			equ	$0e
olp1			equ	$20
olp2			equ	$22
;odp				equ	$24				;no longer exists on RAPIER
vmode			equ	$28
bord1			equ	$2a
bord2			equ	$2c
hp				equ	$2e
hbb				equ	$30
hbe				equ	$32
hs				equ	$34
hvs				equ	$36
hdb1			equ	$38
hdb2			equ	$3a
hde				equ	$3c
vp				equ	$3e
vbb				equ	$40
vbe				equ	$42
vs				equ	$44
vdb				equ	$46
vde				equ	$48
veb				equ	$4a
vee				equ	$4c
vi				equ	$4e
pit0			equ	$50
pit1			equ	$52
heq				equ	$54
test1			equ	$56
bg				equ	$58
int1			equ	$e0
int2			equ	$e2

clut			equ	$400
palette			equ clut				;alternative naming convention


;---------------------------------------------------------------------
;Jaguar GPU Locations
;---------------------------------------------------------------------

gpubase			equ	$F00000
gpuflags		equ	$2100
gpudorg			equ	$210C
gpu_pc			equ	$2110
gpuctrl			equ	$2114
gpu_ram			equ	$3000


;---------------------------------------------------------------------
;Blitter
;---------------------------------------------------------------------

blit_a1base		equ	$2200
blit_a1flags	equ	$2204
blit_a1clipsize	equ	$2208
blit_a1pixptr	equ	$220C
blit_a1rdpixptr	equ $2204				;read back a1pixptr (BUG)
blit_a1step		equ	$2210
blit_a1stepf	equ	$2214
blit_a1pixptrf	equ	$2218
blit_a1inc		equ	$221C
blit_a1incf		equ	$2220
blit_a2base		equ	$2224
blit_a2flags	equ	$2228
blit_a2addrmask	equ	$222C
blit_a2pixptr	equ	$2230
blit_a2rdpixptr	equ $222c				;read back a2pixptr (BUG)
blit_a2step		equ	$2234
blit_cmd		equ	$2238
blit_status		equ	$2238				;read back status from cmd
blit_count		equ	$223C
blit_srcd		equ	$2240
blit_dstd		equ	$2248
blit_dstz		equ	$2250
blit_srcz1		equ	$2258
blit_srcz2		equ	$2260
blit_patd		equ	$2268
blit_iinc		equ	$2270
blit_zinc		equ	$2274

blit_intensity0	equ $227c
blit_intensity1	equ $2280
blit_intensity2	equ $2284
blit_intensity3	equ $2288

;---------------------------------------------------------------------
;DSP locations
;---------------------------------------------------------------------

dspbase		equ	$F18000
dspflags	equ	$2100
dspdorg		equ	$210C
dsp_pc		equ	$2110
dspctrl		equ	$2114
dsp_ram		equ	$3000
