*********************************************************
*	jdos.inc					*
*							*
*	Copyright (c) Flare II Ltd., 1992		*
*							*
*********************************************************

;	Main JDOS include file.

;	03-Mar-1992	Si		Originated.
;	27-Jul-1992	Si		Add switches to control DRAM columns.

*********************************************************
*	Conditional Assembly Switches...		*
*********************************************************

KITTEN	equ	0			; 1 -> JDOS for Kitten
FELIX	equ	0			; 1 -> JDOS for Felix
CONSOLE	equ	1			; 1 -> JDOS for Felix

K000	equ	1			; 1 -> 68000
K030	equ	0			; 1 -> 68030

M16	equ	0			; 1 -> 16 bit memory
M32	equ	0			; 1 -> 32 bit memory
M64	equ	1			; 1 -> 64 bit memory

C__256	equ	1			; 1 -> 256 columns in DRAM 0 & 1
C__512	equ	0			; 1 -> 512 columns in DRAM 0 & 1
C_1024	equ	0			; 1 -> 1024 columns in DRAM 0 & 1
C_2048	equ	0			; 1 -> 2048 columns in DRAM 0 & 1

ROM	equ	1			; 1 -> put JDOS in ROM
					; 0 -> RAM-based version of JDOS - run
					;      under JDOS with "j jdos".
					;      There's a similar switch in
					;      "jdos.mak" - remember to set
					;      that one too.

FDISK	equ	0			; 1 -> floppy disk present
HDISK	equ	0			; 1 -> hard disk present

A0_MOD	equ	1			; 1 -> parallel I/O has a0 mod
A1_MOD	equ	1			; 1 -> parallel I/O has a1 mod

NEWPROT	equ	1			; 1 -> new protocol

*********************************************************
*	Target Microprocessor...			*
*********************************************************

	ifne	K000
	OPT P=68000
	endc

	ifne	K030
	OPT P=68030
	endc

*********************************************************
*	ASCII control codes...				*
*********************************************************

NUL	equ	$00		; Null.
SOH	equ	$01		; Start of heading.
STX	equ	$02		; Start of text.
ETX	equ	$03		; End of text.
EOT	equ	$04		; End of transmission.
ENQ	equ	$05		; Enquiry.
ACK_	equ	$06		; Acknowledge.
BEL	equ	$07		; Bell.
BS	equ	$08		; Backspace.
HT	equ	$09		; Horizontal tab.
LF	equ	$0A		; Line feed.
VT	equ	$0B		; Vertical tab.
FF	equ	$0C		; Form feed.
CR	equ	$0D		; Carriage return.
SO	equ	$0E		; Shift out.
SI_	equ	$0F		; Shift in.
DLE	equ	$10		; Data link escape.
DC1	equ	$11		; Device control 1.
DC2	equ	$12		; Device control 2.
DC3	equ	$13		; Device control 3.
DC4	equ	$14		; Device control 5.
NAK	equ	$15		; Negative acknowledge.
SYN	equ	$16		; Synchronous idle.
ETB	equ	$17		; End of transmission block.
CAN	equ	$18		; Cancel.
EM	equ	$19		; End of medium.
SUB_	equ	$1A		; Substitute.
ESC_	equ	$1B		; Escape.
FS_	equ	$1C		; File separator.
GS_	equ	$1D		; Group separator.
RS	equ	$1E		; Record separator.
US	equ	$1F		; Unit separator.
SP_	equ	$20		; Space.
DEL	equ	$7F		; Delete.

*********************************************************
*	68K Exception Vectors...			*
*********************************************************

xv_berr	equ	$008			; Bus Error
xv_addr	equ	xv_berr+4		; Address Error
xv_ilin	equ	xv_addr+4		; Illegal Instruction
xv_zero	equ	xv_ilin+4		; Zero Divide
xv_chk	equ	xv_zero+4		; CHK Instruction
xv_trap	equ	xv_chk+4		; TRAPV Instruction
xv_priv	equ	xv_trap+4		; Privilege Violation
xv_tr	equ	xv_priv+4		; Trace

xv_int1	equ	xv_tr+$40		; Level 1 Interrupt
xv_int2	equ	xv_int1+4		; Level 2 Interrupt
xv_int3	equ	xv_int2+4		; Level 3 Interrupt
xv_int4	equ	xv_int3+4		; Level 4 Interrupt
xv_int5	equ	xv_int4+4		; Level 5 Interrupt
xv_int6	equ	xv_int5+4		; Level 6 Interrupt
xv_int7	equ	xv_int6+4		; Level 7 Interrupt
xv_t_0	equ	xv_int7+4		; TRAP #0
xv_t_1	equ	xv_t_0+4		; TRAP #1
xv_t_2	equ	xv_t_1+4		; TRAP #2
xv_t_3	equ	xv_t_2+4		; TRAP #3
xv_t_4	equ	xv_t_3+4		; TRAP #4
xv_t_5	equ	xv_t_4+4		; TRAP #5
xv_t_6	equ	xv_t_5+4		; TRAP #6
xv_t_7	equ	xv_t_6+4		; TRAP #7
xv_t_8	equ	xv_t_7+4		; TRAP #8
xv_t_9	equ	xv_t_8+4		; TRAP #9
xv_t_A	equ	xv_t_9+4		; TRAP #A
xv_t_B	equ	xv_t_A+4		; TRAP #B
xv_t_C	equ	xv_t_B+4		; TRAP #C
xv_t_D	equ	xv_t_C+4		; TRAP #D
xv_t_E	equ	xv_t_D+4		; TRAP #E
xv_t_F	equ	xv_t_E+4		; TRAP #F

*********************************************************
*	ROM/RAM and I/O...                              *
*********************************************************

gpio0	equ	$0000
gpio1	equ	$1000
gpio2	equ	$2000
gpio3	equ	$3000
gpio4	equ	$4000
gpio5	equ	$5000
gpio6	equ	$6000
gpio7	equ	$7000

*	Kitten is easy...

	ifne	KITTEN

rambase	equ	$4000000 		; base of internal RAM
ramtop	equ	rambase+$20000		; end of internal RAM
iobase	equ	$0410000		; expansion IO
bootrom	equ	$0000000		; base of bootstrap ROM after mem set 
leds	equ	gpio7+1

regbase	equ	$0400000

	endc

*
* On power up Jaguars memory map looks like this.
* 
* 	Address			Device
* 
* 	0       to 4M		Bootstrap ROM
* 	4M      to 4M+64k	Jaguar internal memory/registers
* 	4M+64k  to 4M+128k	Peripherals
*       4M+128k to 16M		Bootstrap ROM
* 
* 
* This 16M map repeats throughout all memory. All memory space is ROM0 space.
* 
* When using 68000 with Jaguar the ROMHI bit will be set in Jaguars Memory
* Configuration Register. This results in a Jaguar memory map like this:
* 
* 
* 	Address			Device
* 	
* 	0    to 32M		DRAM0
* 	32M  to 64M		DRAM1
* 	64M  to 96M		RAM0
* 	96M  to 112M		ROM1
* 	112M to 128M		ROM0
* 
* 
* When the memory configuration registers are set up the 68000s memory map
* looks like this:-
* 
* 	Address			Device		
* 
* 	0        to 8M		DRAM0
* 	8M       to 12M		ROM1 (Cartridge)
* 	12M      to 13M		ROM0 (Bootstrap)
* 	13M      to 13M+64k	Jaguar internal registers/memory
*	13M+64k  to 13M+96k	DSP
* 	13M+96k  to 13M+128k	Peripherals
* 	13M+128k to 16M		ROM0 (Bootstrap)
* 
*	000000-7FFFFF 		DRAM0
*	800000-BFFFFF 		ROM1 (Cartridge)
*	C00000-CFFFFF		ROM0 (Bootstrap)
*	D00000-D0FFFF		Jaguar internal registers/memory
*	D10000-D17FFF		DSP
*	D18000-D1FFFF		Peripherals (GPIO0-7)
*	D20000-FFFFFF		ROM0 (Bootstrap)
*
* The 68030s memory map looks like this:- 
*
* 	Address			Device
* 	
* 	0    to 32M		DRAM0
* 	32M  to 64M		DRAM1
* 	64M  to 96M		RAM0
* 	96M  to 112M		ROM1
* 	112M to 128M		ROM0
*
*	0000000-1FFFFFF		DRAM0	(32M)
*	2000000-3FFFFFF		DRAM1	(32M)
*	4000000-5FFFFFF		RAM0	(32M)
*	6000000-6FFFFFF		ROM1	(16M)
*	7000000-73FFFFF		Bootstrap ROM	(4M)
*	7400000-740FFFF		Jaguar internal memory/registers (64K)
*	7410000-7417FFF		DSP
*	7418000-741FFFF		Peripherals (GPIOs) (64K)
*	7420000-7FFFFFF		ROM0    ()
*
* Because bootstrap ROM appears everywhere after reset, the reset vector at
* address 0 will vector the processor to 12M+a bit (The bit being big enough
* to clear the vector table). In this way when the memory map changes, as a 
* result of the setting of the ROMHI bit, the processor still fetches its 
* next instruction from the same physical location in the bootstrap ROM as it 
* would have had the memory map not changed.
*
	ifne	FELIX

rambase	equ	$00000000 		; base of internal RAM
ramtop	equ	rambase+$00800000	; end of internal RAM
memcon_1st equ	$400000			; add changes when the reg si config'd 

	ifne	K000

iobase	equ	$00D18000 		; expansion IO
bootrom	equ	$00C00000		; base of bootstrap ROM after mem set 
regbase	equ	$00D00000
leds	equ	gpio7+1

	endc


	ifne	K030

iobase	equ	$07418000 		; expansion IO
bootrom	equ	$07000000		; base of bootstrap ROM after mem set 
regbase	equ	$07400000
leds	equ	gpio7+3

	endc


	endc

	ifne	CONSOLE

rambase	equ	$000000 		; base of internal RAM
ramtop	equ	rambase+$800000		; end of internal RAM
memcon_1st equ	$100000			; add changes when the reg si config'd 

iobase	equ	$F14000 		; expansion IO
bootrom	equ	$E00000			; base of bootstrap ROM after mem set 
regbase	equ	$F00000
leds	equ	gpio7+1

	endc
	
dosseg	equ	rambase			; start of DOS area
ds_size	equ	$8000			; size of DOS area
ds_end	equ	dosseg+ds_size		; end of DOS area

	ifne	C__256

W16	equ	%0011000101000100	; (3144h) 16 bit memory, 256 cols
W32	equ	%0011000110001000	; (3188h) 32 bit memory, 256 cols
W64	equ	%0011000111001100	; (31CCh) 64 bit memory, 256 cols

	endc

	ifne	C__512

W16	equ	%0011000101010101	; (3155h) 16 bit memory, 512 cols
W32	equ	%0011000110011001	; (3199h) 32 bit memory, 512 cols
W64	equ	%0011000111011101	; (31DDh) 64 bit memory, 512 cols

	endc

	ifne	C_1024

W16	equ	%0011000101100110	; (3166h) 16 bit memory, 1024 cols
W32	equ	%0011000110101010	; (31AAh) 32 bit memory, 1024 cols
W64	equ	%0011000111101110	; (31EEh) 64 bit memory, 1024 cols

	endc

	ifne	C_2048

W16	equ	%0011000101110111	; (3177h) 16 bit memory, 2048 cols
W32	equ	%0011000110111011	; (31BBh) 32 bit memory, 2048 cols
W64	equ	%0011000111111111	; (31FFh) 64 bit memory, 2048 cols

	endc

*********************************************************
*	82C711...					*
*********************************************************
*
par_add		equ	gpio0 		* Board address (set by jumper)
cent_add	equ	par_add+$279	* Centronics port address ($278)
*					* set in init_mfp
*					* Don't forget to change psr,pdr,pcr
*					* if you change cent_add.
cfg_ix_reg	equ	par_add+$3f1	* ($3f0)
cfg_reg		equ	par_add+$7f1	* ($3f1)

b_pstrb		equ	6			*bit number 
b_fdav		equ	1
b_pdir		equ	4
b_pack		equ	3
b_ct_dir	equ	5


*status returns
st_good		equ	0
st_no_char	equ	1
st_wrg_dir	equ	2

*********************************************************
*	Cards...					*
*********************************************************

pario		equ	iobase+gpio0	; I/O base of parallel I/O card

*********************************************************
*	JDOS services...				*
*********************************************************

ut$jdos		equ	0		; Get JDOS pointers.
ut$l2int	equ	ut$jdos+1	; Set level 2 interrupt handler.
ut$l2clr	equ	ut$l2int+1	; Clear level 2 interrupt in ICR.
ut$putc		equ	ut$l2clr+1	; O/P char to console.
ut$crlf		equ	ut$putc+1	; O/P CR/LF pair to console.
ut$opb_l	equ	ut$crlf+1	; O/P binary long.
ut$opb_w	equ	ut$opb_l+1	; O/P binary word.
ut$opb_b	equ	ut$opb_w+1	; O/P binary byte.
ut$opd_l	equ	ut$opb_b+1	; O/P decimal long.
ut$opx_l	equ	ut$opd_l+1	; O/P hex long.
ut$opx_w	equ	ut$opx_l+1	; O/P hex word.
ut$opx_b	equ	ut$opx_w+1	; O/P hex byte.
ut$opx_n	equ	ut$opx_b+1	; O/P hex nibble.
ut$puts		equ	ut$opx_n+1	; O/P string to console.
ut$line		equ	ut$puts+1	; O/P string + CR/LF to console.
ut$getc		equ	ut$line+1	; I/P char from console.
ut$gets		equ	ut$getc+1	; I/P string from console.
ut$skip		equ	ut$gets+1	; Skip gap or args in commands.
ut$ltou		equ	ut$skip+1	; Convert long to unsigned dec. str.
ut$ntol		equ	ut$ltou+1	; Convert string to long.
ut$narg		equ	ut$ntol+1	; Get next numeric arg in argv.
ut$idcom	equ	ut$narg+1	; Identify command.
ut$cmnd		equ	ut$idcom+1	; Identify command and execute.
ut$xdmp		equ	ut$cmnd+1	; Produce hex dump.
ut$dis		equ	ut$xdmp+1	; Produce disassembly.
dk$setwd	equ	ut$dis+1	; Set drive's working directory.
dk$getwd	equ	dk$setwd+1	; Get drive's working directory.
dk$open		equ	dk$getwd+1	; Open file.
dk$setpos	equ	dk$open+1	; Set file position.
dk$getpos	equ	dk$setpos+1	; Get file position.
dk$putc		equ	dk$getpos+1	; Write next char.
dk$load		equ	dk$putc+1	; Load file.
dk$getnx	equ	dk$load+1	; Read next char.
dk$getc		equ	dk$getnx+1	; Read next char and advance file pos.
dk$feof		equ	dk$getc+1	; Test for end of file.
dk$vinf		equ	dk$feof+1	; Get volume information.
dk$close	equ	dk$vinf+1	; Close file.
hd$reset	equ	dk$close+1	; Reset hard disk.
hd$read		equ	hd$reset+1	; Read from hard disk.
hd$write	equ	hd$read+1	; Write to hard disk.
fd$reset	equ	hd$write+1	; Reset floppy disk.
fd$read		equ	fd$reset+1	; Read from floppy disk.
fd$write	equ	fd$read+1	; Write to floppy disk.
hp$alloc	equ	fd$write+1	; Allocate heapspace.
hp$free		equ	hp$alloc+1	; Free heapspace.
lp$getc		equ	hp$free+1	; I/P char from parallel port.
lp$igetl	equ	lp$getc+1	; I/P LE long word and convert to BE.
lp$igetw	equ	lp$igetl+1	; I/P LE word and convert to BE.
lp$load		equ	lp$igetw+1	; Load bytes from parallel port.
lp$flen		equ	lp$load+1	; Get file length from parallel port.
lp$fload	equ	lp$flen+1	; Load file from parallel port.
lp$putc		equ	lp$fload+1	; O/P char to parallel port.
c1$open		equ	lp$putc+1 	; Initialise serial port 1.
c1$getc		equ	c1$open+1	; I/P char from serial port 1.
c1$putc		equ	c1$getc+1	; O/P char to serial port 1.
m1$open		equ	c1$putc+1	; Initialise mouse 1.
m1$getxy	equ	m1$open+1	; Get world coords of mouse 1.
m1$setxy	equ	m1$getxy+1	; Set world coords of mouse 1.
c2$open		equ	m1$setxy+1 	; Initialise serial port 2.
c2$getc		equ	c2$open+1	; I/P char from serial port 2.
c2$putc		equ	c2$getc+1	; O/P char to serial port 2.
m2$open		equ	c2$putc+1	; Initialise mouse 2.
m2$getxy	equ	m2$open+1	; Get world coords of mouse 2.
m2$setxy	equ	m2$getxy+1	; Set world coords of mouse 2.
gp$lrun		equ	m2$setxy+1	; Load GPU prog into int. RAM & run.
gp$lstp		equ	gp$lrun+1	; Load GPU prog into int. RAM & step.
gp$lrunx	equ	gp$lstp+1	; Load GPU prog into ext. RAM & run.
gp$lstpx	equ	gp$lrunx+1	; Load GPU prog into ext. RAM & step.
gp$load		equ	gp$lstpx+1	; Load GPU prog into int. RAM.
gp$loadx	equ	gp$load+1	; Load GPU prog into ext. RAM.
gp$args		equ	gp$loadx+1	; Set args in last GPU prog loaded.
gp$argsx	equ	gp$args+1	; Set args in last ext. GPU pr.loaded.
gp$run		equ	gp$argsx+1	; Run last GPU prog loaded.
	
illegal	equ	$04AFC


debug	macro
	dc.w	illegal
	endm

jdos	macro	
	move.w	#\1,d0
	moveq	#-1,d3
	trap	#1
	endm

*********************************************************
*	Magic Numbers...                                *
*********************************************************

stk_siz	equ	10*1024		; approximate max stack size

seclen	equ	512		; length of a physical sector
trklen	equ	18*seclen	; length of a physical track
reclen	equ	seclen		; length of a file record
drv_ini	equ	'C'		; default drive
tries	equ	3		; retry three times

no_drv	equ	4		; system can cope with this many drives
no_fcb	equ	4		; system can cope with eight FCBs

fln_len	equ	8				; filename length
xln_len	equ	3				; filename extension length
pth_len	equ	2+10*(2+fln_len+xln_len)+2	; pathname length

prt_ofs	equ	$01BE		; offset of partition table in sector
max_prt	equ	4		; maximum number of partitions

qd_lim	equ	2048		; max. files in fast-open directory

fgr_siz	equ	2		; number of sectors in FAT group

num_bp	equ	1+8		; number of debugger breakpoints

com_siz	equ	256		; max lenght of command, incl NULL

*********************************************************
*	Structures for Filing System...                 *
*********************************************************

*	File Control Block

fcb_fnm	equ	0		; X filename 
fcb_ext	equ	fcb_fnm+fln_len	; X file extension
fcb_fl1	equ	fcb_ext+xln_len	; B flags
fod	equ	0		;   1 -> file is FO directory
fof	equ	1		;   1 -> file is FO file
eoc	equ	2		;   1 -> 0FFFFh encountered in cluster chain

fcb_dd	equ	fcb_fl1+1	; L o DD
fcb_nxt	equ	fcb_dd+4	; L o next active FCB, or 0
fcb_par	equ	fcb_nxt+4	; L first cluster in parent directory
fcb_fst	equ	fcb_par+4	; L first cluster in file
fcb_clu	equ	fcb_fst+4	; L cluster containing current sector
fcb_sec	equ	fcb_clu+4	; L sec. no. of first sector in cluster
fcb_len	equ	fcb_sec+4	; L total length of file
fcb_pos	equ	fcb_len+4	; L current position within file
fcb_atr	equ	fcb_pos+4	; B attribute byte
r_only	equ	0		;   1 -> file is read only
hidden	equ	1		;   1 -> file is hidden
system	equ	2		;   1 -> file is system file
volume	equ	3		;   1 -> volume label
direct	equ	4		;   1 -> subdirectory
archiv	equ	5		;   1 -> archive bit

root	equ	6		;   1 -> directory is root directory
secc	equ	7		;   1 -> buffered sector has been modified

*	Open modes...

op_rw	equ	0     		;   R/W file
op_r	equ	1<<r_only	;   R file
op_rwd	equ	1<<direct	;   R/W directory
op_rd	equ	op_rwd!op_r	;   R directory

fcb_cls	equ	fcb_atr+1	; B o current sector in cluster
fcb_ofs	equ	fcb_cls+1	; W o file position in buffered sector
fcb_ary	equ	fcb_ofs+2	; L o fast open array
fcb_asz	equ	fcb_ary+4	; W number of files in fast open array
fcb_num	equ	fcb_asz+2	; W number of file in fast open array
fcb_pth	equ	fcb_num+2	; X file's path
fcb_buf	equ	fcb_pth+pth_len	; X sector buffer
fcb_siz	equ	fcb_buf		;   size of an FCB


*	File position...

fp_fl1	equ	0		; B flags:
fp_del	equ	0		; 1 -> struc. indicates pos. of del ent in dir
fp_eoc	equ	1       	; 1 -> fcb_eoc when struecture set up

fp_cls	equ	fp_fl1+1	; B offset of sector in cluster
fp_ofs	equ	fp_cls+1	; W offset of position in buffered sector
fp_clu	equ	fp_ofs+2	; L cluster containing position
fp_sec	equ	fp_clu+4	; L log. sec. no. of first sector in cluster
fp_pos	equ	fp_sec+4	; L absolute position in file
fp_siz	equ	fp_pos+4	;   size of a file position


*	Directory Entry...

ent_fnm	equ	0		; X filename 
ent_ext	equ	ent_fnm+fln_len	; X extension
ent_atr	equ	ent_ext+xln_len	; B attribute byte
atrmsk1	equ	((1<<direct)!(1<<volume)!(1<<system)!(1<<hidden))
atrmsk2	equ	(1<<archiv)!atrmsk1!(1<<r_only)

ent_res	equ	ent_atr+1	; X reserved area
ent_tim	equ	ent_res+10	; W time created or last updated
ent_dat	equ	ent_tim+2	; W date created or last updated
ent_clu	equ	ent_dat+2	; W start cluster
ent_len	equ	ent_clu+2	; L file size
ent_siz	equ	ent_len+4	;   size of a directory entry

ent_eod	equ	0		; EOD marker
ent_era	equ	$E5		; erased file marker
	

*	Partition Table Entry...

prt_ind	equ	0		; B boot indicator
prt_hed	equ	prt_ind+1	; B starting head
prt_rec	equ	prt_hed+1	; B starting sector
prt_cyl	equ	prt_rec+1	; B starting cylinder
prt_sid	equ	prt_cyl+1	; B system ID
prt_noh	equ	prt_sid+1	; B ending head
prt_uk2	equ	prt_noh+1	; B ending sector
prt_uk3	equ	prt_uk2+1	; B ending cylinder
prt_fst	equ	prt_uk3+1	; L first partition sector
prt_tot	equ	prt_fst+4	; L total sectors in partion
prt_siz	equ	prt_tot+4	;   size of a partition table entry


*	Disk Parameter Block...

dpb_jmp	equ	0		;   jump to bootstrap routine
dpb_oem	equ	dpb_jmp+3	;   OEM name and version
dpb_bps	equ	dpb_oem+fln_len	; W bytes per sector
dpb_spa	equ	dpb_bps+2	; B sectors per allocation unit
dpb_res	equ	dpb_spa+1	; W reserved sectors
dpb_nof	equ	dpb_res+2	; B number of FATs
dpb_ent	equ	dpb_nof+1	; W number of root directory entries
dpb_tot	equ	dpb_ent+2	; W total number of sectors in logical volume
dpb_mdb	equ	dpb_tot+2	; B media descriptor byte
dpb_spf	equ	dpb_mdb+1	; W number of sectors per FAT
dpb_spt	equ	dpb_spf+2	; W sectors per track
dpb_noh	equ	dpb_spt+2	; W number of heads
dpb_hid	equ	dpb_noh+2	; W number of hidden sectors
dpb_sp0	equ	dpb_hid+2	; W reserved
dpb_totl equ	dpb_sp0+2	; L total number of sectors if TOT=0
dpb_siz	equ	dpb_totl+4	;   size of a disk parameter block

	
*	Drive Descriptor

dd_sel	equ	0		; B drive select number
hard	equ	7		;   1 -> hard disk

dd_flg0	equ	dd_sel+1	; B flags:
dpbv	equ	0		;   1 -> DPB is valid
motor	equ	1		;   1 -> motor is on
hd	equ	2		;   X -> current physical head
inst	equ	3		;   1 -> recursion through fdc_inst disabled
fatv	equ	4		;   1 -> FAT is valid
fatc	equ	5		;   1 -> FAT has changed
valid	equ	6		;   1 -> disk is valid after inactivity
ac_lok	equ	7		;   1 -> inactivity lock

dd_flg1	equ	dd_flg0+1	; B flags:
fat12	equ	0		;   1 -> 12-bit FAT entries
fat16	equ	1		;   1 -> 16-bit FAT entries
frec	equ	2		;   1 -> "dd_fre" is valid

dd_sp0	equ	dd_flg1+1	; B spare

dd_fcb	equ	dd_sp0+1	; L offset of list of active FCBs

dd_fnum	equ	dd_fcb+4	; W number of FAT group in FAT buffer
dd_fgr	equ	dd_fnum+2	; W size of a FAT group in bytes
dd_frec	equ	dd_fgr+2	; L first free cluster in FAT (if frev=1)

dd_len	equ	dd_frec+4	; L amount of data during DMA
dd_dma	equ	dd_len+4	; L DMA o
dd_L	equ	dd_dma+4	; L current logical sector
dd_C	equ	dd_L+4		; W current physical cylinder
dd_H	equ	dd_C+2		; B current logical head
dd_R	equ	dd_H+1		; B current physical record
dd_csv	equ	dd_R+1		; L o checksum vector
dd_inac	equ	dd_csv+4	; B drive inactivity timer
dittim	equ	7		;   inactive after 7 secs
udttim	equ	4		;   flush buffers during last three secs

*	...this stuff is derived from the DPB...

dd_spa	equ	dd_inac+1	; B sectors per allocation unit
dd_nof	equ	dd_spa+1	; B number of FATs
dd_mdb	equ	dd_nof+1	; B media descriptor byte
dd_bps	equ	dd_mdb+1	; W bytes per sector
dd_res	equ	dd_bps+2	; W reserved sectors
dd_ent	equ	dd_res+2	; W number of root directory entries
dd_tot	equ	dd_ent+2	; W total number of sectors in logical volume
dd_spf	equ	dd_tot+2	; W number of sectors per FAT
dd_spt	equ	dd_spf+2	; W sectors per track
dd_noh	equ	dd_spt+2	; W number of heads
dd_hid	equ	dd_noh+2	; W number of hidden sectors
dd_totl	equ	dd_hid+2	; L total number of sectors if TOT=0

dd_fat	equ	dd_totl+4	; X FAT buffer starts here
dd_siz	equ	dd_fat		;   size of DD not including FAT buffer


*********************************************************
*	Structures for Heap Management...               *
*********************************************************

*	Anchor for heap instance...

an_heap	equ	0		; L o head of list of allocated heap items
an_free	equ	an_heap+4	; L o head of list of free heap items
an_hwm	equ	an_free+4	; L o current heap high water mark
an_lim	equ	an_hwm+4	; L o end of heap
an_siz	equ	an_lim+4	;   size of a heap anchor

*	Header for each item in heap...

hh_lst	equ	0		; L o next item in heap
hh_nxt	equ	hh_lst+4	; L o previous item in heap
hh_len	equ	hh_nxt+4	; L length of heap item
hh_flg	equ	hh_len+4	; B flags
hh_fr	equ	0     		;   1 -> item has been freed

hh_sp0	equ	hh_flg+1	; B spare
hh_siz	equ	hh_sp0+1	;   size of a heap item header

*	Debugger Breakpoint...

bp_addr	equ	0		; L address of breakpoint
bp_dis	equ	0		;   1 -> breakpoint is inactive

bp_inst	equ	bp_addr+4	; W instruction at breakpoint
bp_ctr	equ	bp_inst+2	; L breakpoint counter
bp_siz	equ	bp_ctr+4	;   size of debugger breakpoint

dk_ok	equ	$00		; no error
dk_to	equ	$01		; timeout
dk_ret	equ	$02		; error should lead to retry
dk_no	equ	$03		; not open
dk_bn	equ	$04		; bad name
dk_nf	equ	$05		; file or directory or meter not found
dk_ef	equ	$06		; end of file
dk_ov	equ	$07		; overflow
dk_bf	equ	$08		; bad FAT
dk_ro	equ	$09		; file is read only
dk_nd	equ	$0A		; file is not a directory
dk_nq	equ	$0B		; directory is not quick
dk_de	equ	$0C		; data error
bk_dd	equ	$40		; data did not store
bk_lk	equ	$41		; linked locations
er_om	equ	-3		; out of memory
er_ni	equ	-2		; not implemented
dk_ng	equ	-1		; general error

*********************************************************
*	68K Disassembly flags...			*
*********************************************************

di_bcc	equ	0
di_bsr	equ	1
di_chk	equ	2
di_db	equ	3
di_jmp	equ	4
di_jsr	equ	5
di_t	equ	6
di_tv	equ	7

*********************************************************
*	GPU Disassembly flags...			*
*********************************************************

R1_REG	equ	0		; reg1 is a data register 
R1_ADDR	equ	1		; reg1 is a register used as address 
R1_QK_A	equ	2		; reg1 is quick data (1-32) 
R1_QK_B	equ	3		; reg1 is quick data (-16 - +15) 
R1_QK_C	equ	4		; reg1 is quick data (0-31) 
R1_OFFS	equ	5		; reg1 is offset data (1-32) 
R1_REL_JUMP equ	6		; reg1 is rel. jump offset (-16 - +15)
R1_PC	equ	7		; reg1 is the PC 
R1_MASK	equ	7		; mask to test for above 

* permitted destination operands 

R2_REG	equ	0		; reg2 is a data register 
R2_ADDR	equ	8		; reg2 is a register used as address 
R2_OFFS	equ	16		; reg2 is offset data (1-16) 
R2_CC	equ	24		; reg2 is a condition code 
R2_MASK	equ	24		; mask to test for above 

IMM_DATA equ	32		; instruction followed by imm. data 
SWAP_OP	equ	64		; swap reg1 and reg2 before disassembling

*********************************************************
*	System Variables...                             *
*********************************************************

sv_xvec	equ	0		; X exception vectors
sv_heap	equ	sv_xvec+4*256	; X anchor for JDOS heap

*	68K Debugger...

sv_dmpa	equ	sv_heap+an_siz	; L default addr. for debugger "DUMP" command
sv_dmpn	equ	sv_dmpa+4	; L default number of bytes to dump
sv_disa	equ	sv_dmpn+4	; L default addr. for debugger "DIS" command
sv_disn	equ	sv_disa+4	; L default number of lines to disassemble
sv_crun	equ	sv_disn+4	; L def. no. instr. to "CRuise" through
sv_badd	equ	sv_crun+4	; L def. address of blocks for block ops
sv_bsiz	equ	sv_badd+4	; L def. size of blocks for block ops
sv_plen	equ	sv_bsiz+4	; W length of pattern
sv_curf	equ	sv_plen+4	; W flags for current instruction
sv_nxti	equ	sv_curf+2	; L address of instruction after current
sv_dflg	equ	sv_nxti+4	; B flags:
mgdis	equ	0		;   1 -> disable early debugger messages

*	GPU Debugger...

sv_gflg	equ	sv_dflg+1	; B flags:
nextjr	equ	0		;   1 -> next instruction is a jump relative
lastjr	equ	1		;   1 -> last  instruction was a jump relative
gpuint	equ	2		;   1 -> GPU interrupt has occurred

sv_gdua	equ	sv_gflg+1	; L def. addr. for GPU debugger "DUMP" command
sv_gdun	equ	sv_gdua+4	; L default number of bytes to dump
sv_gdia	equ	sv_gdun+4	; L default addr. for GPU debugger "DIS" cmnd

sv_gsad	equ	sv_gdia+4	; L start address of last GPU prog loaded
sv_garg	equ	sv_gsad+4	; L address of 68K reg args in GP memory

sv_lstj	equ	sv_garg+4	; W last jump relative

*	GPU General...

sv_gpnx	equ	sv_lstj+2	; L GPU IH's link to next IH

*	Disk stuff...

sv_drv	equ	sv_gpnx+4	; B drive char of current drive, or 0

sv_dout	equ	sv_drv+1	; B memory copy of FDC digital out register
sv_cbuf	equ	sv_dout+1	; X FDC command buffer
sv_rbuf	equ	sv_cbuf+9	; X FDC result buffer

sv_int1	equ	sv_rbuf+8	; B soft copy of interrupt control register

sv_dent	equ	sv_int1+1	; X file pos of 1st deleted entry in directory

sv_sem	equ	sv_dent+fp_siz	; B semphore for GPU to signal FDC I/O done

sv_sp0	equ	sv_sem+1	; B spare

*	Serial...

sv_rxh1	equ	sv_sp0+1	; L serial channel 1 rx interrupt handler
sv_txh1	equ	sv_rxh1+4	; L serial channel 1 tx interrupt handler
sv_sth1	equ	sv_txh1+4	; L serial channel 1 status interrupt handler
sv_rxh2	equ	sv_sth1+4	; L serial channel 2 rx interrupt handler
sv_txh2	equ	sv_rxh1+4	; L serial channel 2 tx interrupt handler
sv_sth2	equ	sv_txh1+4	; L serial channel 2 status interrupt handler

*	Mouse 1...

sv_m1tr	equ	sv_sth2		; L mouse 1 tri-byte shift register
sv_m1dx	equ	sv_m1tr+4	; L mouse 1 last delta x
sv_m1x	equ	sv_m1dx+4	; L mouse 1 x-pos
sv_m1dy	equ	sv_m1x+4	; L mouse 1 last delta y
sv_m1y	equ	sv_m1dy+4	; L mouse 1 y-pos

*	Mouse 2...

sv_m2tr	equ	sv_m1y+4	; L mouse 2 tri-byte shift register
sv_m2dx	equ	sv_m2tr+4	; L mouse 2 last delta x
sv_m2x	equ	sv_m2dx+4	; L mouse 2 x-pos
sv_m2dy	equ	sv_m2x+4	; L mouse 2 last delta y
sv_m2y	equ	sv_m2dy+4	; L mouse 2 y-pos

*	Buffers and arrays...

sv_dvec	equ	sv_m2y+4	; X drive vector
sv_wd	equ	sv_dvec+4*no_drv ;X current WD

sv_bp	equ	sv_wd+pth_len	; X debugger breakpoints
sv_pat	equ	sv_bp+bp_siz*num_bp ; X pattern for debugger block ops
sv_lcom	equ	sv_pat+com_siz	; X last command
sv_siz	equ	sv_lcom+com_siz	;  size of a set of system variables
