;---------------------------------------------------------------------
;Exported functions and variables
;---------------------------------------------------------------------


				global olist,clear_op_list
				global olist,set_op_list
				global olist,set_op_list_sz
				global olist,set_obj_dptr
				global olist,set_obj_y
				global olist,set_obj_ht
				global olist,refresh_opl

				global olist,num_obj
				global olist,pre_obj_list
				global olist,obj_list_buffer


MAX_OBJECTS     equ 16



;---------------------------------------------------------------------
;Defines for object list data - FIRST PHRASE FLAGS
;---------------------------------------------------------------------

TYPE_NOSCALE	equ $00000000			;no scaling, bits 0-2
TYPE_SCALED		equ $00000001			;scaled bitmap
TYPE_GP			equ $00000002			;Graphics processor object
TYPE_BRANCH		equ $00000003			;branch object
TYPE_STOP		equ $00000004			;stop object

BR_YPOSEQ		equ $00000000			;YPOS == VC or YPOS == $7FF
BR_YPOSGT		equ $00004000			;YPOS > VC
BR_YPOSLT		equ $00008000			;YPOS < VC
BR_OPSET		equ $0000C000			;if O/P flag set
BR_HLINE1		equ $00010000			;if Half Line == 1


;SECOND PHRASE FLAGS (low order DWORD) -------------------------------

DEPTH_1			equ $00000000			;monochrome
DEPTH_2			equ $00001000			;4 colour
DEPTH_4			equ $00002000			;16 colour
DEPTH_8			equ $00003000			;256 colour
DEPTH_16		equ $00004000			;CRY
DEPTH_24		equ $00005000			;24 bit RGB

PITCH_0			equ $00000000			;repeat same phrase
PITCH_1			equ $00008000			;contiguous phrases
PITCH_2			equ $00010000			;skip 1 phrase
PITCH_3			equ $00018000			;skip 2 phrases
PITCH_4			equ $00020000			;skip 3 phrases
PITCH_5			equ $00028000			;skip 4 phrases
PITCH_6			equ $00030000			;skip 5 phrases
PITCH_7			equ $00038000			;skip 6 phrases


;SECOND PHRASE FLAGS (high order DWORD) ------------------------------

REFLECTBIT		equ $00002000			;reflect bit (bit 45)
RMWBIT			equ $00004000			;RMW bit (bit 46)
TRANSBIT		equ $00008000			;Logical colour zero transparent (bit 47)
RELEASEBIT		equ $00010000			;release bus (bit 48)


;---------------------------------------------------------------------
;Structure for expanded object definition
;---------------------------------------------------------------------

				STRUCT expanded_obj

				ELEMENT obj_phrase1h,DWORD	;phrase 1 data (high DWORD)
				ELEMENT obj_phrase1l,DWORD	;phrase 1 data (low DWORD)
				ELEMENT obj_phrase2h,DWORD	;phrase 2 data (high DWORD)
				ELEMENT obj_phrase2l,DWORD	;phrase 2 data (low DWORD)
				ELEMENT obj_phrase3h,DWORD	;phrase 3 data (high DWORD)
				ELEMENT obj_phrase3l,DWORD	;phrase 3 data (low DWORD)

				ENDS expanded_obj

