;=====================================================================
;Include file for the fractal landscape generation code.
;=====================================================================

				global scape,localmap

				global scape,fractalscape



;=====================================================================
;Macros and defines used to make the landscape generation code more
;readable.

MAPSIZE			equ WORLDSIZE		;actual map width
MAPMASK			equ (MAPSIZE-1)
MAPHADDON		equ (MAPSIZE+1)		;extra row and columns stored
MAXHEIGHT		equ 2048			;must be power of 2 and low enough
MAXHEIGHT2		equ 4096			;so that 9 adds cannot exceed signed word
COLRSCALE		equ (2*MAXHEIGHT)/256	;scale height for 256 lookups
COLRSHFT		equ (4+1)			;shift for above
SEACOLR1		equ 60
SEACOLR2		equ 70				;sea colours (stipples + random)


;---------------------------------------------------------------------

UNITLENGTH		equ 4096			;unit length in Cybermorph

LIGHTX			equ lightX
LIGHTY			equ lightY
LIGHTZ			equ lightZ
AMBIENTA		equ lightAMB		;ambient light colour

LIGHTLEN		equ UNITLENGTH		;ROOT3(X*X + Y*Y + Z*Z)
TILESIZE		equ 512				;Cybermorph tile size
LIGHTSHFT		equ 4				;UNITLENGTH / 256 (scale intensity 0-255)



;---------------------------------------------------------------------

				STRUCT fracmap

				ELEMENT frac.colr,BYTE	;CRY colour component
				ELEMENT frac.i,BYTE		;CRY intensity component
				ELEMENT frac.ht,WORD	;height information

				ENDS fracmapsz


;---------------------------------------------------------------------

FRAND			macro					;h1,DDD
				sub.w #MAXHEIGHT/2,\1
				addq.w #1,\2
				muls \2,\1				;(h1-maxheight)*(DDD+1)
				subq.w #1,\2
				asr.w \2,\1				;(h1-maxheight)*(DDD+1) >> DDD
				endm
