;=====================================================================
;Header file to be included by any files generating sounds.
;---------------------------------------------------------------------
;
;Sound effects take the following format:
;
;			HI BYTE		:	LOBYTE
;
;			priority	:	sfx number
;
;---------------------------------------------------------------------


DSPBLOCK		equ $F1CFE0				;DSP data block (in internal DSP mem)


SFXSZ			equ 1					;size of sound effect element
SFXPRI0			equ 0*256
SFXPRI1			equ 1*256
SFXPRI2			equ 2*256
SFXPRI3			equ 3*256
SFXPRI4			equ 4*256
SFXPRI5			equ 5*256
SFXPRI6			equ 6*256
SFXPRI7			equ 7*256				;various priorities


;Pitch Bend definitions (8.8 number) ---------------------------------

PITCHBEND_200	equ $0C00				;raise 1 octave
PITCHBEND_175	equ $0900				;9 semitones
PITCHBEND_150	equ $0600				;6		"
PITCHBEND_125	equ $0300				;3		"
PITCHBEND_100	equ $0000
PITCHBEND_75	equ $fa00				;-6 semitones
PITCHBEND_50	equ $f400				;lower 1 octave
PITCHBEND_40	equ $f000				;approx
PITCHBEND_30	equ $ec00				;approx
PITCHBEND_25	equ $e800				;lower 2 octaves
PITCHBEND_20	equ $e000				;approx


;API function numbers ------------------------------------------------

APIINITSOUND	equ (0*65536)
APIEXITSOUND	equ (1*65536)
APIMASTERVOL	equ (2*65536)
APIVOICETABLE	equ (3*65536)
APIPROCESSSTAT	equ (4*65536)			;?

APIPAUSESOUND	equ (7*65536)

APISTARTSFX		equ (8*65536)
APISETSFX		equ (9*65536)
APISTOPSFX		equ (10*65536)
APISFXSTATUS	equ (11*65536)

APISTARTTUNE	equ (12*65536)
APISETTUNE		equ (13*65536)
APISTOPTUNE		equ (14*65536)
APITUNESTATUS	equ (15*65536)


;Various group assignments (volume control / panning etc) ------------

SFXGROUP		equ 1
ENGINEGROUP		equ 2
HOLLYGROUP		equ 3


;Sound effect numbers and priorities ---------------------------------

SFX_FIRELASER	equ 0*SFXSZ+SFXPRI0
SFX_FIREMINE	equ 1*SFXSZ+SFXPRI0
SFX_LOSEWEAPON	equ 2*SFXSZ+SFXPRI0
SFX_DROPCOLLECT	equ 3*SFXSZ+SFXPRI0
SFX_PLAYERHIT	equ 4*SFXSZ+SFXPRI0
SFX_ENEMYHIT	equ 4*SFXSZ+SFXPRI0
SFX_POLLUTEHIT	equ 4*SFXSZ+SFXPRI0
SFX_BUILDINGHIT	equ 4*SFXSZ+SFXPRI0
SFX_MINEEXPLODE	equ 4*SFXSZ+SFXPRI0
SFX_INPORTAL	equ 5*SFXSZ+SFXPRI0
SFX_PLAYERDEAD	equ 6*SFXSZ+SFXPRI0
SFX_ENEMYDEAD	equ 6*SFXSZ+SFXPRI0
SFX_GOTCOLLECT	equ 7*SFXSZ+SFXPRI0
SFX_GOTSPECIAL	equ 7*SFXSZ+SFXPRI0
SFX_USETHUNDER	equ 8*SFXSZ+SFXPRI0
SFX_TRANSPORT	equ 9*SFXSZ+SFXPRI0
SFX_MESSAGEUP	equ 10*SFXSZ+SFXPRI0
SFX_TELEPRINT	equ 11*SFXSZ+SFXPRI0
SFX_ENEMYFIRE	equ 12*SFXSZ+SFXPRI0
SFX_FIREFIRE	equ 13*SFXSZ+SFXPRI0
SFX_FIREBOMB	equ 14*SFXSZ+SFXPRI0
SFX_BONUSRING	equ 15*SFXSZ+SFXPRI0
SFX_NEGATIVE	equ 16*SFXSZ+SFXPRI7
SFX_POSITIVE	equ 17*SFXSZ+SFXPRI7
SFX_GOTPOWER	equ 18*SFXSZ+SFXPRI0

SFX_GOODLUCK	equ 19*SFXSZ+SFXPRI6
SFX_WELLDONE	equ 20*SFXSZ+SFXPRI2
SFX_PORTALUP	equ 21*SFXSZ+SFXPRI6
;;;;SFX_POWERLOW	equ 22*SFXSZ+SFXPRI6	;NOT USED
SFX_SCANNERJ	equ 23*SFXSZ+SFXPRI4
SFX_ENTERING	equ 24*SFXSZ+SFXPRI6		:WAS 'SFX_WARNING'

SFX_ENGINE		equ 25*SFXSZ+SFXPRI7

SFX_ONEMORE		equ 34*SFXSZ+SFXPRI2
SFX_INTROUBLE	equ 35*SFXSZ+SFXPRI6
SFX_OUCH		equ 36*SFXSZ+SFXPRI2
SFX_WHERE		equ 37*SFXSZ+SFXPRI4
SFX_GOODSHOT	equ 38*SFXSZ+SFXPRI2
SFX_AVOIDGND	equ 39*SFXSZ+SFXPRI4
SFX_GOODPLAY	equ 40*SFXSZ+SFXPRI2


;Macro interface to the sound routines - allows independant code -----

PLAYSFX			macro
				IFNC '\1','d0'
				IFNC '\1','D0'
				move.w #\1,d0
				ENDC
				ENDC
				bsr dosfx
				endm


DISTSFX			macro
				move.w #\1,d0
				bsr distsfx
				endm


DOSPEECH		macro
				IFNC '\1','d0'
				IFNC '\1','D0'
				move.w #\1,d0
				ENDC
				ENDC
				bsr HollySpeech
				endm
				

;---------------------------------------------------------------------

				global sound,InitSound
				global sound,setdfaultvols

				global sound,pausesound

				global sound,dosfx
				global sound,distsfx
				global sound,setsfx
				global sound,stopsfx

				global sound,stopsound

				global sound,HollySpeech
				global sound,setHolly
				global sound,stopHolly

				global sound,startengine
				global sound,stopengine
				global sound,setengine

				global sound,starttune
				global sound,settune
				global sound,stoptune

				global sound,enginevol
				global sound,sfxvol
				global sound,tunevol	;actually HOLLY VOLUME!

				global sound,MID_PAN
				global sound,MAX_VOL

				global soundfx,voicetable
				global soundfx,CyberTune
				global soundfx,WonTune
				global soundfx,GameOverTune
