

				STRUCT object3d

				ELEMENT obj.x,WORD				;world object centre X
				ELEMENT obj.y,WORD				;world object centre Y
				ELEMENT obj.z,WORD				;world object centre Z
				ELEMENT obj.xa,WORD				;rotation around x-axis
				ELEMENT obj.ya,WORD				;rotation around y-axis
				ELEMENT obj.za,WORD				;rotation around z-axis
				ELEMENT obj.shp,DWORD,ALIGNLONG	;pointer to shape def for object
				ELEMENT obj.type,WORD	;type + I.Q.
				ELEMENT obj.mover,DWORD	;routine which moves this obj
				ELEMENT obj.dx,WORD			;required for movement in world
				ELEMENT obj.dz,WORD			;as above
				ELEMENT	obj.airresist,WORD	;air resistance *16384
				ELEMENT	obj.collrad,WORD	;collision radius			


				ENDS	object3d


				STRUCT	animobj

				INHERIT	object3d

				ELEMENT	anm.animspd,WORD
				ELEMENT	anm.currframe,WORD
				ELEMENT	anm.animcnt,WORD
				ELEMENT	anm.numframe,WORD
				ELEMENT	anm.baseframe,WORD

				ENDS	animobj


;----------------- Real Structures ------------------------------------


	
				STRUCT	enemy

				INHERIT	animobj

				ELEMENT	nme.grdheight,WORD	;height of object above ground
				ELEMENT	nme.counter0,WORD	;general purpose counter

				ELEMENT nme.objyr,WORD		;required rotation around y-axis
				ELEMENT nme.maxrot,WORD		;maximum rotation speed
				ELEMENT nme.geriatric,WORD	;how slow / fast we poll environment
				ELEMENT nme.counter,WORD	;counter for geriatric
				ELEMENT nme.detcone,WORD	;detection cone size

				ELEMENT nme.ferocity,WORD	;attack prowess
				ELEMENT nme.timidity,WORD	;how quickly we run away
				ELEMENT nme.firecone,WORD	;fire cone size

				ENDS enemy,ALIGNLONG



				STRUCT	player

				INHERIT	animobj

				ELEMENT	plr.grdheight,WORD	;height of object above ground
				ELEMENT	plr.counter0,WORD	;general purpose counter

				ENDS player,ALIGNLONG



				STRUCT	missile

				INHERIT	animobj

				ELEMENT	mis.grdheight,WORD	;height of object above ground
				ELEMENT	mis.counter0,WORD	;general purpose counter
				ELEMENT mis.objyr,WORD		;required rotation around y-axis
				ELEMENT mis.maxrot,WORD		;maximum rotation speed
				ELEMENT mis.geriatric,WORD	;how slow / fast we poll environment
				ELEMENT mis.counter,WORD	;counter for geriatric
				ELEMENT mis.detcone,WORD	;detection cone size

				ENDS missile,ALIGNLONG



				; SET obj3dsz to the LARGEST of the structures


obj3dsz			set		player

				IFGT	enemy-player
obj3dsz			set		enemy
				ENDC
				
				IFGT	missile-enemy
obj3dsz			set		missile
				ENDC

