;---------------------------------------------------------------------
;PAL setup
;---------------------------------------------------------------------

pal_vclk		equ	376			;Video clock period in timbo secs (1ts=100ps)
pal_horiz_per	equ	320000 		;32us
pal_sync_per	equ	47000		;4.7us
pal_eq_per		equ	23500		;2.35us
pal_front_porch	equ	16500		;1.65us
pal_line_blank	equ	120500		;12.05us

pal_disp_width	equ	1280		;pixels
pal_disp_height	equ	240			;pixels

pal_n_vp		equ	623

pal_n_vbe		equ	33
pal_n_vbb		equ	611
pal_n_veb		equ	614
pal_n_vs		equ	619

pal_n_hp		equ	(pal_horiz_per/pal_vclk)
pal_n_hbb		equ	((pal_horiz_per-pal_sync_per-pal_front_porch)/pal_vclk)+$400
pal_n_hbe		equ	(pal_line_blank-pal_sync_per-pal_front_porch)/pal_vclk
pal_n_hs		equ	((pal_horiz_per-pal_sync_per)/pal_vclk)+$400
pal_n_hvs		equ	(pal_horiz_per-(2*pal_sync_per))/pal_vclk
pal_n_heq		equ	(pal_horiz_per-pal_eq_per)/pal_vclk

pal_n_vee		equ	5


;ONLY THE FOLLOWING ARE INITIALISED BY US ----------------------------

pal_n_vde		equ	609
pal_n_vdb		equ	35
pal_n_hde		equ	((pal_disp_width/2)-1)+$400
pal_n_hdb1		equ	843-(4*320/2)+4
pal_n_hdb2		equ	pal_n_hdb1


;---------------------------------------------------------------------
;NTSC setup
;---------------------------------------------------------------------

nts_vclk		equ	376			;Video clock period in timbo secs (1ts=100ps)
nts_horiz_per	equ	317778 		;31.7us
nts_sync_per	equ	46050		;4.6us
nts_eq_per		equ	23500		;2.35us
nts_front_porch	equ	17450		;1.745us
nts_line_blank	equ	109500		;10.95us

nts_disp_width	equ	1280		;pixels
nts_disp_height	equ	240			;pixels

nts_n_vp		equ	523

nts_n_vbe		equ	18
nts_n_vbb		equ	502
nts_n_veb		equ	512
nts_n_vs		equ	517

nts_n_hp		equ	(nts_horiz_per/nts_vclk)
nts_n_hbb		equ	((nts_horiz_per-nts_sync_per-nts_front_porch)/nts_vclk)+$400
nts_n_hbe		equ	(nts_line_blank-nts_sync_per-nts_front_porch)/nts_vclk
nts_n_hs		equ	((nts_horiz_per-nts_sync_per)/nts_vclk)+$400
nts_n_hvs		equ	(nts_horiz_per-(2*nts_sync_per))/nts_vclk
nts_n_heq		equ	(nts_horiz_per-nts_eq_per)/nts_vclk

nts_n_vee		equ	6


;ONLY THE FOLLOWING ARE INITIALISED BY US ----------------------------

nts_n_vde		equ	500
nts_n_vdb		equ	20
nts_n_hde		equ	((nts_disp_width/2)-1)+$400
nts_n_hdb1		equ 823-(4*320/2)+4
nts_n_hdb2		equ	nts_n_hdb1



;---------------------------------------------------------------------
;Video mode register
;---------------------------------------------------------------------

video_mode		equ	$06C1

