;*******************************************************************************
;
; kA1z0r g33kz 0f teh m3gAm!gHtY D!1d0 F47wA
;
; Pr3s3nTs   " D ! L D 0   B 0 0 T "
;
; Turbo Assembler 1.77
;
;*******************************************************************************

mighty_testmode EQU 1                   ; 0=boot, 1=test, 3=compress ascii

;*******************************************************************************
                PART 'Mighty Compressor'
; * * * * * * * * * * * * * * * * * * * * *
                IF mighty_testmode=3

                OPT D+,W+

                lea     txt(PC),A0         ; start of uncompressed ascii
                bsr     calc_len           ; get length of ascii in d0 and len
                lea     txt(PC),A0         ; source
                lea     dst(PC),A1         ; destination
                moveq   #1,D2              ; rarely used char asc(1)

                bsr.s   copy_txt           ; crunch it
                lea     dst(PC),A0         ; start of packed ascii, a1 holds end
                BREAKPT 'save "crunched.txt",^a0,^a1'


copy_txt:       move.b  (A0)+,D1           ; get character
                cmp.b   #" ",D1            ; space?
                bne.s   copy_txt0          ; nope
                bsr.s   count_spaces       ; d0=number of spaces, a0=after spc
                cmp.b   #1,D0              ; only one?
                bgt.s   more_spaces        ; nope
                move.b  D1,(A1)+           ; just write a single space
                bra.s   copy_txt           ; continue
more_spaces:
                move.b  D2,(A1)+           ; write rare char for recognition
                subq.b  #1,D0              ; for dbra depack number of spc-1
                move.b  D0,(A1)+           ; write no of spaces-1
                bra.s   copy_txt           ; again...
copy_txt0:
                cmp.b   #13,D1             ; CR?
                bne.s   copy_txt1          ; no then copy text
                cmpi.b  #10,(A0)           ; LF?
                bne.s   copy_txt1          ; no then copy text
                clr.b   (A1)+              ; write 0 instead to mark EOL
                bra.s   copy_txt           ; again...
copy_txt1:
                move.b  D1,(A1)+           ; plain text just copy
                tst.b   D1                 ; end of text reached?
                bne.s   copy_txt           ; again...
                clr.b   (A1)+              ; set end marker
                move.l  A1,D7              ; d7=end address
                sub.l   #dst,D7            ; d7=lenght of compressed ascii
                rts
count_spaces:                              ; this routine estimates the number of
                moveq   #0,D0              ; spaces and returns it in d0
count_spaces0:  addq.b  #1,D0
                cmpi.b  #" ",(A0)+
                beq.s   count_spaces0
                lea     -1(A0),A0
                rts
calc_len:                                  ; this routine estimates the lenght
                moveq   #-1,D0             ; of the original ascci art, which
calc_len0:      addq.l  #1,D0              ; has to be terminated by 0
                tst.b   (A0)+
                bne.s   calc_len0
                move.l  D0,len
                rts
; * * * * * * * * * * * * * * * * * * * * *
len:            DC.L 0                  ; len of decompressed ascii
; * * * * * * * * * * * * * * * * * * * * *
txt:            IBYTES 'FINGBOOT.TXT'   ; decompressed ascii
                DC.B 0
                EVEN
; * * * * * * * * * * * * * * * * * * * * *
dst:            DS.B 1024               ; compressed ascii
                EVEN
                ENDC
; * * * * * * * * * * * * * * * * * * * * *
                ENDPART
;******************************************
_membot         EQU $0432
_frclock        EQU $0466
;******************************************
mighty_boot:
                IF mighty_testmode
                clr.w   -(SP)              ; init da mighty test environment
                pea     -1                 ; for debugging
                pea     -1
                move.w  #5,-(SP)
                trap    #14                ; set low rez
                lea     $0C(SP),SP

                clr.w   $FFFF825E.w

                lea     inflate(PC),A1     ; location of mighty free memory
                ELSE
                movea.l _membot.w,A1       ; location of free memory
                ENDC
                lea     ctxt(PC),A0        ; location of mighty compressed ascii
depack_txt:     move.b  (A0)+,D0           ; read char
                cmp.b   #1,D0              ; equal to mighty token?
                bne.s   no_space           ; obviously not
                move.b  (A0)+,D0           ; read number of compressed spaces-1
                ext.w   D0                 ; word! mighty extension to
copy_spaces:    move.b  #" ",(A1)+         ; copy spaces to target location
                dbra    D0,copy_spaces     ; repeat until all spaces are done
                bra.s   depack_txt         ; again...
no_space:       move.b  D0,(A1)+           ; copy unpacked char to target loc
                tst.b   D0                 ; end of line reached?
                bne.s   depack_txt         ; no then again...
                tst.b   (A0)               ; end ot text reached?
                beq.s   out                ; then we are done
                move.b  #13,(A1)+          ; otherwise write linebreak
                move.b  #7,(A1)+           ; and some bells and whistles
                clr.b   (A1)+              ; end of line marker
                bra.s   depack_txt         ; again
out:            clr.b   (A1)+              ; set end of text marker
; * * * * * * * * * * * * * * * * * * * * *
again:
                IF mighty_testmode
                lea     inflate(PC),A0     ; address of decompressed ascii
                ELSE
                movea.l _membot,A0         ; address of decompressed ascii
                ENDC
mighty_print:

                clr.l   _frclock.w         ; clr mighty frameclock (vbl_cnt)
wvbl:           tst.l   _frclock.w         ; check if still same frame
                beq.s   wvbl               ; wait till next frame

                pea     (A0)               ; print one line of mighty ascii
                move.w  #9,-(SP)
                trap    #1
                addq.l  #2,SP              ; "remove" function no from stack

                movea.l (SP)+,A0           ; get start of last line
seek_end:       tst.b   (A0)+              ; search for the end of the line
                bne.s   seek_end
                tst.b   (A0)               ; end of text reached?
                bne.s   mighty_print       ; no then print again
                cmpi.b  #$39,$FFFFFC02.w   ; check for mighty spacebar
                bne.s   again              ; no space? then again
                IF mighty_testmode
                illegal                    ; into debugger
                ENDC
                rts
; * * * * * * * * * * * * * * * * * * * * *
ctxt:           IBYTES 'CRUNCHED.TXT'   ; da mighty ascii art (compressed)
                EVEN
; * * * * * * * * * * * * * * * * * * * * *
                BSS
; * * * * * * * * * * * * * * * * * * * * *
inflate:        DS.B 1024               ; for testmode only
; * * * * * * * * * * * * * * * * * * * * *
                END
